// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
 */
public class JobTemplate private constructor(builder: Builder) {
    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     */
    public val accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = builder.accelerationSettings
    /**
     * An identifier for this resource that is unique within all of AWS.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * An optional category you create to organize your job templates.
     */
    public val category: kotlin.String? = builder.category
    /**
     * The timestamp in epoch seconds for Job template creation.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An optional description you create for each job template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Optional list of hop destinations.
     */
    public val hopDestinations: List<HopDestination>? = builder.hopDestinations
    /**
     * The timestamp in epoch seconds when the Job template was last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * A name you create for each job template. Each name must be unique within your account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Relative priority on the job.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
     */
    public val queue: kotlin.String? = builder.queue
    /**
     * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
     */
    public val settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = builder.settings
    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     */
    public val statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = builder.statusUpdateInterval
    /**
     * A job template can be of two types: system or custom. System or built-in job templates can't be modified or deleted by the user.
     */
    public val type: aws.sdk.kotlin.services.mediaconvert.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobTemplate(")
        append("accelerationSettings=$accelerationSettings,")
        append("arn=$arn,")
        append("category=$category,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("hopDestinations=$hopDestinations,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("priority=$priority,")
        append("queue=$queue,")
        append("settings=$settings,")
        append("statusUpdateInterval=$statusUpdateInterval,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerationSettings?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hopDestinations?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateInterval?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobTemplate

        if (accelerationSettings != other.accelerationSettings) return false
        if (arn != other.arn) return false
        if (category != other.category) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (hopDestinations != other.hopDestinations) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (settings != other.settings) return false
        if (statusUpdateInterval != other.statusUpdateInterval) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         */
        public var accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = null
        /**
         * An identifier for this resource that is unique within all of AWS.
         */
        public var arn: kotlin.String? = null
        /**
         * An optional category you create to organize your job templates.
         */
        public var category: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for Job template creation.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description you create for each job template.
         */
        public var description: kotlin.String? = null
        /**
         * Optional list of hop destinations.
         */
        public var hopDestinations: List<HopDestination>? = null
        /**
         * The timestamp in epoch seconds when the Job template was last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name you create for each job template. Each name must be unique within your account.
         */
        public var name: kotlin.String? = null
        /**
         * Relative priority on the job.
         */
        public var priority: kotlin.Int = 0
        /**
         * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
         */
        public var queue: kotlin.String? = null
        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
         */
        public var settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = null
        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         */
        public var statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = null
        /**
         * A job template can be of two types: system or custom. System or built-in job templates can't be modified or deleted by the user.
         */
        public var type: aws.sdk.kotlin.services.mediaconvert.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.JobTemplate) : this() {
            this.accelerationSettings = x.accelerationSettings
            this.arn = x.arn
            this.category = x.category
            this.createdAt = x.createdAt
            this.description = x.description
            this.hopDestinations = x.hopDestinations
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.priority = x.priority
            this.queue = x.queue
            this.settings = x.settings
            this.statusUpdateInterval = x.statusUpdateInterval
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = JobTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings] inside the given [block]
         */
        public fun accelerationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.Builder.() -> kotlin.Unit) {
            this.accelerationSettings = aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.invoke(block)
        }
    }
}
