// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your HLS outputs.
 */
public class M3U8Settings private constructor(builder: Builder) {
    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     */
    public val audioDuration: aws.sdk.kotlin.services.mediaconvert.model.M3U8AudioDuration? = builder.audioDuration
    /**
     * The number of audio frames to insert for each PES packet.
     */
    public val audioFramesPerPes: kotlin.Int = builder.audioFramesPerPes
    /**
     * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation.
     */
    public val audioPids: List<Int>? = builder.audioPids
    /**
     * If you select ALIGN_TO_VIDEO, MediaConvert writes captions and data packets with Presentation Timestamp (PTS) values greater than or equal to the first video packet PTS (MediaConvert drops captions and data packets with lesser PTS values). Keep the default value (AUTO) to allow all PTS values.
     */
    public val dataPtsControl: aws.sdk.kotlin.services.mediaconvert.model.M3U8DataPtsControl? = builder.dataPtsControl
    /**
     * Specify the maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
     */
    public val maxPcrInterval: kotlin.Int = builder.maxPcrInterval
    /**
     * If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
     */
    public val nielsenId3: aws.sdk.kotlin.services.mediaconvert.model.M3U8NielsenId3? = builder.nielsenId3
    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     */
    public val patInterval: kotlin.Int = builder.patInterval
    /**
     * When set to PCR_EVERY_PES_PACKET a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
     */
    public val pcrControl: aws.sdk.kotlin.services.mediaconvert.model.M3U8PcrControl? = builder.pcrControl
    /**
     * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID.
     */
    public val pcrPid: kotlin.Int = builder.pcrPid
    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     */
    public val pmtInterval: kotlin.Int = builder.pmtInterval
    /**
     * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream.
     */
    public val pmtPid: kotlin.Int = builder.pmtPid
    /**
     * Packet Identifier (PID) of the private metadata stream in the transport stream.
     */
    public val privateMetadataPid: kotlin.Int = builder.privateMetadataPid
    /**
     * The value of the program number field in the Program Map Table.
     */
    public val programNumber: kotlin.Int = builder.programNumber
    /**
     * Packet Identifier (PID) of the SCTE-35 stream in the transport stream.
     */
    public val scte35Pid: kotlin.Int = builder.scte35Pid
    /**
     * For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE) if you don't want manifest conditioning. Choose Passthrough (PASSTHROUGH) and choose Ad markers (adMarkers) if you do want manifest conditioning. In both cases, also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml).
     */
    public val scte35Source: aws.sdk.kotlin.services.mediaconvert.model.M3U8Scte35Source? = builder.scte35Source
    /**
     * Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH) to include ID3 metadata in this output. This includes ID3 metadata from the following features: ID3 timestamp period (timedMetadataId3Period), and Custom ID3 metadata inserter (timedMetadataInsertion). To exclude this ID3 metadata in this output: set ID3 metadata to None (NONE) or leave blank.
     */
    public val timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.TimedMetadata? = builder.timedMetadata
    /**
     * Packet Identifier (PID) of the ID3 metadata stream in the transport stream.
     */
    public val timedMetadataPid: kotlin.Int = builder.timedMetadataPid
    /**
     * The value of the transport stream ID field in the Program Map Table.
     */
    public val transportStreamId: kotlin.Int = builder.transportStreamId
    /**
     * Packet Identifier (PID) of the elementary video stream in the transport stream.
     */
    public val videoPid: kotlin.Int = builder.videoPid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("M3U8Settings(")
        append("audioDuration=$audioDuration,")
        append("audioFramesPerPes=$audioFramesPerPes,")
        append("audioPids=$audioPids,")
        append("dataPtsControl=$dataPtsControl,")
        append("maxPcrInterval=$maxPcrInterval,")
        append("nielsenId3=$nielsenId3,")
        append("patInterval=$patInterval,")
        append("pcrControl=$pcrControl,")
        append("pcrPid=$pcrPid,")
        append("pmtInterval=$pmtInterval,")
        append("pmtPid=$pmtPid,")
        append("privateMetadataPid=$privateMetadataPid,")
        append("programNumber=$programNumber,")
        append("scte35Pid=$scte35Pid,")
        append("scte35Source=$scte35Source,")
        append("timedMetadata=$timedMetadata,")
        append("timedMetadataPid=$timedMetadataPid,")
        append("transportStreamId=$transportStreamId,")
        append("videoPid=$videoPid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDuration?.hashCode() ?: 0
        result = 31 * result + (audioFramesPerPes)
        result = 31 * result + (audioPids?.hashCode() ?: 0)
        result = 31 * result + (dataPtsControl?.hashCode() ?: 0)
        result = 31 * result + (maxPcrInterval)
        result = 31 * result + (nielsenId3?.hashCode() ?: 0)
        result = 31 * result + (patInterval)
        result = 31 * result + (pcrControl?.hashCode() ?: 0)
        result = 31 * result + (pcrPid)
        result = 31 * result + (pmtInterval)
        result = 31 * result + (pmtPid)
        result = 31 * result + (privateMetadataPid)
        result = 31 * result + (programNumber)
        result = 31 * result + (scte35Pid)
        result = 31 * result + (scte35Source?.hashCode() ?: 0)
        result = 31 * result + (timedMetadata?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataPid)
        result = 31 * result + (transportStreamId)
        result = 31 * result + (videoPid)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as M3U8Settings

        if (audioDuration != other.audioDuration) return false
        if (audioFramesPerPes != other.audioFramesPerPes) return false
        if (audioPids != other.audioPids) return false
        if (dataPtsControl != other.dataPtsControl) return false
        if (maxPcrInterval != other.maxPcrInterval) return false
        if (nielsenId3 != other.nielsenId3) return false
        if (patInterval != other.patInterval) return false
        if (pcrControl != other.pcrControl) return false
        if (pcrPid != other.pcrPid) return false
        if (pmtInterval != other.pmtInterval) return false
        if (pmtPid != other.pmtPid) return false
        if (privateMetadataPid != other.privateMetadataPid) return false
        if (programNumber != other.programNumber) return false
        if (scte35Pid != other.scte35Pid) return false
        if (scte35Source != other.scte35Source) return false
        if (timedMetadata != other.timedMetadata) return false
        if (timedMetadataPid != other.timedMetadataPid) return false
        if (transportStreamId != other.transportStreamId) return false
        if (videoPid != other.videoPid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
         */
        public var audioDuration: aws.sdk.kotlin.services.mediaconvert.model.M3U8AudioDuration? = null
        /**
         * The number of audio frames to insert for each PES packet.
         */
        public var audioFramesPerPes: kotlin.Int = 0
        /**
         * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation.
         */
        public var audioPids: List<Int>? = null
        /**
         * If you select ALIGN_TO_VIDEO, MediaConvert writes captions and data packets with Presentation Timestamp (PTS) values greater than or equal to the first video packet PTS (MediaConvert drops captions and data packets with lesser PTS values). Keep the default value (AUTO) to allow all PTS values.
         */
        public var dataPtsControl: aws.sdk.kotlin.services.mediaconvert.model.M3U8DataPtsControl? = null
        /**
         * Specify the maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
         */
        public var maxPcrInterval: kotlin.Int = 0
        /**
         * If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
         */
        public var nielsenId3: aws.sdk.kotlin.services.mediaconvert.model.M3U8NielsenId3? = null
        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        public var patInterval: kotlin.Int = 0
        /**
         * When set to PCR_EVERY_PES_PACKET a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
         */
        public var pcrControl: aws.sdk.kotlin.services.mediaconvert.model.M3U8PcrControl? = null
        /**
         * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID.
         */
        public var pcrPid: kotlin.Int = 0
        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        public var pmtInterval: kotlin.Int = 0
        /**
         * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream.
         */
        public var pmtPid: kotlin.Int = 0
        /**
         * Packet Identifier (PID) of the private metadata stream in the transport stream.
         */
        public var privateMetadataPid: kotlin.Int = 0
        /**
         * The value of the program number field in the Program Map Table.
         */
        public var programNumber: kotlin.Int = 0
        /**
         * Packet Identifier (PID) of the SCTE-35 stream in the transport stream.
         */
        public var scte35Pid: kotlin.Int = 0
        /**
         * For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE) if you don't want manifest conditioning. Choose Passthrough (PASSTHROUGH) and choose Ad markers (adMarkers) if you do want manifest conditioning. In both cases, also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml).
         */
        public var scte35Source: aws.sdk.kotlin.services.mediaconvert.model.M3U8Scte35Source? = null
        /**
         * Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH) to include ID3 metadata in this output. This includes ID3 metadata from the following features: ID3 timestamp period (timedMetadataId3Period), and Custom ID3 metadata inserter (timedMetadataInsertion). To exclude this ID3 metadata in this output: set ID3 metadata to None (NONE) or leave blank.
         */
        public var timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.TimedMetadata? = null
        /**
         * Packet Identifier (PID) of the ID3 metadata stream in the transport stream.
         */
        public var timedMetadataPid: kotlin.Int = 0
        /**
         * The value of the transport stream ID field in the Program Map Table.
         */
        public var transportStreamId: kotlin.Int = 0
        /**
         * Packet Identifier (PID) of the elementary video stream in the transport stream.
         */
        public var videoPid: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings) : this() {
            this.audioDuration = x.audioDuration
            this.audioFramesPerPes = x.audioFramesPerPes
            this.audioPids = x.audioPids
            this.dataPtsControl = x.dataPtsControl
            this.maxPcrInterval = x.maxPcrInterval
            this.nielsenId3 = x.nielsenId3
            this.patInterval = x.patInterval
            this.pcrControl = x.pcrControl
            this.pcrPid = x.pcrPid
            this.pmtInterval = x.pmtInterval
            this.pmtPid = x.pmtPid
            this.privateMetadataPid = x.privateMetadataPid
            this.programNumber = x.programNumber
            this.scte35Pid = x.scte35Pid
            this.scte35Source = x.scte35Source
            this.timedMetadata = x.timedMetadata
            this.timedMetadataPid = x.timedMetadataPid
            this.transportStreamId = x.transportStreamId
            this.videoPid = x.videoPid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings = M3U8Settings(this)
    }
}
