// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in all output groups. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
 */
public class MotionImageInserter private constructor(builder: Builder) {
    /**
     * If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example, specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png images. This overlay frame rate doesn't need to match the frame rate of the underlying video.
     */
    public val framerate: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionFramerate? = builder.framerate
    /**
     * Specify the .mov file or series of .png files that you want to overlay on your video. For .png files, provide the file name of the first file in the series. Make sure that the names of the .png files end with sequential numbers that specify the order that they are played in. For example, overlay_000.png, overlay_001.png, overlay_002.png, and so on. The sequence must start at zero, and each image file name must have the same number of digits. Pad your initial file names with enough zeros to complete the sequence. For example, if the first image is overlay_0.png, there can be only 10 images in the sequence, with the last image being overlay_9.png. But if the first image is overlay_00.png, there can be 100 images in the sequence.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov file or a series of .png files.
     */
    public val insertionMode: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionMode? = builder.insertionMode
    /**
     * Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels, from the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay to the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales the size up or down with any video scaling.
     */
    public val offset: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionOffset? = builder.offset
    /**
     * Specify whether your motion graphic overlay repeats on a loop or plays only once.
     */
    public val playback: aws.sdk.kotlin.services.mediaconvert.model.MotionImagePlayback? = builder.playback
    /**
     * Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that the timecode you provide here takes into account how you have set up your timecode configuration under both job settings and input settings. The simplest way to do that is to set both to start at 0. If you need to set up your job to follow timecodes embedded in your source that don't start at zero, make sure that you specify a start time that is after the first embedded timecode. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input timecode configuration settings in your JSON job settings specification at settings>timecodeConfig>source and settings>inputs>timecodeSource.
     */
    public val startTime: kotlin.String? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MotionImageInserter(")
        append("framerate=$framerate,")
        append("input=$input,")
        append("insertionMode=$insertionMode,")
        append("offset=$offset,")
        append("playback=$playback,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = framerate?.hashCode() ?: 0
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (insertionMode?.hashCode() ?: 0)
        result = 31 * result + (offset?.hashCode() ?: 0)
        result = 31 * result + (playback?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MotionImageInserter

        if (framerate != other.framerate) return false
        if (input != other.input) return false
        if (insertionMode != other.insertionMode) return false
        if (offset != other.offset) return false
        if (playback != other.playback) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example, specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png images. This overlay frame rate doesn't need to match the frame rate of the underlying video.
         */
        public var framerate: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionFramerate? = null
        /**
         * Specify the .mov file or series of .png files that you want to overlay on your video. For .png files, provide the file name of the first file in the series. Make sure that the names of the .png files end with sequential numbers that specify the order that they are played in. For example, overlay_000.png, overlay_001.png, overlay_002.png, and so on. The sequence must start at zero, and each image file name must have the same number of digits. Pad your initial file names with enough zeros to complete the sequence. For example, if the first image is overlay_0.png, there can be only 10 images in the sequence, with the last image being overlay_9.png. But if the first image is overlay_00.png, there can be 100 images in the sequence.
         */
        public var input: kotlin.String? = null
        /**
         * Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov file or a series of .png files.
         */
        public var insertionMode: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionMode? = null
        /**
         * Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels, from the upper-left corner of the frame. If you don't specify an offset, the service scales your overlay to the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales the size up or down with any video scaling.
         */
        public var offset: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionOffset? = null
        /**
         * Specify whether your motion graphic overlay repeats on a loop or plays only once.
         */
        public var playback: aws.sdk.kotlin.services.mediaconvert.model.MotionImagePlayback? = null
        /**
         * Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that the timecode you provide here takes into account how you have set up your timecode configuration under both job settings and input settings. The simplest way to do that is to set both to start at 0. If you need to set up your job to follow timecodes embedded in your source that don't start at zero, make sure that you specify a start time that is after the first embedded timecode. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input timecode configuration settings in your JSON job settings specification at settings>timecodeConfig>source and settings>inputs>timecodeSource.
         */
        public var startTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter) : this() {
            this.framerate = x.framerate
            this.input = x.input
            this.insertionMode = x.insertionMode
            this.offset = x.offset
            this.playback = x.playback
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter = MotionImageInserter(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionFramerate] inside the given [block]
         */
        public fun framerate(block: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionFramerate.Builder.() -> kotlin.Unit) {
            this.framerate = aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionFramerate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionOffset] inside the given [block]
         */
        public fun offset(block: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionOffset.Builder.() -> kotlin.Unit) {
            this.offset = aws.sdk.kotlin.services.mediaconvert.model.MotionImageInsertionOffset.invoke(block)
        }
    }
}
