// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
 */
public class MpdSettings private constructor(builder: Builder) {
    /**
     * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <accessibility> elements for embedded 608 captions. This markup isn't generally required, but some video players require it to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these elements out. When you enable this setting, this is the markup that MediaConvert includes in your manifest: <accessibility>
     */
    public val accessibilityCaptionHints: aws.sdk.kotlin.services.mediaconvert.model.MpdAccessibilityCaptionHints? = builder.accessibilityCaptionHints
    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     */
    public val audioDuration: aws.sdk.kotlin.services.mediaconvert.model.MpdAudioDuration? = builder.audioDuration
    /**
     * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
     */
    public val captionContainerType: aws.sdk.kotlin.services.mediaconvert.model.MpdCaptionContainerType? = builder.captionContainerType
    /**
     * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and writes each instance to a separate event message box in the output, according to MISB ST1910.1. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
     */
    public val klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.MpdKlvMetadata? = builder.klvMetadata
    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
     */
    public val scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.MpdScte35Esam? = builder.scte35Esam
    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want those SCTE-35 markers in this output.
     */
    public val scte35Source: aws.sdk.kotlin.services.mediaconvert.model.MpdScte35Source? = builder.scte35Source
    /**
     * To include ID3 metadata in this output: Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). Specify this ID3 metadata in Custom ID3 metadata inserter (timedMetadataInsertion). MediaConvert writes each instance of ID3 metadata in a separate Event Message (eMSG) box. To exclude this ID3 metadata: Set ID3 metadata to None (NONE) or leave blank.
     */
    public val timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.MpdTimedMetadata? = builder.timedMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.MpdSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MpdSettings(")
        append("accessibilityCaptionHints=$accessibilityCaptionHints,")
        append("audioDuration=$audioDuration,")
        append("captionContainerType=$captionContainerType,")
        append("klvMetadata=$klvMetadata,")
        append("scte35Esam=$scte35Esam,")
        append("scte35Source=$scte35Source,")
        append("timedMetadata=$timedMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessibilityCaptionHints?.hashCode() ?: 0
        result = 31 * result + (audioDuration?.hashCode() ?: 0)
        result = 31 * result + (captionContainerType?.hashCode() ?: 0)
        result = 31 * result + (klvMetadata?.hashCode() ?: 0)
        result = 31 * result + (scte35Esam?.hashCode() ?: 0)
        result = 31 * result + (scte35Source?.hashCode() ?: 0)
        result = 31 * result + (timedMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MpdSettings

        if (accessibilityCaptionHints != other.accessibilityCaptionHints) return false
        if (audioDuration != other.audioDuration) return false
        if (captionContainerType != other.captionContainerType) return false
        if (klvMetadata != other.klvMetadata) return false
        if (scte35Esam != other.scte35Esam) return false
        if (scte35Source != other.scte35Source) return false
        if (timedMetadata != other.timedMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.MpdSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <accessibility> elements for embedded 608 captions. This markup isn't generally required, but some video players require it to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these elements out. When you enable this setting, this is the markup that MediaConvert includes in your manifest: <accessibility>
         */
        public var accessibilityCaptionHints: aws.sdk.kotlin.services.mediaconvert.model.MpdAccessibilityCaptionHints? = null
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
         */
        public var audioDuration: aws.sdk.kotlin.services.mediaconvert.model.MpdAudioDuration? = null
        /**
         * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
         */
        public var captionContainerType: aws.sdk.kotlin.services.mediaconvert.model.MpdCaptionContainerType? = null
        /**
         * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and writes each instance to a separate event message box in the output, according to MISB ST1910.1. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
         */
        public var klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.MpdKlvMetadata? = null
        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
         */
        public var scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.MpdScte35Esam? = null
        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         */
        public var scte35Source: aws.sdk.kotlin.services.mediaconvert.model.MpdScte35Source? = null
        /**
         * To include ID3 metadata in this output: Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). Specify this ID3 metadata in Custom ID3 metadata inserter (timedMetadataInsertion). MediaConvert writes each instance of ID3 metadata in a separate Event Message (eMSG) box. To exclude this ID3 metadata: Set ID3 metadata to None (NONE) or leave blank.
         */
        public var timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.MpdTimedMetadata? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.MpdSettings) : this() {
            this.accessibilityCaptionHints = x.accessibilityCaptionHints
            this.audioDuration = x.audioDuration
            this.captionContainerType = x.captionContainerType
            this.klvMetadata = x.klvMetadata
            this.scte35Esam = x.scte35Esam
            this.scte35Source = x.scte35Source
            this.timedMetadata = x.timedMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.MpdSettings = MpdSettings(this)
    }
}
