// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
 */
public class NexGuardFileMarkerSettings private constructor(builder: Builder) {
    /**
     * Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
     */
    public val license: kotlin.String? = builder.license
    /**
     * Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
     */
    public val payload: kotlin.Int = builder.payload
    /**
     * Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
     */
    public val preset: kotlin.String? = builder.preset
    /**
     * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
     */
    public val strength: aws.sdk.kotlin.services.mediaconvert.model.WatermarkingStrength? = builder.strength

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.NexGuardFileMarkerSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NexGuardFileMarkerSettings(")
        append("license=$license,")
        append("payload=$payload,")
        append("preset=$preset,")
        append("strength=$strength)")
    }

    override fun hashCode(): kotlin.Int {
        var result = license?.hashCode() ?: 0
        result = 31 * result + (payload)
        result = 31 * result + (preset?.hashCode() ?: 0)
        result = 31 * result + (strength?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NexGuardFileMarkerSettings

        if (license != other.license) return false
        if (payload != other.payload) return false
        if (preset != other.preset) return false
        if (strength != other.strength) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.NexGuardFileMarkerSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
         */
        public var license: kotlin.String? = null
        /**
         * Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
         */
        public var payload: kotlin.Int = 0
        /**
         * Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
         */
        public var preset: kotlin.String? = null
        /**
         * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
         */
        public var strength: aws.sdk.kotlin.services.mediaconvert.model.WatermarkingStrength? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.NexGuardFileMarkerSettings) : this() {
            this.license = x.license
            this.payload = x.payload
            this.preset = x.preset
            this.strength = x.strength
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.NexGuardFileMarkerSettings = NexGuardFileMarkerSettings(this)
    }
}
