// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to specifying these values, you also need to set up your cloud TIC server. These settings apply to every output in your job. The MediaConvert implementation is currently with the following Nielsen versions: Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator &#91;SID_TIC&#93; Version &#91;5.0.0&#93;
 */
public class NielsenNonLinearWatermarkSettings private constructor(builder: Builder) {
    /**
     * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
     */
    public val activeWatermarkProcess: aws.sdk.kotlin.services.mediaconvert.model.NielsenActiveWatermarkProcessType? = builder.activeWatermarkProcess
    /**
     * Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata .zip file. To provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should be in the following format: S3://bucket/path/ADI-file. For more information about the metadata .zip file, see the setting Metadata destination (metadataDestination).
     */
    public val adiFilename: kotlin.String? = builder.adiFilename
    /**
     * Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen non-linear watermarking.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear watermarking.
     */
    public val assetName: kotlin.String? = builder.assetName
    /**
     * Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen account but common to all of your output assets that have CBET watermarking. Required when you choose a value for the setting Watermark types (ActiveWatermarkProcess) that includes CBET.
     */
    public val cbetSourceId: kotlin.String? = builder.cbetSourceId
    /**
     * Optional. If this asset uses an episode ID with Nielsen, provide it here.
     */
    public val episodeId: kotlin.String? = builder.episodeId
    /**
     * Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata .zip file. This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert transcoding. If you want to include an ADI file in this .zip file, use the setting ADI file (adiFilename) to specify it. MediaConvert delivers the Nielsen metadata .zip files only to your metadata destination Amazon S3 bucket. It doesn't deliver the .zip files to Nielsen. You are responsible for delivering the metadata .zip files to Nielsen.
     */
    public val metadataDestination: kotlin.String? = builder.metadataDestination
    /**
     * Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but common to all of your output assets. Required for all Nielsen non-linear watermarking. This ID should be unique to your Nielsen account but common to all of your output assets. Required for all Nielsen non-linear watermarking.
     */
    public val sourceId: kotlin.Int = builder.sourceId
    /**
     * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
     */
    public val sourceWatermarkStatus: aws.sdk.kotlin.services.mediaconvert.model.NielsenSourceWatermarkStatusType? = builder.sourceWatermarkStatus
    /**
     * Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud. Required for all Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server. Instead, you must use API Gateway to provide a RESTful interface between MediaConvert and a TIC server that you deploy in your AWS account. For more information on deploying a TIC server in your AWS account and the required API Gateway, contact Nielsen support.
     */
    public val ticServerUrl: kotlin.String? = builder.ticServerUrl
    /**
     * To create assets that have the same TIC values in each audio track, keep the default value Share TICs (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
     */
    public val uniqueTicPerAudioTrack: aws.sdk.kotlin.services.mediaconvert.model.NielsenUniqueTicPerAudioTrackType? = builder.uniqueTicPerAudioTrack

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NielsenNonLinearWatermarkSettings(")
        append("activeWatermarkProcess=$activeWatermarkProcess,")
        append("adiFilename=$adiFilename,")
        append("assetId=$assetId,")
        append("assetName=$assetName,")
        append("cbetSourceId=$cbetSourceId,")
        append("episodeId=$episodeId,")
        append("metadataDestination=$metadataDestination,")
        append("sourceId=$sourceId,")
        append("sourceWatermarkStatus=$sourceWatermarkStatus,")
        append("ticServerUrl=$ticServerUrl,")
        append("uniqueTicPerAudioTrack=$uniqueTicPerAudioTrack)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeWatermarkProcess?.hashCode() ?: 0
        result = 31 * result + (adiFilename?.hashCode() ?: 0)
        result = 31 * result + (assetId?.hashCode() ?: 0)
        result = 31 * result + (assetName?.hashCode() ?: 0)
        result = 31 * result + (cbetSourceId?.hashCode() ?: 0)
        result = 31 * result + (episodeId?.hashCode() ?: 0)
        result = 31 * result + (metadataDestination?.hashCode() ?: 0)
        result = 31 * result + (sourceId)
        result = 31 * result + (sourceWatermarkStatus?.hashCode() ?: 0)
        result = 31 * result + (ticServerUrl?.hashCode() ?: 0)
        result = 31 * result + (uniqueTicPerAudioTrack?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NielsenNonLinearWatermarkSettings

        if (activeWatermarkProcess != other.activeWatermarkProcess) return false
        if (adiFilename != other.adiFilename) return false
        if (assetId != other.assetId) return false
        if (assetName != other.assetName) return false
        if (cbetSourceId != other.cbetSourceId) return false
        if (episodeId != other.episodeId) return false
        if (metadataDestination != other.metadataDestination) return false
        if (sourceId != other.sourceId) return false
        if (sourceWatermarkStatus != other.sourceWatermarkStatus) return false
        if (ticServerUrl != other.ticServerUrl) return false
        if (uniqueTicPerAudioTrack != other.uniqueTicPerAudioTrack) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
         */
        public var activeWatermarkProcess: aws.sdk.kotlin.services.mediaconvert.model.NielsenActiveWatermarkProcessType? = null
        /**
         * Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata .zip file. To provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should be in the following format: S3://bucket/path/ADI-file. For more information about the metadata .zip file, see the setting Metadata destination (metadataDestination).
         */
        public var adiFilename: kotlin.String? = null
        /**
         * Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen non-linear watermarking.
         */
        public var assetId: kotlin.String? = null
        /**
         * Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear watermarking.
         */
        public var assetName: kotlin.String? = null
        /**
         * Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen account but common to all of your output assets that have CBET watermarking. Required when you choose a value for the setting Watermark types (ActiveWatermarkProcess) that includes CBET.
         */
        public var cbetSourceId: kotlin.String? = null
        /**
         * Optional. If this asset uses an episode ID with Nielsen, provide it here.
         */
        public var episodeId: kotlin.String? = null
        /**
         * Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata .zip file. This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert transcoding. If you want to include an ADI file in this .zip file, use the setting ADI file (adiFilename) to specify it. MediaConvert delivers the Nielsen metadata .zip files only to your metadata destination Amazon S3 bucket. It doesn't deliver the .zip files to Nielsen. You are responsible for delivering the metadata .zip files to Nielsen.
         */
        public var metadataDestination: kotlin.String? = null
        /**
         * Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but common to all of your output assets. Required for all Nielsen non-linear watermarking. This ID should be unique to your Nielsen account but common to all of your output assets. Required for all Nielsen non-linear watermarking.
         */
        public var sourceId: kotlin.Int = 0
        /**
         * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
         */
        public var sourceWatermarkStatus: aws.sdk.kotlin.services.mediaconvert.model.NielsenSourceWatermarkStatusType? = null
        /**
         * Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud. Required for all Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server. Instead, you must use API Gateway to provide a RESTful interface between MediaConvert and a TIC server that you deploy in your AWS account. For more information on deploying a TIC server in your AWS account and the required API Gateway, contact Nielsen support.
         */
        public var ticServerUrl: kotlin.String? = null
        /**
         * To create assets that have the same TIC values in each audio track, keep the default value Share TICs (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
         */
        public var uniqueTicPerAudioTrack: aws.sdk.kotlin.services.mediaconvert.model.NielsenUniqueTicPerAudioTrackType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings) : this() {
            this.activeWatermarkProcess = x.activeWatermarkProcess
            this.adiFilename = x.adiFilename
            this.assetId = x.assetId
            this.assetName = x.assetName
            this.cbetSourceId = x.cbetSourceId
            this.episodeId = x.episodeId
            this.metadataDestination = x.metadataDestination
            this.sourceId = x.sourceId
            this.sourceWatermarkStatus = x.sourceWatermarkStatus
            this.ticServerUrl = x.ticServerUrl
            this.uniqueTicPerAudioTrack = x.uniqueTicPerAudioTrack
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings = NielsenNonLinearWatermarkSettings(this)
    }
}
