// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Noise reducer filter settings for temporal filter.
 */
public class NoiseReducerTemporalFilterSettings private constructor(builder: Builder) {
    /**
     * Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
     */
    public val aggressiveMode: kotlin.Int = builder.aggressiveMode
    /**
     * When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), the bandwidth and sharpness of your output is reduced. You can optionally use Post temporal sharpening (postTemporalSharpening) to apply sharpening to the edges of your output. Note that Post temporal sharpening will also make the bandwidth reduction from the Noise reducer smaller. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply sharpening, depending on your input type and quality. When you set Post temporal sharpening to Enabled (ENABLED), specify how much sharpening is applied using Post temporal sharpening strength (postTemporalSharpeningStrength). Set Post temporal sharpening to Disabled (DISABLED) to not apply sharpening.
     */
    public val postTemporalSharpening: aws.sdk.kotlin.services.mediaconvert.model.NoiseFilterPostTemporalSharpening? = builder.postTemporalSharpening
    /**
     * Use Post temporal sharpening strength (postTemporalSharpeningStrength) to define the amount of sharpening the transcoder applies to your output. Set Post temporal sharpening strength to Low (LOW), Medium (MEDIUM), or High (HIGH) to indicate the amount of sharpening.
     */
    public val postTemporalSharpeningStrength: aws.sdk.kotlin.services.mediaconvert.model.NoiseFilterPostTemporalSharpeningStrength? = builder.postTemporalSharpeningStrength
    /**
     * The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
     */
    public val speed: kotlin.Int = builder.speed
    /**
     * Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
     */
    public val strength: kotlin.Int = builder.strength

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NoiseReducerTemporalFilterSettings(")
        append("aggressiveMode=$aggressiveMode,")
        append("postTemporalSharpening=$postTemporalSharpening,")
        append("postTemporalSharpeningStrength=$postTemporalSharpeningStrength,")
        append("speed=$speed,")
        append("strength=$strength)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggressiveMode
        result = 31 * result + (postTemporalSharpening?.hashCode() ?: 0)
        result = 31 * result + (postTemporalSharpeningStrength?.hashCode() ?: 0)
        result = 31 * result + (speed)
        result = 31 * result + (strength)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NoiseReducerTemporalFilterSettings

        if (aggressiveMode != other.aggressiveMode) return false
        if (postTemporalSharpening != other.postTemporalSharpening) return false
        if (postTemporalSharpeningStrength != other.postTemporalSharpeningStrength) return false
        if (speed != other.speed) return false
        if (strength != other.strength) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
         */
        public var aggressiveMode: kotlin.Int = 0
        /**
         * When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), the bandwidth and sharpness of your output is reduced. You can optionally use Post temporal sharpening (postTemporalSharpening) to apply sharpening to the edges of your output. Note that Post temporal sharpening will also make the bandwidth reduction from the Noise reducer smaller. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply sharpening, depending on your input type and quality. When you set Post temporal sharpening to Enabled (ENABLED), specify how much sharpening is applied using Post temporal sharpening strength (postTemporalSharpeningStrength). Set Post temporal sharpening to Disabled (DISABLED) to not apply sharpening.
         */
        public var postTemporalSharpening: aws.sdk.kotlin.services.mediaconvert.model.NoiseFilterPostTemporalSharpening? = null
        /**
         * Use Post temporal sharpening strength (postTemporalSharpeningStrength) to define the amount of sharpening the transcoder applies to your output. Set Post temporal sharpening strength to Low (LOW), Medium (MEDIUM), or High (HIGH) to indicate the amount of sharpening.
         */
        public var postTemporalSharpeningStrength: aws.sdk.kotlin.services.mediaconvert.model.NoiseFilterPostTemporalSharpeningStrength? = null
        /**
         * The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
         */
        public var speed: kotlin.Int = 0
        /**
         * Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
         */
        public var strength: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings) : this() {
            this.aggressiveMode = x.aggressiveMode
            this.postTemporalSharpening = x.postTemporalSharpening
            this.postTemporalSharpeningStrength = x.postTemporalSharpeningStrength
            this.speed = x.speed
            this.strength = x.strength
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings = NoiseReducerTemporalFilterSettings(this)
    }
}
