// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Each output in your job is a collection of settings that describes how you want MediaConvert to encode a single output file or stream. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/create-outputs.html.
 */
public class Output private constructor(builder: Builder) {
    /**
     * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
     */
    public val audioDescriptions: List<AudioDescription>? = builder.audioDescriptions
    /**
     * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
     */
    public val captionDescriptions: List<CaptionDescription>? = builder.captionDescriptions
    /**
     * Container specific settings.
     */
    public val containerSettings: aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings? = builder.containerSettings
    /**
     * Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not specify a value, the service will use default extensions by container type as follows * MPEG-2 transport stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)
     */
    public val extension: kotlin.String? = builder.extension
    /**
     * Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You specify the base filename as part of your destination URI. When you create multiple outputs in the same output group, Name modifier (NameModifier) is required. Name modifier also accepts format identifiers. For DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output, you must use them in the same way in all outputs of the output group.
     */
    public val nameModifier: kotlin.String? = builder.nameModifier
    /**
     * Specific settings for this type of output.
     */
    public val outputSettings: aws.sdk.kotlin.services.mediaconvert.model.OutputSettings? = builder.outputSettings
    /**
     * Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom preset name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not both.
     */
    public val preset: kotlin.String? = builder.preset
    /**
     * VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
     */
    public val videoDescription: aws.sdk.kotlin.services.mediaconvert.model.VideoDescription? = builder.videoDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Output = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Output(")
        append("audioDescriptions=$audioDescriptions,")
        append("captionDescriptions=$captionDescriptions,")
        append("containerSettings=$containerSettings,")
        append("extension=$extension,")
        append("nameModifier=$nameModifier,")
        append("outputSettings=$outputSettings,")
        append("preset=$preset,")
        append("videoDescription=$videoDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDescriptions?.hashCode() ?: 0
        result = 31 * result + (captionDescriptions?.hashCode() ?: 0)
        result = 31 * result + (containerSettings?.hashCode() ?: 0)
        result = 31 * result + (extension?.hashCode() ?: 0)
        result = 31 * result + (nameModifier?.hashCode() ?: 0)
        result = 31 * result + (outputSettings?.hashCode() ?: 0)
        result = 31 * result + (preset?.hashCode() ?: 0)
        result = 31 * result + (videoDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Output

        if (audioDescriptions != other.audioDescriptions) return false
        if (captionDescriptions != other.captionDescriptions) return false
        if (containerSettings != other.containerSettings) return false
        if (extension != other.extension) return false
        if (nameModifier != other.nameModifier) return false
        if (outputSettings != other.outputSettings) return false
        if (preset != other.preset) return false
        if (videoDescription != other.videoDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Output = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
         */
        public var audioDescriptions: List<AudioDescription>? = null
        /**
         * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
         */
        public var captionDescriptions: List<CaptionDescription>? = null
        /**
         * Container specific settings.
         */
        public var containerSettings: aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings? = null
        /**
         * Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not specify a value, the service will use default extensions by container type as follows * MPEG-2 transport stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)
         */
        public var extension: kotlin.String? = null
        /**
         * Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You specify the base filename as part of your destination URI. When you create multiple outputs in the same output group, Name modifier (NameModifier) is required. Name modifier also accepts format identifiers. For DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output, you must use them in the same way in all outputs of the output group.
         */
        public var nameModifier: kotlin.String? = null
        /**
         * Specific settings for this type of output.
         */
        public var outputSettings: aws.sdk.kotlin.services.mediaconvert.model.OutputSettings? = null
        /**
         * Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom preset name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not both.
         */
        public var preset: kotlin.String? = null
        /**
         * VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
         */
        public var videoDescription: aws.sdk.kotlin.services.mediaconvert.model.VideoDescription? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Output) : this() {
            this.audioDescriptions = x.audioDescriptions
            this.captionDescriptions = x.captionDescriptions
            this.containerSettings = x.containerSettings
            this.extension = x.extension
            this.nameModifier = x.nameModifier
            this.outputSettings = x.outputSettings
            this.preset = x.preset
            this.videoDescription = x.videoDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Output = Output(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings] inside the given [block]
         */
        public fun containerSettings(block: aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings.Builder.() -> kotlin.Unit) {
            this.containerSettings = aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.OutputSettings] inside the given [block]
         */
        public fun outputSettings(block: aws.sdk.kotlin.services.mediaconvert.model.OutputSettings.Builder.() -> kotlin.Unit) {
            this.outputSettings = aws.sdk.kotlin.services.mediaconvert.model.OutputSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.VideoDescription] inside the given [block]
         */
        public fun videoDescription(block: aws.sdk.kotlin.services.mediaconvert.model.VideoDescription.Builder.() -> kotlin.Unit) {
            this.videoDescription = aws.sdk.kotlin.services.mediaconvert.model.VideoDescription.invoke(block)
        }
    }
}
