// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
 */
public class Queue private constructor(builder: Builder) {
    /**
     * An identifier for this resource that is unique within all of AWS.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp in epoch seconds for when you created the queue.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An optional description that you create for each queue.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The timestamp in epoch seconds for when you most recently updated the queue.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * A name that you create for each queue. Each name must be unique within your account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
     */
    public val pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = builder.pricingPlan
    /**
     * The estimated number of jobs with a PROGRESSING status.
     */
    public val progressingJobsCount: kotlin.Int = builder.progressingJobsCount
    /**
     * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
     */
    public val reservationPlan: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan? = builder.reservationPlan
    /**
     * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
     */
    public val status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = builder.status
    /**
     * The estimated number of jobs with a SUBMITTED status.
     */
    public val submittedJobsCount: kotlin.Int = builder.submittedJobsCount
    /**
     * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
     */
    public val type: aws.sdk.kotlin.services.mediaconvert.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Queue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Queue(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("pricingPlan=$pricingPlan,")
        append("progressingJobsCount=$progressingJobsCount,")
        append("reservationPlan=$reservationPlan,")
        append("status=$status,")
        append("submittedJobsCount=$submittedJobsCount,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (progressingJobsCount)
        result = 31 * result + (reservationPlan?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submittedJobsCount)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Queue

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (pricingPlan != other.pricingPlan) return false
        if (progressingJobsCount != other.progressingJobsCount) return false
        if (reservationPlan != other.reservationPlan) return false
        if (status != other.status) return false
        if (submittedJobsCount != other.submittedJobsCount) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Queue = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An identifier for this resource that is unique within all of AWS.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for when you created the queue.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description that you create for each queue.
         */
        public var description: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for when you most recently updated the queue.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name that you create for each queue. Each name must be unique within your account.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
         */
        public var pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = null
        /**
         * The estimated number of jobs with a PROGRESSING status.
         */
        public var progressingJobsCount: kotlin.Int = 0
        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
         */
        public var reservationPlan: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan? = null
        /**
         * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
         */
        public var status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = null
        /**
         * The estimated number of jobs with a SUBMITTED status.
         */
        public var submittedJobsCount: kotlin.Int = 0
        /**
         * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
         */
        public var type: aws.sdk.kotlin.services.mediaconvert.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Queue) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.pricingPlan = x.pricingPlan
            this.progressingJobsCount = x.progressingJobsCount
            this.reservationPlan = x.reservationPlan
            this.status = x.status
            this.submittedJobsCount = x.submittedJobsCount
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Queue = Queue(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan] inside the given [block]
         */
        public fun reservationPlan(block: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan.Builder.() -> kotlin.Unit) {
            this.reservationPlan = aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan.invoke(block)
        }
    }
}
