// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use Manual audio remixing (RemixSettings) to adjust audio levels for each audio channel in each output of your job. With audio remixing, you can output more or fewer audio channels than your input audio source provides.
 */
public class RemixSettings private constructor(builder: Builder) {
    /**
     * Channel mapping (ChannelMapping) contains the group of fields that hold the remixing value for each channel, in dB. Specify remix values to indicate how much of the content from your input audio channel you want in your output audio channels. Each instance of the InputChannels or InputChannelsFineTune array specifies these values for one output channel. Use one instance of this array for each output channel. In the console, each array corresponds to a column in the graphical depiction of the mapping matrix. The rows of the graphical matrix correspond to input channels. Valid values are within the range from -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the output channel (no attenuation or amplification). Use InputChannels or InputChannelsFineTune to specify your remix values. Don't use both.
     */
    public val channelMapping: aws.sdk.kotlin.services.mediaconvert.model.ChannelMapping? = builder.channelMapping
    /**
     * Specify the number of audio channels from your input that you want to use in your output. With remixing, you might combine or split the data in these channels, so the number of channels in your final output might be different. If you are doing both input channel mapping and output channel mapping, the number of output channels in your input mapping must be the same as the number of input channels in your output mapping.
     */
    public val channelsIn: kotlin.Int = builder.channelsIn
    /**
     * Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and even numbers to 64.) If you are doing both input channel mapping and output channel mapping, the number of output channels in your input mapping must be the same as the number of input channels in your output mapping.
     */
    public val channelsOut: kotlin.Int = builder.channelsOut

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.RemixSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemixSettings(")
        append("channelMapping=$channelMapping,")
        append("channelsIn=$channelsIn,")
        append("channelsOut=$channelsOut)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelMapping?.hashCode() ?: 0
        result = 31 * result + (channelsIn)
        result = 31 * result + (channelsOut)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemixSettings

        if (channelMapping != other.channelMapping) return false
        if (channelsIn != other.channelsIn) return false
        if (channelsOut != other.channelsOut) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.RemixSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Channel mapping (ChannelMapping) contains the group of fields that hold the remixing value for each channel, in dB. Specify remix values to indicate how much of the content from your input audio channel you want in your output audio channels. Each instance of the InputChannels or InputChannelsFineTune array specifies these values for one output channel. Use one instance of this array for each output channel. In the console, each array corresponds to a column in the graphical depiction of the mapping matrix. The rows of the graphical matrix correspond to input channels. Valid values are within the range from -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the output channel (no attenuation or amplification). Use InputChannels or InputChannelsFineTune to specify your remix values. Don't use both.
         */
        public var channelMapping: aws.sdk.kotlin.services.mediaconvert.model.ChannelMapping? = null
        /**
         * Specify the number of audio channels from your input that you want to use in your output. With remixing, you might combine or split the data in these channels, so the number of channels in your final output might be different. If you are doing both input channel mapping and output channel mapping, the number of output channels in your input mapping must be the same as the number of input channels in your output mapping.
         */
        public var channelsIn: kotlin.Int = 0
        /**
         * Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and even numbers to 64.) If you are doing both input channel mapping and output channel mapping, the number of output channels in your input mapping must be the same as the number of input channels in your output mapping.
         */
        public var channelsOut: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings) : this() {
            this.channelMapping = x.channelMapping
            this.channelsIn = x.channelsIn
            this.channelsOut = x.channelsOut
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.RemixSettings = RemixSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ChannelMapping] inside the given [block]
         */
        public fun channelMapping(block: aws.sdk.kotlin.services.mediaconvert.model.ChannelMapping.Builder.() -> kotlin.Unit) {
            this.channelMapping = aws.sdk.kotlin.services.mediaconvert.model.ChannelMapping.invoke(block)
        }
    }
}
