// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import kotlin.collections.List

/**
 * Specify how you want your data keys managed. AWS uses data keys to encrypt your content. AWS also encrypts the data keys themselves, using a customer master key (CMK), and then stores the encrypted data keys alongside your encrypted content. Use this setting to specify which AWS service manages the CMK. For simplest set up, choose Amazon S3 (SERVER_SIDE_ENCRYPTION_S3). If you want your master key to be managed by AWS Key Management Service (KMS), choose AWS KMS (SERVER_SIDE_ENCRYPTION_KMS). By default, when you choose AWS KMS, KMS uses the AWS managed customer master key (CMK) associated with Amazon S3 to encrypt your data keys. You can optionally choose to specify a different, customer managed CMK. Do so by specifying the Amazon Resource Name (ARN) of the key for the setting KMS ARN (kmsKeyArn).
 */
public sealed class S3ServerSideEncryptionType {

    public abstract val value: kotlin.String

    public object ServerSideEncryptionKms : aws.sdk.kotlin.services.mediaconvert.model.S3ServerSideEncryptionType() {
        override val value: kotlin.String = "SERVER_SIDE_ENCRYPTION_KMS"
        override fun toString(): kotlin.String = value
    }

    public object ServerSideEncryptionS3 : aws.sdk.kotlin.services.mediaconvert.model.S3ServerSideEncryptionType() {
        override val value: kotlin.String = "SERVER_SIDE_ENCRYPTION_S3"
        override fun toString(): kotlin.String = value
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.mediaconvert.model.S3ServerSideEncryptionType() {
        override fun toString(): kotlin.String = value
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.mediaconvert.model.S3ServerSideEncryptionType = when(str) {
            "SERVER_SIDE_ENCRYPTION_KMS" -> ServerSideEncryptionKms
            "SERVER_SIDE_ENCRYPTION_S3" -> ServerSideEncryptionS3
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.mediaconvert.model.S3ServerSideEncryptionType> = listOf(
            ServerSideEncryptionKms,
            ServerSideEncryptionS3
        )
    }
}
