// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
 */
public class SpekeKeyProvider private constructor(builder: Builder) {
    /**
     * If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate's Amazon Resource Name (ARN) here.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * Relates to SPEKE implementation. DRM system identifiers. DASH output groups support a max of two system ids. Other group types support one system id. See https://dashif.org/identifiers/content_protection/ for more details.
     */
    public val systemIds: List<String>? = builder.systemIds
    /**
     * Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpekeKeyProvider(")
        append("certificateArn=$certificateArn,")
        append("resourceId=$resourceId,")
        append("systemIds=$systemIds,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (systemIds?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpekeKeyProvider

        if (certificateArn != other.certificateArn) return false
        if (resourceId != other.resourceId) return false
        if (systemIds != other.systemIds) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate's Amazon Resource Name (ARN) here.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.
         */
        public var resourceId: kotlin.String? = null
        /**
         * Relates to SPEKE implementation. DRM system identifiers. DASH output groups support a max of two system ids. Other group types support one system id. See https://dashif.org/identifiers/content_protection/ for more details.
         */
        public var systemIds: List<String>? = null
        /**
         * Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider) : this() {
            this.certificateArn = x.certificateArn
            this.resourceId = x.resourceId
            this.systemIds = x.systemIds
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider = SpekeKeyProvider(this)
    }
}
