// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to TELETEXT.
 */
public class TeletextDestinationSettings private constructor(builder: Builder) {
    /**
     * Set pageNumber to the Teletext page number for the destination captions for this output. This value must be a three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the entire set of Teletext data, do not use this field.
     */
    public val pageNumber: kotlin.String? = builder.pageNumber
    /**
     * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page type to the default value Subtitle (PAGE_TYPE_SUBTITLE). If you pass through the entire set of Teletext data, don't use this field. When you pass through a set of Teletext pages, your output has the same page types as your input.
     */
    public val pageTypes: List<TeletextPageType>? = builder.pageTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TeletextDestinationSettings(")
        append("pageNumber=$pageNumber,")
        append("pageTypes=$pageTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pageNumber?.hashCode() ?: 0
        result = 31 * result + (pageTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TeletextDestinationSettings

        if (pageNumber != other.pageNumber) return false
        if (pageTypes != other.pageTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set pageNumber to the Teletext page number for the destination captions for this output. This value must be a three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the entire set of Teletext data, do not use this field.
         */
        public var pageNumber: kotlin.String? = null
        /**
         * Specify the page types for this Teletext page. If you don't specify a value here, the service sets the page type to the default value Subtitle (PAGE_TYPE_SUBTITLE). If you pass through the entire set of Teletext data, don't use this field. When you pass through a set of Teletext pages, your output has the same page types as your input.
         */
        public var pageTypes: List<TeletextPageType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings) : this() {
            this.pageNumber = x.pageNumber
            this.pageTypes = x.pageTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings = TeletextDestinationSettings(this)
    }
}
