// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings specific to caption sources that are specified by track number. Currently, this is only IMSC captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings instead of TrackSourceSettings.
 */
public class TrackSourceSettings private constructor(builder: Builder) {
    /**
     * Use this setting to select a single captions track from a source. Track numbers correspond to the order in the captions source file. For IMF sources, track numbering is based on the order that the captions appear in the CPL. For example, use 1 to select the captions asset that is listed first in the CPL. To include more than one captions track in your job outputs, create multiple input captions selectors. Specify one track per selector.
     */
    public val trackNumber: kotlin.Int = builder.trackNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.TrackSourceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrackSourceSettings(")
        append("trackNumber=$trackNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = trackNumber
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrackSourceSettings

        if (trackNumber != other.trackNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.TrackSourceSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this setting to select a single captions track from a source. Track numbers correspond to the order in the captions source file. For IMF sources, track numbering is based on the order that the captions appear in the CPL. For example, use 1 to select the captions asset that is listed first in the CPL. To include more than one captions track in your job outputs, create multiple input captions selectors. Specify one track per selector.
         */
        public var trackNumber: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.TrackSourceSettings) : this() {
            this.trackNumber = x.trackNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.TrackSourceSettings = TrackSourceSettings(this)
    }
}
