// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to WebVTT captions. WebVTT is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to WebVTT.
 */
public class WebvttDestinationSettings private constructor(builder: Builder) {
    /**
     * Set Accessibility subtitles to Enabled if the ISMC or WebVTT captions track is intended to provide accessibility for people who are deaf or hard of hearing. When you enable this feature, MediaConvert adds the following attributes under EXT-X-MEDIA in the HLS or CMAF manifest for this track: CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and AUTOSELECT="YES". Keep the default value, Disabled, if the captions track is not intended to provide such accessibility. MediaConvert will not add the above attributes.
     */
    public val accessibility: aws.sdk.kotlin.services.mediaconvert.model.WebvttAccessibilitySubs? = builder.accessibility
    /**
     * To use the available style, color, and position information from your input captions: Set Style passthrough (stylePassthrough) to Enabled (ENABLED). MediaConvert uses default settings when style and position information is missing from your input captions. To recreate the input captions exactly: Set Style passthrough to Strict (STRICT). MediaConvert automatically applies timing adjustments, including adjustments for frame rate conversion, ad avails, and input clipping. Your input captions format must be WebVTT. To ignore the style and position information from your input captions and use simplified output captions: Set Style passthrough to Disabled (DISABLED), or leave blank.
     */
    public val stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.WebvttStylePassthrough? = builder.stylePassthrough

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebvttDestinationSettings(")
        append("accessibility=$accessibility,")
        append("stylePassthrough=$stylePassthrough)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessibility?.hashCode() ?: 0
        result = 31 * result + (stylePassthrough?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebvttDestinationSettings

        if (accessibility != other.accessibility) return false
        if (stylePassthrough != other.stylePassthrough) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set Accessibility subtitles to Enabled if the ISMC or WebVTT captions track is intended to provide accessibility for people who are deaf or hard of hearing. When you enable this feature, MediaConvert adds the following attributes under EXT-X-MEDIA in the HLS or CMAF manifest for this track: CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and AUTOSELECT="YES". Keep the default value, Disabled, if the captions track is not intended to provide such accessibility. MediaConvert will not add the above attributes.
         */
        public var accessibility: aws.sdk.kotlin.services.mediaconvert.model.WebvttAccessibilitySubs? = null
        /**
         * To use the available style, color, and position information from your input captions: Set Style passthrough (stylePassthrough) to Enabled (ENABLED). MediaConvert uses default settings when style and position information is missing from your input captions. To recreate the input captions exactly: Set Style passthrough to Strict (STRICT). MediaConvert automatically applies timing adjustments, including adjustments for frame rate conversion, ad avails, and input clipping. Your input captions format must be WebVTT. To ignore the style and position information from your input captions and use simplified output captions: Set Style passthrough to Disabled (DISABLED), or leave blank.
         */
        public var stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.WebvttStylePassthrough? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings) : this() {
            this.accessibility = x.accessibility
            this.stylePassthrough = x.stylePassthrough
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings = WebvttDestinationSettings(this)
    }
}
