// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.paginators

import aws.sdk.kotlin.services.mediaconvert.MediaConvertClient
import aws.sdk.kotlin.services.mediaconvert.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.mediaconvert.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.mediaconvert.model.Endpoint
import aws.sdk.kotlin.services.mediaconvert.model.Job
import aws.sdk.kotlin.services.mediaconvert.model.JobTemplate
import aws.sdk.kotlin.services.mediaconvert.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListJobsRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListJobsResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListPresetsRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListPresetsResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListQueuesRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListQueuesResponse
import aws.sdk.kotlin.services.mediaconvert.model.Preset
import aws.sdk.kotlin.services.mediaconvert.model.Queue
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointsResponse]
 */
public fun MediaConvertClient.describeEndpointsPaginated(initialRequest: DescribeEndpointsRequest): Flow<DescribeEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEndpointsPaginated.describeEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEndpointsResponse]
 */
public fun MediaConvertClient.describeEndpointsPaginated(block: DescribeEndpointsRequest.Builder.() -> Unit): Flow<DescribeEndpointsResponse> =
    describeEndpointsPaginated(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEndpointsPaginated]
 * to access the nested member [Endpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Endpoint]
 */
@JvmName("describeEndpointsResponseEndpoint")
public fun Flow<DescribeEndpointsResponse>.endpoints(): Flow<Endpoint> =
    transform() { response ->
        response.endpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun MediaConvertClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun MediaConvertClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [Job]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Job]
 */
@JvmName("listJobsResponseJob")
public fun Flow<ListJobsResponse>.jobs(): Flow<Job> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobTemplatesResponse]
 */
public fun MediaConvertClient.listJobTemplatesPaginated(initialRequest: ListJobTemplatesRequest): Flow<ListJobTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobTemplatesPaginated.listJobTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJobTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobTemplatesResponse]
 */
public fun MediaConvertClient.listJobTemplatesPaginated(block: ListJobTemplatesRequest.Builder.() -> Unit): Flow<ListJobTemplatesResponse> =
    listJobTemplatesPaginated(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobTemplatesPaginated]
 * to access the nested member [JobTemplate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobTemplate]
 */
@JvmName("listJobTemplatesResponseJobTemplate")
public fun Flow<ListJobTemplatesResponse>.jobTemplates(): Flow<JobTemplate> =
    transform() { response ->
        response.jobTemplates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPresetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPresetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPresetsResponse]
 */
public fun MediaConvertClient.listPresetsPaginated(initialRequest: ListPresetsRequest): Flow<ListPresetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPresetsPaginated.listPresets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPresetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPresetsResponse]
 */
public fun MediaConvertClient.listPresetsPaginated(block: ListPresetsRequest.Builder.() -> Unit): Flow<ListPresetsResponse> =
    listPresetsPaginated(ListPresetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPresetsPaginated]
 * to access the nested member [Preset]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Preset]
 */
@JvmName("listPresetsResponsePreset")
public fun Flow<ListPresetsResponse>.presets(): Flow<Preset> =
    transform() { response ->
        response.presets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun MediaConvertClient.listQueuesPaginated(initialRequest: ListQueuesRequest): Flow<ListQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueuesPaginated.listQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun MediaConvertClient.listQueuesPaginated(block: ListQueuesRequest.Builder.() -> Unit): Flow<ListQueuesResponse> =
    listQueuesPaginated(ListQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQueuesPaginated]
 * to access the nested member [Queue]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Queue]
 */
@JvmName("listQueuesResponseQueue")
public fun Flow<ListQueuesResponse>.queues(): Flow<Queue> =
    transform() { response ->
        response.queues?.forEach {
            emit(it)
        }
    }
