// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Advanced audio normalization settings. Ignore these settings unless you need to comply with a loudness standard.
 */
class AudioNormalizationSettings private constructor(builder: Builder) {
    /**
     * Choose one of the following audio normalization algorithms: ITU-R BS.1770-1: Ungated loudness. A measurement of ungated average loudness for an entire piece of content, suitable for measurement of short-form content under ATSC recommendation A/85. Supports up to 5.1 audio channels. ITU-R BS.1770-2: Gated loudness. A measurement of gated average loudness compliant with the requirements of EBU-R128. Supports up to 5.1 audio channels. ITU-R BS.1770-3: Modified peak. The same loudness measurement algorithm as 1770-2, with an updated true peak measurement. ITU-R BS.1770-4: Higher channel count. Allows for more audio channels than the other algorithms, including configurations such as 7.1.
     */
    val algorithm: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationAlgorithm? = builder.algorithm
    /**
     * When enabled the output audio is corrected using the chosen algorithm. If disabled, the audio will be measured but not adjusted.
     */
    val algorithmControl: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationAlgorithmControl? = builder.algorithmControl
    /**
     * Content measuring above this level will be corrected to the target level. Content measuring below this level will not be corrected.
     */
    val correctionGateLevel: kotlin.Int? = builder.correctionGateLevel
    /**
     * If set to LOG, log each output's audio track loudness to a CSV file.
     */
    val loudnessLogging: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationLoudnessLogging? = builder.loudnessLogging
    /**
     * If set to TRUE_PEAK, calculate and log the TruePeak for each output's audio track loudness.
     */
    val peakCalculation: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationPeakCalculation? = builder.peakCalculation
    /**
     * When you use Audio normalization (AudioNormalizationSettings), optionally use this setting to specify a target loudness. If you don't specify a value here, the encoder chooses a value for you, based on the algorithm that you choose for Algorithm (algorithm). If you choose algorithm 1770-1, the encoder will choose -24 LKFS; otherwise, the encoder will choose -23 LKFS.
     */
    val targetLkfs: kotlin.Double? = builder.targetLkfs

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioNormalizationSettings(")
        append("algorithm=$algorithm,")
        append("algorithmControl=$algorithmControl,")
        append("correctionGateLevel=$correctionGateLevel,")
        append("loudnessLogging=$loudnessLogging,")
        append("peakCalculation=$peakCalculation,")
        append("targetLkfs=$targetLkfs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (algorithmControl?.hashCode() ?: 0)
        result = 31 * result + (correctionGateLevel ?: 0)
        result = 31 * result + (loudnessLogging?.hashCode() ?: 0)
        result = 31 * result + (peakCalculation?.hashCode() ?: 0)
        result = 31 * result + (targetLkfs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioNormalizationSettings

        if (algorithm != other.algorithm) return false
        if (algorithmControl != other.algorithmControl) return false
        if (correctionGateLevel != other.correctionGateLevel) return false
        if (loudnessLogging != other.loudnessLogging) return false
        if (peakCalculation != other.peakCalculation) return false
        if (targetLkfs != other.targetLkfs) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Choose one of the following audio normalization algorithms: ITU-R BS.1770-1: Ungated loudness. A measurement of ungated average loudness for an entire piece of content, suitable for measurement of short-form content under ATSC recommendation A/85. Supports up to 5.1 audio channels. ITU-R BS.1770-2: Gated loudness. A measurement of gated average loudness compliant with the requirements of EBU-R128. Supports up to 5.1 audio channels. ITU-R BS.1770-3: Modified peak. The same loudness measurement algorithm as 1770-2, with an updated true peak measurement. ITU-R BS.1770-4: Higher channel count. Allows for more audio channels than the other algorithms, including configurations such as 7.1.
         */
        var algorithm: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationAlgorithm? = null
        /**
         * When enabled the output audio is corrected using the chosen algorithm. If disabled, the audio will be measured but not adjusted.
         */
        var algorithmControl: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationAlgorithmControl? = null
        /**
         * Content measuring above this level will be corrected to the target level. Content measuring below this level will not be corrected.
         */
        var correctionGateLevel: kotlin.Int? = null
        /**
         * If set to LOG, log each output's audio track loudness to a CSV file.
         */
        var loudnessLogging: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationLoudnessLogging? = null
        /**
         * If set to TRUE_PEAK, calculate and log the TruePeak for each output's audio track loudness.
         */
        var peakCalculation: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationPeakCalculation? = null
        /**
         * When you use Audio normalization (AudioNormalizationSettings), optionally use this setting to specify a target loudness. If you don't specify a value here, the encoder chooses a value for you, based on the algorithm that you choose for Algorithm (algorithm). If you choose algorithm 1770-1, the encoder will choose -24 LKFS; otherwise, the encoder will choose -23 LKFS.
         */
        var targetLkfs: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings) : this() {
            this.algorithm = x.algorithm
            this.algorithmControl = x.algorithmControl
            this.correctionGateLevel = x.correctionGateLevel
            this.loudnessLogging = x.loudnessLogging
            this.peakCalculation = x.peakCalculation
            this.targetLkfs = x.targetLkfs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings = AudioNormalizationSettings(this)
    }
}
