// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based on characteristics of your input video. This feature optimizes video quality while minimizing the overall size of your ABR package.
 */
class AutomatedAbrSettings private constructor(builder: Builder) {
    /**
     * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default.
     */
    val maxAbrBitrate: kotlin.Int? = builder.maxAbrBitrate
    /**
     * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification, MediaConvert defaults to a limit of 15.
     */
    val maxRenditions: kotlin.Int? = builder.maxRenditions
    /**
     * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on the bitrate of video delivered to viewers with slow internet connections. If you don't specify a value, MediaConvert uses 600,000 (600 kb/s) by default.
     */
    val minAbrBitrate: kotlin.Int? = builder.minAbrBitrate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomatedAbrSettings(")
        append("maxAbrBitrate=$maxAbrBitrate,")
        append("maxRenditions=$maxRenditions,")
        append("minAbrBitrate=$minAbrBitrate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAbrBitrate ?: 0
        result = 31 * result + (maxRenditions ?: 0)
        result = 31 * result + (minAbrBitrate ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomatedAbrSettings

        if (maxAbrBitrate != other.maxAbrBitrate) return false
        if (maxRenditions != other.maxRenditions) return false
        if (minAbrBitrate != other.minAbrBitrate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default.
         */
        var maxAbrBitrate: kotlin.Int? = null
        /**
         * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification, MediaConvert defaults to a limit of 15.
         */
        var maxRenditions: kotlin.Int? = null
        /**
         * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on the bitrate of video delivered to viewers with slow internet connections. If you don't specify a value, MediaConvert uses 600,000 (600 kb/s) by default.
         */
        var minAbrBitrate: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings) : this() {
            this.maxAbrBitrate = x.maxAbrBitrate
            this.maxRenditions = x.maxRenditions
            this.minAbrBitrate = x.minAbrBitrate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = AutomatedAbrSettings(this)
    }
}
