// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to your DASH output package. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job specification, include this object and any required children when you set Type, under OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS.
 */
class DashIsoGroupSettings private constructor(builder: Builder) {
    /**
     * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This default manifest references every output in the output group. To create additional DASH manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    val additionalManifests: List<DashAdditionalManifest>? = builder.additionalManifests
    /**
     * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For example, you might need to use this to make dynamic ad insertion work. Specify which audio channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel configuration (MPEG_CHANNEL_CONFIGURATION), to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration (DOLBY_CHANNEL_CONFIGURATION) to have MediaConvert write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
     */
    val audioChannelConfigSchemeIdUri: aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupAudioChannelConfigSchemeIdUri? = builder.audioChannelConfigSchemeIdUri
    /**
     * A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.
     */
    val baseUrl: kotlin.String? = builder.baseUrl
    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * Settings associated with the destination. Will vary based on the type of destination
     */
    val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = builder.destinationSettings
    /**
     * DRM settings.
     */
    val encryption: aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings? = builder.encryption
    /**
     * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not cause the creation of many output files as in other output types.
     */
    val fragmentLength: kotlin.Int? = builder.fragmentLength
    /**
     * Supports HbbTV specification as indicated
     */
    val hbbtvCompliance: aws.sdk.kotlin.services.mediaconvert.model.DashIsoHbbtvCompliance? = builder.hbbtvCompliance
    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for each set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     */
    val imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlay? = builder.imageBasedTrickPlay
    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    val imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings? = builder.imageBasedTrickPlaySettings
    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     */
    val minBufferTime: kotlin.Int? = builder.minBufferTime
    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    val minFinalSegmentLength: kotlin.Double? = builder.minFinalSegmentLength
    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals  urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).
     */
    val mpdProfile: aws.sdk.kotlin.services.mediaconvert.model.DashIsoMpdProfile? = builder.mpdProfile
    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS (MATCH_INITIAL_PTS) when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based (ZERO_BASED) to have MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     */
    val ptsOffsetHandlingForBFrames: aws.sdk.kotlin.services.mediaconvert.model.DashIsoPtsOffsetHandlingForBFrames? = builder.ptsOffsetHandlingForBFrames
    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     */
    val segmentControl: aws.sdk.kotlin.services.mediaconvert.model.DashIsoSegmentControl? = builder.segmentControl
    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 30. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (DashIsoSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
     */
    val segmentLength: kotlin.Int? = builder.segmentLength
    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    val segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.DashIsoSegmentLengthControl? = builder.segmentLengthControl
    /**
     * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run your transcoding job again. When you enable this setting, the service writes precise segment durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the service writes approximate segment durations in your DASH manifest.
     */
    val writeSegmentTimelineInRepresentation: aws.sdk.kotlin.services.mediaconvert.model.DashIsoWriteSegmentTimelineInRepresentation? = builder.writeSegmentTimelineInRepresentation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DashIsoGroupSettings(")
        append("additionalManifests=$additionalManifests,")
        append("audioChannelConfigSchemeIdUri=$audioChannelConfigSchemeIdUri,")
        append("baseUrl=$baseUrl,")
        append("destination=$destination,")
        append("destinationSettings=$destinationSettings,")
        append("encryption=$encryption,")
        append("fragmentLength=$fragmentLength,")
        append("hbbtvCompliance=$hbbtvCompliance,")
        append("imageBasedTrickPlay=$imageBasedTrickPlay,")
        append("imageBasedTrickPlaySettings=$imageBasedTrickPlaySettings,")
        append("minBufferTime=$minBufferTime,")
        append("minFinalSegmentLength=$minFinalSegmentLength,")
        append("mpdProfile=$mpdProfile,")
        append("ptsOffsetHandlingForBFrames=$ptsOffsetHandlingForBFrames,")
        append("segmentControl=$segmentControl,")
        append("segmentLength=$segmentLength,")
        append("segmentLengthControl=$segmentLengthControl,")
        append("writeSegmentTimelineInRepresentation=$writeSegmentTimelineInRepresentation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalManifests?.hashCode() ?: 0
        result = 31 * result + (audioChannelConfigSchemeIdUri?.hashCode() ?: 0)
        result = 31 * result + (baseUrl?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (fragmentLength ?: 0)
        result = 31 * result + (hbbtvCompliance?.hashCode() ?: 0)
        result = 31 * result + (imageBasedTrickPlay?.hashCode() ?: 0)
        result = 31 * result + (imageBasedTrickPlaySettings?.hashCode() ?: 0)
        result = 31 * result + (minBufferTime ?: 0)
        result = 31 * result + (minFinalSegmentLength?.hashCode() ?: 0)
        result = 31 * result + (mpdProfile?.hashCode() ?: 0)
        result = 31 * result + (ptsOffsetHandlingForBFrames?.hashCode() ?: 0)
        result = 31 * result + (segmentControl?.hashCode() ?: 0)
        result = 31 * result + (segmentLength ?: 0)
        result = 31 * result + (segmentLengthControl?.hashCode() ?: 0)
        result = 31 * result + (writeSegmentTimelineInRepresentation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DashIsoGroupSettings

        if (additionalManifests != other.additionalManifests) return false
        if (audioChannelConfigSchemeIdUri != other.audioChannelConfigSchemeIdUri) return false
        if (baseUrl != other.baseUrl) return false
        if (destination != other.destination) return false
        if (destinationSettings != other.destinationSettings) return false
        if (encryption != other.encryption) return false
        if (fragmentLength != other.fragmentLength) return false
        if (hbbtvCompliance != other.hbbtvCompliance) return false
        if (imageBasedTrickPlay != other.imageBasedTrickPlay) return false
        if (imageBasedTrickPlaySettings != other.imageBasedTrickPlaySettings) return false
        if (minBufferTime != other.minBufferTime) return false
        if (minFinalSegmentLength != other.minFinalSegmentLength) return false
        if (mpdProfile != other.mpdProfile) return false
        if (ptsOffsetHandlingForBFrames != other.ptsOffsetHandlingForBFrames) return false
        if (segmentControl != other.segmentControl) return false
        if (segmentLength != other.segmentLength) return false
        if (segmentLengthControl != other.segmentLengthControl) return false
        if (writeSegmentTimelineInRepresentation != other.writeSegmentTimelineInRepresentation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This default manifest references every output in the output group. To create additional DASH manifests that reference a subset of the outputs in the output group, specify a list of them here.
         */
        var additionalManifests: List<DashAdditionalManifest>? = null
        /**
         * Use this setting only when your audio codec is a Dolby one (AC3, EAC3, or Atmos) and your downstream workflow requires that your DASH manifest use the Dolby channel configuration tag, rather than the MPEG one. For example, you might need to use this to make dynamic ad insertion work. Specify which audio channel configuration scheme ID URI MediaConvert writes in your DASH manifest. Keep the default value, MPEG channel configuration (MPEG_CHANNEL_CONFIGURATION), to have MediaConvert write this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel configuration (DOLBY_CHANNEL_CONFIGURATION) to have MediaConvert write this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.
         */
        var audioChannelConfigSchemeIdUri: aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupAudioChannelConfigSchemeIdUri? = null
        /**
         * A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.
         */
        var baseUrl: kotlin.String? = null
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
         */
        var destination: kotlin.String? = null
        /**
         * Settings associated with the destination. Will vary based on the type of destination
         */
        var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = null
        /**
         * DRM settings.
         */
        var encryption: aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings? = null
        /**
         * Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not cause the creation of many output files as in other output types.
         */
        var fragmentLength: kotlin.Int? = null
        /**
         * Supports HbbTV specification as indicated
         */
        var hbbtvCompliance: aws.sdk.kotlin.services.mediaconvert.model.DashIsoHbbtvCompliance? = null
        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for each set of images that you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         */
        var imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlay? = null
        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         */
        var imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings? = null
        /**
         * Minimum time of initially buffered media that is needed to ensure smooth playout.
         */
        var minBufferTime: kotlin.Int? = null
        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         */
        var minFinalSegmentLength: kotlin.Double? = null
        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals  urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).
         */
        var mpdProfile: aws.sdk.kotlin.services.mediaconvert.model.DashIsoMpdProfile? = null
        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS (MATCH_INITIAL_PTS) when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based (ZERO_BASED) to have MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
         */
        var ptsOffsetHandlingForBFrames: aws.sdk.kotlin.services.mediaconvert.model.DashIsoPtsOffsetHandlingForBFrames? = null
        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         */
        var segmentControl: aws.sdk.kotlin.services.mediaconvert.model.DashIsoSegmentControl? = null
        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 30. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (DashIsoSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
         */
        var segmentLength: kotlin.Int? = null
        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
         */
        var segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.DashIsoSegmentLengthControl? = null
        /**
         * If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run your transcoding job again. When you enable this setting, the service writes precise segment durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When you don't enable this setting, the service writes approximate segment durations in your DASH manifest.
         */
        var writeSegmentTimelineInRepresentation: aws.sdk.kotlin.services.mediaconvert.model.DashIsoWriteSegmentTimelineInRepresentation? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupSettings) : this() {
            this.additionalManifests = x.additionalManifests
            this.audioChannelConfigSchemeIdUri = x.audioChannelConfigSchemeIdUri
            this.baseUrl = x.baseUrl
            this.destination = x.destination
            this.destinationSettings = x.destinationSettings
            this.encryption = x.encryption
            this.fragmentLength = x.fragmentLength
            this.hbbtvCompliance = x.hbbtvCompliance
            this.imageBasedTrickPlay = x.imageBasedTrickPlay
            this.imageBasedTrickPlaySettings = x.imageBasedTrickPlaySettings
            this.minBufferTime = x.minBufferTime
            this.minFinalSegmentLength = x.minFinalSegmentLength
            this.mpdProfile = x.mpdProfile
            this.ptsOffsetHandlingForBFrames = x.ptsOffsetHandlingForBFrames
            this.segmentControl = x.segmentControl
            this.segmentLength = x.segmentLength
            this.segmentLengthControl = x.segmentLengthControl
            this.writeSegmentTimelineInRepresentation = x.writeSegmentTimelineInRepresentation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.DashIsoGroupSettings = DashIsoGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings] inside the given [block]
         */
        fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings] inside the given [block]
         */
        fun imageBasedTrickPlaySettings(block: aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings.Builder.() -> kotlin.Unit) {
            this.imageBasedTrickPlaySettings = aws.sdk.kotlin.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings.invoke(block)
        }
    }
}
