// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
 */
class Eac3AtmosSettings private constructor(builder: Builder) {
    /**
     * Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k, 768k, 1024k Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive (CBI) 7.1.4 and 5.1.4 inputs. For CBI 9.1.6 and other input types, MediaConvert automatically increases your output bitrate to 448k.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     */
    val bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosBitstreamMode? = builder.bitstreamMode
    /**
     * The coding mode for Dolby Digital Plus JOC (Atmos).
     */
    val codingMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosCodingMode? = builder.codingMode
    /**
     * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     */
    val dialogueIntelligence: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDialogueIntelligence? = builder.dialogueIntelligence
    /**
     * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only center (LoRoCenterMixLevel),  and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses default values for those settings.
     */
    val downmixControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDownmixControl? = builder.downmixControl
    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    val dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionLine? = builder.dynamicRangeCompressionLine
    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    val dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionRf? = builder.dynamicRangeCompressionRf
    /**
     * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify your dynamic range control values: Dynamic range compression line (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values for the related settings, MediaConvert uses default values for those settings.
     */
    val dynamicRangeControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeControl? = builder.dynamicRangeControl
    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only center (LoRoCenterMixLevel).
     */
    val loRoCenterMixLevel: kotlin.Double? = builder.loRoCenterMixLevel
    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only surround (LoRoSurroundMixLevel).
     */
    val loRoSurroundMixLevel: kotlin.Double? = builder.loRoSurroundMixLevel
    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left total/Right total center (LtRtCenterMixLevel).
     */
    val ltRtCenterMixLevel: kotlin.Double? = builder.ltRtCenterMixLevel
    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, the service ignores Left total/Right total surround (LtRtSurroundMixLevel).
     */
    val ltRtSurroundMixLevel: kotlin.Double? = builder.ltRtSurroundMixLevel
    /**
     * Choose how the service meters the loudness of your audio.
     */
    val meteringMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosMeteringMode? = builder.meteringMode
    /**
     * This value is always 48000. It represents the sample rate in Hz.
     */
    val sampleRate: kotlin.Int? = builder.sampleRate
    /**
     * Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder to use the measured speech loudness as the overall program loudness. Default value: 15%
     */
    val speechThreshold: kotlin.Int? = builder.speechThreshold
    /**
     * Choose how the service does stereo downmixing. Default value: Not indicated (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Stereo downmix (StereoDownmix).
     */
    val stereoDownmix: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosStereoDownmix? = builder.stereoDownmix
    /**
     * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and right surround channels.
     */
    val surroundExMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSurroundExMode? = builder.surroundExMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Eac3AtmosSettings(")
        append("bitrate=$bitrate,")
        append("bitstreamMode=$bitstreamMode,")
        append("codingMode=$codingMode,")
        append("dialogueIntelligence=$dialogueIntelligence,")
        append("downmixControl=$downmixControl,")
        append("dynamicRangeCompressionLine=$dynamicRangeCompressionLine,")
        append("dynamicRangeCompressionRf=$dynamicRangeCompressionRf,")
        append("dynamicRangeControl=$dynamicRangeControl,")
        append("loRoCenterMixLevel=$loRoCenterMixLevel,")
        append("loRoSurroundMixLevel=$loRoSurroundMixLevel,")
        append("ltRtCenterMixLevel=$ltRtCenterMixLevel,")
        append("ltRtSurroundMixLevel=$ltRtSurroundMixLevel,")
        append("meteringMode=$meteringMode,")
        append("sampleRate=$sampleRate,")
        append("speechThreshold=$speechThreshold,")
        append("stereoDownmix=$stereoDownmix,")
        append("surroundExMode=$surroundExMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitrate ?: 0
        result = 31 * result + (bitstreamMode?.hashCode() ?: 0)
        result = 31 * result + (codingMode?.hashCode() ?: 0)
        result = 31 * result + (dialogueIntelligence?.hashCode() ?: 0)
        result = 31 * result + (downmixControl?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeCompressionLine?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeCompressionRf?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeControl?.hashCode() ?: 0)
        result = 31 * result + (loRoCenterMixLevel?.hashCode() ?: 0)
        result = 31 * result + (loRoSurroundMixLevel?.hashCode() ?: 0)
        result = 31 * result + (ltRtCenterMixLevel?.hashCode() ?: 0)
        result = 31 * result + (ltRtSurroundMixLevel?.hashCode() ?: 0)
        result = 31 * result + (meteringMode?.hashCode() ?: 0)
        result = 31 * result + (sampleRate ?: 0)
        result = 31 * result + (speechThreshold ?: 0)
        result = 31 * result + (stereoDownmix?.hashCode() ?: 0)
        result = 31 * result + (surroundExMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Eac3AtmosSettings

        if (bitrate != other.bitrate) return false
        if (bitstreamMode != other.bitstreamMode) return false
        if (codingMode != other.codingMode) return false
        if (dialogueIntelligence != other.dialogueIntelligence) return false
        if (downmixControl != other.downmixControl) return false
        if (dynamicRangeCompressionLine != other.dynamicRangeCompressionLine) return false
        if (dynamicRangeCompressionRf != other.dynamicRangeCompressionRf) return false
        if (dynamicRangeControl != other.dynamicRangeControl) return false
        if (loRoCenterMixLevel != other.loRoCenterMixLevel) return false
        if (loRoSurroundMixLevel != other.loRoSurroundMixLevel) return false
        if (ltRtCenterMixLevel != other.ltRtCenterMixLevel) return false
        if (ltRtSurroundMixLevel != other.ltRtSurroundMixLevel) return false
        if (meteringMode != other.meteringMode) return false
        if (sampleRate != other.sampleRate) return false
        if (speechThreshold != other.speechThreshold) return false
        if (stereoDownmix != other.stereoDownmix) return false
        if (surroundExMode != other.surroundExMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k, 768k, 1024k Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive (CBI) 7.1.4 and 5.1.4 inputs. For CBI 9.1.6 and other input types, MediaConvert automatically increases your output bitrate to 448k.
         */
        var bitrate: kotlin.Int? = null
        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         */
        var bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosBitstreamMode? = null
        /**
         * The coding mode for Dolby Digital Plus JOC (Atmos).
         */
        var codingMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosCodingMode? = null
        /**
         * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         */
        var dialogueIntelligence: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDialogueIntelligence? = null
        /**
         * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only center (LoRoCenterMixLevel),  and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses default values for those settings.
         */
        var downmixControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDownmixControl? = null
        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        var dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionLine? = null
        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        var dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionRf? = null
        /**
         * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify your dynamic range control values: Dynamic range compression line (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values for the related settings, MediaConvert uses default values for those settings.
         */
        var dynamicRangeControl: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosDynamicRangeControl? = null
        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only center (LoRoCenterMixLevel).
         */
        var loRoCenterMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only surround (LoRoSurroundMixLevel).
         */
        var loRoSurroundMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left total/Right total center (LtRtCenterMixLevel).
         */
        var ltRtCenterMixLevel: kotlin.Double? = null
        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, the service ignores Left total/Right total surround (LtRtSurroundMixLevel).
         */
        var ltRtSurroundMixLevel: kotlin.Double? = null
        /**
         * Choose how the service meters the loudness of your audio.
         */
        var meteringMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosMeteringMode? = null
        /**
         * This value is always 48000. It represents the sample rate in Hz.
         */
        var sampleRate: kotlin.Int? = null
        /**
         * Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder to use the measured speech loudness as the overall program loudness. Default value: 15%
         */
        var speechThreshold: kotlin.Int? = null
        /**
         * Choose how the service does stereo downmixing. Default value: Not indicated (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Stereo downmix (StereoDownmix).
         */
        var stereoDownmix: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosStereoDownmix? = null
        /**
         * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and right surround channels.
         */
        var surroundExMode: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSurroundExMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings) : this() {
            this.bitrate = x.bitrate
            this.bitstreamMode = x.bitstreamMode
            this.codingMode = x.codingMode
            this.dialogueIntelligence = x.dialogueIntelligence
            this.downmixControl = x.downmixControl
            this.dynamicRangeCompressionLine = x.dynamicRangeCompressionLine
            this.dynamicRangeCompressionRf = x.dynamicRangeCompressionRf
            this.dynamicRangeControl = x.dynamicRangeControl
            this.loRoCenterMixLevel = x.loRoCenterMixLevel
            this.loRoSurroundMixLevel = x.loRoSurroundMixLevel
            this.ltRtCenterMixLevel = x.ltRtCenterMixLevel
            this.ltRtSurroundMixLevel = x.ltRtSurroundMixLevel
            this.meteringMode = x.meteringMode
            this.sampleRate = x.sampleRate
            this.speechThreshold = x.speechThreshold
            this.stereoDownmix = x.stereoDownmix
            this.surroundExMode = x.surroundExMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings = Eac3AtmosSettings(this)
    }
}
