// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
 */
class EmbeddedDestinationSettings private constructor(builder: Builder) {
    /**
     * Ignore this setting unless your input captions are SCC format and your output captions are embedded in the video stream. Specify a CC number for each captions channel in this output. If you have two channels, choose CC numbers that aren't in the same field. For example, choose 1 and 3. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     */
    val destination608ChannelNumber: kotlin.Int? = builder.destination608ChannelNumber
    /**
     * Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions embedded in your output stream. Optionally, specify the 708 service number for each output captions channel. Choose a different number for each channel. To use this setting, also set Force 608 to 708 upconvert (Convert608To708) to Upconvert (UPCONVERT) in your input captions selector settings. If you choose to upconvert but don't specify a 708 service number, MediaConvert uses the number that you specify for CC channel number (destination608ChannelNumber) for the 708 service number. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     */
    val destination708ServiceNumber: kotlin.Int? = builder.destination708ServiceNumber

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmbeddedDestinationSettings(")
        append("destination608ChannelNumber=$destination608ChannelNumber,")
        append("destination708ServiceNumber=$destination708ServiceNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination608ChannelNumber ?: 0
        result = 31 * result + (destination708ServiceNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmbeddedDestinationSettings

        if (destination608ChannelNumber != other.destination608ChannelNumber) return false
        if (destination708ServiceNumber != other.destination708ServiceNumber) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Ignore this setting unless your input captions are SCC format and your output captions are embedded in the video stream. Specify a CC number for each captions channel in this output. If you have two channels, choose CC numbers that aren't in the same field. For example, choose 1 and 3. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         */
        var destination608ChannelNumber: kotlin.Int? = null
        /**
         * Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions embedded in your output stream. Optionally, specify the 708 service number for each output captions channel. Choose a different number for each channel. To use this setting, also set Force 608 to 708 upconvert (Convert608To708) to Upconvert (UPCONVERT) in your input captions selector settings. If you choose to upconvert but don't specify a 708 service number, MediaConvert uses the number that you specify for CC channel number (destination608ChannelNumber) for the 708 service number. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         */
        var destination708ServiceNumber: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings) : this() {
            this.destination608ChannelNumber = x.destination608ChannelNumber
            this.destination708ServiceNumber = x.destination708ServiceNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings = EmbeddedDestinationSettings(this)
    }
}
