// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to your HLS output package. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job specification, include this object and any required children when you set Type, under OutputGroupSettings, to HLS_GROUP_SETTINGS.
 */
class HlsGroupSettings private constructor(builder: Builder) {
    /**
     * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether SCTE-35 markers appear in the outputs themselves.
     */
    val adMarkers: List<HlsAdMarkers>? = builder.adMarkers
    /**
     * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This default manifest references every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    val additionalManifests: List<HlsAdditionalManifest>? = builder.additionalManifests
    /**
     * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the audio-only headers from your audio segments.
     */
    val audioOnlyHeader: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioOnlyHeader? = builder.audioOnlyHeader
    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
     */
    val baseUrl: kotlin.String? = builder.baseUrl
    /**
     * Language to be used on Caption outputs
     */
    val captionLanguageMappings: List<HlsCaptionLanguageMapping>? = builder.captionLanguageMappings
    /**
     * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
     */
    val captionLanguageSetting: aws.sdk.kotlin.services.mediaconvert.model.HlsCaptionLanguageSetting? = builder.captionLanguageSetting
    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control http header.
     */
    val clientCache: aws.sdk.kotlin.services.mediaconvert.model.HlsClientCache? = builder.clientCache
    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     */
    val codecSpecification: aws.sdk.kotlin.services.mediaconvert.model.HlsCodecSpecification? = builder.codecSpecification
    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * Settings associated with the destination. Will vary based on the type of destination
     */
    val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = builder.destinationSettings
    /**
     * Indicates whether segments should be placed in subdirectories.
     */
    val directoryStructure: aws.sdk.kotlin.services.mediaconvert.model.HlsDirectoryStructure? = builder.directoryStructure
    /**
     * DRM settings.
     */
    val encryption: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings? = builder.encryption
    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     */
    val imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlay? = builder.imageBasedTrickPlay
    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    val imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlaySettings? = builder.imageBasedTrickPlaySettings
    /**
     * When set to GZIP, compresses HLS playlist.
     */
    val manifestCompression: aws.sdk.kotlin.services.mediaconvert.model.HlsManifestCompression? = builder.manifestCompression
    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     */
    val manifestDurationFormat: aws.sdk.kotlin.services.mediaconvert.model.HlsManifestDurationFormat? = builder.manifestDurationFormat
    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    val minFinalSegmentLength: kotlin.Double? = builder.minFinalSegmentLength
    /**
     * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.
     */
    val minSegmentLength: kotlin.Int? = builder.minSegmentLength
    /**
     * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     */
    val outputSelection: aws.sdk.kotlin.services.mediaconvert.model.HlsOutputSelection? = builder.outputSelection
    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestamp_offset.
     */
    val programDateTime: aws.sdk.kotlin.services.mediaconvert.model.HlsProgramDateTime? = builder.programDateTime
    /**
     * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     */
    val programDateTimePeriod: kotlin.Int? = builder.programDateTimePeriod
    /**
     * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index segment for playback.
     */
    val segmentControl: aws.sdk.kotlin.services.mediaconvert.model.HlsSegmentControl? = builder.segmentControl
    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (HlsSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
     */
    val segmentLength: kotlin.Int? = builder.segmentLength
    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    val segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.HlsSegmentLengthControl? = builder.segmentLengthControl
    /**
     * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be SINGLE_DIRECTORY for this setting to have an effect.
     */
    val segmentsPerSubdirectory: kotlin.Int? = builder.segmentsPerSubdirectory
    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     */
    val streamInfResolution: aws.sdk.kotlin.services.mediaconvert.model.HlsStreamInfResolution? = builder.streamInfResolution
    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual duration of the segment. Some older players may experience interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     */
    val targetDurationCompatibilityMode: aws.sdk.kotlin.services.mediaconvert.model.HlsTargetDurationCompatibilityMode? = builder.targetDurationCompatibilityMode
    /**
     * Indicates ID3 frame that has the timecode.
     */
    val timedMetadataId3Frame: aws.sdk.kotlin.services.mediaconvert.model.HlsTimedMetadataId3Frame? = builder.timedMetadataId3Frame
    /**
     * Timed Metadata interval in seconds.
     */
    val timedMetadataId3Period: kotlin.Int? = builder.timedMetadataId3Period
    /**
     * Provides an extra millisecond delta offset to fine tune the timestamps.
     */
    val timestampDeltaMilliseconds: kotlin.Int? = builder.timestampDeltaMilliseconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.HlsGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsGroupSettings(")
        append("adMarkers=$adMarkers,")
        append("additionalManifests=$additionalManifests,")
        append("audioOnlyHeader=$audioOnlyHeader,")
        append("baseUrl=$baseUrl,")
        append("captionLanguageMappings=$captionLanguageMappings,")
        append("captionLanguageSetting=$captionLanguageSetting,")
        append("clientCache=$clientCache,")
        append("codecSpecification=$codecSpecification,")
        append("destination=$destination,")
        append("destinationSettings=$destinationSettings,")
        append("directoryStructure=$directoryStructure,")
        append("encryption=$encryption,")
        append("imageBasedTrickPlay=$imageBasedTrickPlay,")
        append("imageBasedTrickPlaySettings=$imageBasedTrickPlaySettings,")
        append("manifestCompression=$manifestCompression,")
        append("manifestDurationFormat=$manifestDurationFormat,")
        append("minFinalSegmentLength=$minFinalSegmentLength,")
        append("minSegmentLength=$minSegmentLength,")
        append("outputSelection=$outputSelection,")
        append("programDateTime=$programDateTime,")
        append("programDateTimePeriod=$programDateTimePeriod,")
        append("segmentControl=$segmentControl,")
        append("segmentLength=$segmentLength,")
        append("segmentLengthControl=$segmentLengthControl,")
        append("segmentsPerSubdirectory=$segmentsPerSubdirectory,")
        append("streamInfResolution=$streamInfResolution,")
        append("targetDurationCompatibilityMode=$targetDurationCompatibilityMode,")
        append("timedMetadataId3Frame=$timedMetadataId3Frame,")
        append("timedMetadataId3Period=$timedMetadataId3Period,")
        append("timestampDeltaMilliseconds=$timestampDeltaMilliseconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (additionalManifests?.hashCode() ?: 0)
        result = 31 * result + (audioOnlyHeader?.hashCode() ?: 0)
        result = 31 * result + (baseUrl?.hashCode() ?: 0)
        result = 31 * result + (captionLanguageMappings?.hashCode() ?: 0)
        result = 31 * result + (captionLanguageSetting?.hashCode() ?: 0)
        result = 31 * result + (clientCache?.hashCode() ?: 0)
        result = 31 * result + (codecSpecification?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        result = 31 * result + (directoryStructure?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (imageBasedTrickPlay?.hashCode() ?: 0)
        result = 31 * result + (imageBasedTrickPlaySettings?.hashCode() ?: 0)
        result = 31 * result + (manifestCompression?.hashCode() ?: 0)
        result = 31 * result + (manifestDurationFormat?.hashCode() ?: 0)
        result = 31 * result + (minFinalSegmentLength?.hashCode() ?: 0)
        result = 31 * result + (minSegmentLength ?: 0)
        result = 31 * result + (outputSelection?.hashCode() ?: 0)
        result = 31 * result + (programDateTime?.hashCode() ?: 0)
        result = 31 * result + (programDateTimePeriod ?: 0)
        result = 31 * result + (segmentControl?.hashCode() ?: 0)
        result = 31 * result + (segmentLength ?: 0)
        result = 31 * result + (segmentLengthControl?.hashCode() ?: 0)
        result = 31 * result + (segmentsPerSubdirectory ?: 0)
        result = 31 * result + (streamInfResolution?.hashCode() ?: 0)
        result = 31 * result + (targetDurationCompatibilityMode?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataId3Frame?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataId3Period ?: 0)
        result = 31 * result + (timestampDeltaMilliseconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsGroupSettings

        if (adMarkers != other.adMarkers) return false
        if (additionalManifests != other.additionalManifests) return false
        if (audioOnlyHeader != other.audioOnlyHeader) return false
        if (baseUrl != other.baseUrl) return false
        if (captionLanguageMappings != other.captionLanguageMappings) return false
        if (captionLanguageSetting != other.captionLanguageSetting) return false
        if (clientCache != other.clientCache) return false
        if (codecSpecification != other.codecSpecification) return false
        if (destination != other.destination) return false
        if (destinationSettings != other.destinationSettings) return false
        if (directoryStructure != other.directoryStructure) return false
        if (encryption != other.encryption) return false
        if (imageBasedTrickPlay != other.imageBasedTrickPlay) return false
        if (imageBasedTrickPlaySettings != other.imageBasedTrickPlaySettings) return false
        if (manifestCompression != other.manifestCompression) return false
        if (manifestDurationFormat != other.manifestDurationFormat) return false
        if (minFinalSegmentLength != other.minFinalSegmentLength) return false
        if (minSegmentLength != other.minSegmentLength) return false
        if (outputSelection != other.outputSelection) return false
        if (programDateTime != other.programDateTime) return false
        if (programDateTimePeriod != other.programDateTimePeriod) return false
        if (segmentControl != other.segmentControl) return false
        if (segmentLength != other.segmentLength) return false
        if (segmentLengthControl != other.segmentLengthControl) return false
        if (segmentsPerSubdirectory != other.segmentsPerSubdirectory) return false
        if (streamInfResolution != other.streamInfResolution) return false
        if (targetDurationCompatibilityMode != other.targetDurationCompatibilityMode) return false
        if (timedMetadataId3Frame != other.timedMetadataId3Frame) return false
        if (timedMetadataId3Period != other.timedMetadataId3Period) return false
        if (timestampDeltaMilliseconds != other.timestampDeltaMilliseconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.HlsGroupSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether SCTE-35 markers appear in the outputs themselves.
         */
        var adMarkers: List<HlsAdMarkers>? = null
        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This default manifest references every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here.
         */
        var additionalManifests: List<HlsAdditionalManifest>? = null
        /**
         * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the audio-only headers from your audio segments.
         */
        var audioOnlyHeader: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioOnlyHeader? = null
        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
         */
        var baseUrl: kotlin.String? = null
        /**
         * Language to be used on Caption outputs
         */
        var captionLanguageMappings: List<HlsCaptionLanguageMapping>? = null
        /**
         * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
         */
        var captionLanguageSetting: aws.sdk.kotlin.services.mediaconvert.model.HlsCaptionLanguageSetting? = null
        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control http header.
         */
        var clientCache: aws.sdk.kotlin.services.mediaconvert.model.HlsClientCache? = null
        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         */
        var codecSpecification: aws.sdk.kotlin.services.mediaconvert.model.HlsCodecSpecification? = null
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
         */
        var destination: kotlin.String? = null
        /**
         * Settings associated with the destination. Will vary based on the type of destination
         */
        var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = null
        /**
         * Indicates whether segments should be placed in subdirectories.
         */
        var directoryStructure: aws.sdk.kotlin.services.mediaconvert.model.HlsDirectoryStructure? = null
        /**
         * DRM settings.
         */
        var encryption: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings? = null
        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest. A common application for these images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         */
        var imageBasedTrickPlay: aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlay? = null
        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         */
        var imageBasedTrickPlaySettings: aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlaySettings? = null
        /**
         * When set to GZIP, compresses HLS playlist.
         */
        var manifestCompression: aws.sdk.kotlin.services.mediaconvert.model.HlsManifestCompression? = null
        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         */
        var manifestDurationFormat: aws.sdk.kotlin.services.mediaconvert.model.HlsManifestDurationFormat? = null
        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         */
        var minFinalSegmentLength: kotlin.Double? = null
        /**
         * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.
         */
        var minSegmentLength: kotlin.Int? = null
        /**
         * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         */
        var outputSelection: aws.sdk.kotlin.services.mediaconvert.model.HlsOutputSelection? = null
        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestamp_offset.
         */
        var programDateTime: aws.sdk.kotlin.services.mediaconvert.model.HlsProgramDateTime? = null
        /**
         * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         */
        var programDateTimePeriod: kotlin.Int? = null
        /**
         * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index segment for playback.
         */
        var segmentControl: aws.sdk.kotlin.services.mediaconvert.model.HlsSegmentControl? = null
        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces this value strictly. Use Segment control (HlsSegmentControl) to specify whether MediaConvert creates separate segment files or one content file that has metadata to mark the segment boundaries.
         */
        var segmentLength: kotlin.Int? = null
        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
         */
        var segmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.HlsSegmentLengthControl? = null
        /**
         * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be SINGLE_DIRECTORY for this setting to have an effect.
         */
        var segmentsPerSubdirectory: kotlin.Int? = null
        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         */
        var streamInfResolution: aws.sdk.kotlin.services.mediaconvert.model.HlsStreamInfResolution? = null
        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual duration of the segment. Some older players may experience interrupted playback when the actual duration of a track in a segment is longer than the target duration.
         */
        var targetDurationCompatibilityMode: aws.sdk.kotlin.services.mediaconvert.model.HlsTargetDurationCompatibilityMode? = null
        /**
         * Indicates ID3 frame that has the timecode.
         */
        var timedMetadataId3Frame: aws.sdk.kotlin.services.mediaconvert.model.HlsTimedMetadataId3Frame? = null
        /**
         * Timed Metadata interval in seconds.
         */
        var timedMetadataId3Period: kotlin.Int? = null
        /**
         * Provides an extra millisecond delta offset to fine tune the timestamps.
         */
        var timestampDeltaMilliseconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.HlsGroupSettings) : this() {
            this.adMarkers = x.adMarkers
            this.additionalManifests = x.additionalManifests
            this.audioOnlyHeader = x.audioOnlyHeader
            this.baseUrl = x.baseUrl
            this.captionLanguageMappings = x.captionLanguageMappings
            this.captionLanguageSetting = x.captionLanguageSetting
            this.clientCache = x.clientCache
            this.codecSpecification = x.codecSpecification
            this.destination = x.destination
            this.destinationSettings = x.destinationSettings
            this.directoryStructure = x.directoryStructure
            this.encryption = x.encryption
            this.imageBasedTrickPlay = x.imageBasedTrickPlay
            this.imageBasedTrickPlaySettings = x.imageBasedTrickPlaySettings
            this.manifestCompression = x.manifestCompression
            this.manifestDurationFormat = x.manifestDurationFormat
            this.minFinalSegmentLength = x.minFinalSegmentLength
            this.minSegmentLength = x.minSegmentLength
            this.outputSelection = x.outputSelection
            this.programDateTime = x.programDateTime
            this.programDateTimePeriod = x.programDateTimePeriod
            this.segmentControl = x.segmentControl
            this.segmentLength = x.segmentLength
            this.segmentLengthControl = x.segmentLengthControl
            this.segmentsPerSubdirectory = x.segmentsPerSubdirectory
            this.streamInfResolution = x.streamInfResolution
            this.targetDurationCompatibilityMode = x.targetDurationCompatibilityMode
            this.timedMetadataId3Frame = x.timedMetadataId3Frame
            this.timedMetadataId3Period = x.timedMetadataId3Period
            this.timestampDeltaMilliseconds = x.timestampDeltaMilliseconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.HlsGroupSettings = HlsGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings] inside the given [block]
         */
        fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlaySettings] inside the given [block]
         */
        fun imageBasedTrickPlaySettings(block: aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlaySettings.Builder.() -> kotlin.Unit) {
            this.imageBasedTrickPlaySettings = aws.sdk.kotlin.services.mediaconvert.model.HlsImageBasedTrickPlaySettings.invoke(block)
        }
    }
}
