// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are specified, the default audio track within the video segment is chosen. If there is no audio within video segment, the alternative audio with DEFAULT=YES is chosen instead.
 */
class HlsRenditionGroupSettings private constructor(builder: Builder) {
    /**
     * Optional. Specify alternative group ID
     */
    val renditionGroupId: kotlin.String? = builder.renditionGroupId
    /**
     * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
     */
    val renditionLanguageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = builder.renditionLanguageCode
    /**
     * Optional. Specify media name
     */
    val renditionName: kotlin.String? = builder.renditionName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsRenditionGroupSettings(")
        append("renditionGroupId=$renditionGroupId,")
        append("renditionLanguageCode=$renditionLanguageCode,")
        append("renditionName=$renditionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = renditionGroupId?.hashCode() ?: 0
        result = 31 * result + (renditionLanguageCode?.hashCode() ?: 0)
        result = 31 * result + (renditionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsRenditionGroupSettings

        if (renditionGroupId != other.renditionGroupId) return false
        if (renditionLanguageCode != other.renditionLanguageCode) return false
        if (renditionName != other.renditionName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. Specify alternative group ID
         */
        var renditionGroupId: kotlin.String? = null
        /**
         * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
         */
        var renditionLanguageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = null
        /**
         * Optional. Specify media name
         */
        var renditionName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings) : this() {
            this.renditionGroupId = x.renditionGroupId
            this.renditionLanguageCode = x.renditionLanguageCode
            this.renditionName = x.renditionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings = HlsRenditionGroupSettings(this)
    }
}
