// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to IMSC.
 */
class ImscDestinationSettings private constructor(builder: Builder) {
    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.
     */
    val stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.ImscStylePassthrough? = builder.stylePassthrough

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImscDestinationSettings(")
        append("stylePassthrough=$stylePassthrough)")
    }

    override fun hashCode(): kotlin.Int {
        var result = stylePassthrough?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImscDestinationSettings

        if (stylePassthrough != other.stylePassthrough) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.
         */
        var stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.ImscStylePassthrough? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings) : this() {
            this.stylePassthrough = x.stylePassthrough
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = ImscDestinationSettings(this)
    }
}
