// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
 */
class JobTemplateSettings private constructor(builder: Builder) {
    /**
     * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
     */
    val adAvailOffset: kotlin.Int? = builder.adAvailOffset
    /**
     * Settings for ad avail blanking.  Video can be blanked or overlaid with an image, and audio muted during SCTE-35 triggered ad avails.
     */
    val availBlanking: aws.sdk.kotlin.services.mediaconvert.model.AvailBlanking? = builder.availBlanking
    /**
     * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these settings.
     */
    val esam: aws.sdk.kotlin.services.mediaconvert.model.EsamSettings? = builder.esam
    /**
     * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert does with the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove them from the output. For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h Content Advisory.
     */
    val extendedDataServices: aws.sdk.kotlin.services.mediaconvert.model.ExtendedDataServices? = builder.extendedDataServices
    /**
     * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job template.  Using the API, you can include multiple inputs when referencing a job template.
     */
    val inputs: List<InputTemplate>? = builder.inputs
    /**
     * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to generate and place Kantar watermarks in your output audio. These settings apply to every output in your job. In addition to specifying these values, you also need to store your Kantar credentials in AWS Secrets Manager. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
     */
    val kantarWatermark: aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings? = builder.kantarWatermark
    /**
     * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in all output groups. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
     */
    val motionImageInserter: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter? = builder.motionImageInserter
    /**
     * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of nielsenConfiguration in your JSON job specification. Even if you don't include any children of nielsenConfiguration, you still enable the setting.
     */
    val nielsenConfiguration: aws.sdk.kotlin.services.mediaconvert.model.NielsenConfiguration? = builder.nielsenConfiguration
    /**
     * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that  MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to  specifying these values, you also need to set up your cloud TIC server. These settings apply to  every output in your job. The MediaConvert implementation is currently with the following Nielsen versions: Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator &#91;SID_TIC&#93; Version &#91;5.0.0&#93;
     */
    val nielsenNonLinearWatermark: aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings? = builder.nielsenNonLinearWatermark
    /**
     * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
     */
    val outputGroups: List<OutputGroup>? = builder.outputGroups
    /**
     * These settings control how the service handles timecodes throughout the job. These settings don't affect input clipping.
     */
    val timecodeConfig: aws.sdk.kotlin.services.mediaconvert.model.TimecodeConfig? = builder.timecodeConfig
    /**
     * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in any HLS outputs. To include timed metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3 insertion (Id3Insertion) objects.
     */
    val timedMetadataInsertion: aws.sdk.kotlin.services.mediaconvert.model.TimedMetadataInsertion? = builder.timedMetadataInsertion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobTemplateSettings(")
        append("adAvailOffset=$adAvailOffset,")
        append("availBlanking=$availBlanking,")
        append("esam=$esam,")
        append("extendedDataServices=$extendedDataServices,")
        append("inputs=$inputs,")
        append("kantarWatermark=$kantarWatermark,")
        append("motionImageInserter=$motionImageInserter,")
        append("nielsenConfiguration=$nielsenConfiguration,")
        append("nielsenNonLinearWatermark=$nielsenNonLinearWatermark,")
        append("outputGroups=$outputGroups,")
        append("timecodeConfig=$timecodeConfig,")
        append("timedMetadataInsertion=$timedMetadataInsertion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adAvailOffset ?: 0
        result = 31 * result + (availBlanking?.hashCode() ?: 0)
        result = 31 * result + (esam?.hashCode() ?: 0)
        result = 31 * result + (extendedDataServices?.hashCode() ?: 0)
        result = 31 * result + (inputs?.hashCode() ?: 0)
        result = 31 * result + (kantarWatermark?.hashCode() ?: 0)
        result = 31 * result + (motionImageInserter?.hashCode() ?: 0)
        result = 31 * result + (nielsenConfiguration?.hashCode() ?: 0)
        result = 31 * result + (nielsenNonLinearWatermark?.hashCode() ?: 0)
        result = 31 * result + (outputGroups?.hashCode() ?: 0)
        result = 31 * result + (timecodeConfig?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataInsertion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobTemplateSettings

        if (adAvailOffset != other.adAvailOffset) return false
        if (availBlanking != other.availBlanking) return false
        if (esam != other.esam) return false
        if (extendedDataServices != other.extendedDataServices) return false
        if (inputs != other.inputs) return false
        if (kantarWatermark != other.kantarWatermark) return false
        if (motionImageInserter != other.motionImageInserter) return false
        if (nielsenConfiguration != other.nielsenConfiguration) return false
        if (nielsenNonLinearWatermark != other.nielsenNonLinearWatermark) return false
        if (outputGroups != other.outputGroups) return false
        if (timecodeConfig != other.timecodeConfig) return false
        if (timedMetadataInsertion != other.timedMetadataInsertion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
         */
        var adAvailOffset: kotlin.Int? = null
        /**
         * Settings for ad avail blanking.  Video can be blanked or overlaid with an image, and audio muted during SCTE-35 triggered ad avails.
         */
        var availBlanking: aws.sdk.kotlin.services.mediaconvert.model.AvailBlanking? = null
        /**
         * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these settings.
         */
        var esam: aws.sdk.kotlin.services.mediaconvert.model.EsamSettings? = null
        /**
         * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert does with the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove them from the output. For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h Content Advisory.
         */
        var extendedDataServices: aws.sdk.kotlin.services.mediaconvert.model.ExtendedDataServices? = null
        /**
         * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job template.  Using the API, you can include multiple inputs when referencing a job template.
         */
        var inputs: List<InputTemplate>? = null
        /**
         * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to generate and place Kantar watermarks in your output audio. These settings apply to every output in your job. In addition to specifying these values, you also need to store your Kantar credentials in AWS Secrets Manager. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
         */
        var kantarWatermark: aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings? = null
        /**
         * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in all output groups. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/motion-graphic-overlay.html.
         */
        var motionImageInserter: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter? = null
        /**
         * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of nielsenConfiguration in your JSON job specification. Even if you don't include any children of nielsenConfiguration, you still enable the setting.
         */
        var nielsenConfiguration: aws.sdk.kotlin.services.mediaconvert.model.NielsenConfiguration? = null
        /**
         * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that  MediaConvert uses to generate and place Nielsen watermarks in your output audio. In addition to  specifying these values, you also need to set up your cloud TIC server. These settings apply to  every output in your job. The MediaConvert implementation is currently with the following Nielsen versions: Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine Version 1.2.7 Nielsen Watermark Authenticator &#91;SID_TIC&#93; Version &#91;5.0.0&#93;
         */
        var nielsenNonLinearWatermark: aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings? = null
        /**
         * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
         */
        var outputGroups: List<OutputGroup>? = null
        /**
         * These settings control how the service handles timecodes throughout the job. These settings don't affect input clipping.
         */
        var timecodeConfig: aws.sdk.kotlin.services.mediaconvert.model.TimecodeConfig? = null
        /**
         * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in any HLS outputs. To include timed metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3 insertion (Id3Insertion) objects.
         */
        var timedMetadataInsertion: aws.sdk.kotlin.services.mediaconvert.model.TimedMetadataInsertion? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings) : this() {
            this.adAvailOffset = x.adAvailOffset
            this.availBlanking = x.availBlanking
            this.esam = x.esam
            this.extendedDataServices = x.extendedDataServices
            this.inputs = x.inputs
            this.kantarWatermark = x.kantarWatermark
            this.motionImageInserter = x.motionImageInserter
            this.nielsenConfiguration = x.nielsenConfiguration
            this.nielsenNonLinearWatermark = x.nielsenNonLinearWatermark
            this.outputGroups = x.outputGroups
            this.timecodeConfig = x.timecodeConfig
            this.timedMetadataInsertion = x.timedMetadataInsertion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings = JobTemplateSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AvailBlanking] inside the given [block]
         */
        fun availBlanking(block: aws.sdk.kotlin.services.mediaconvert.model.AvailBlanking.Builder.() -> kotlin.Unit) {
            this.availBlanking = aws.sdk.kotlin.services.mediaconvert.model.AvailBlanking.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.EsamSettings] inside the given [block]
         */
        fun esam(block: aws.sdk.kotlin.services.mediaconvert.model.EsamSettings.Builder.() -> kotlin.Unit) {
            this.esam = aws.sdk.kotlin.services.mediaconvert.model.EsamSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ExtendedDataServices] inside the given [block]
         */
        fun extendedDataServices(block: aws.sdk.kotlin.services.mediaconvert.model.ExtendedDataServices.Builder.() -> kotlin.Unit) {
            this.extendedDataServices = aws.sdk.kotlin.services.mediaconvert.model.ExtendedDataServices.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings] inside the given [block]
         */
        fun kantarWatermark(block: aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings.Builder.() -> kotlin.Unit) {
            this.kantarWatermark = aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter] inside the given [block]
         */
        fun motionImageInserter(block: aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter.Builder.() -> kotlin.Unit) {
            this.motionImageInserter = aws.sdk.kotlin.services.mediaconvert.model.MotionImageInserter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.NielsenConfiguration] inside the given [block]
         */
        fun nielsenConfiguration(block: aws.sdk.kotlin.services.mediaconvert.model.NielsenConfiguration.Builder.() -> kotlin.Unit) {
            this.nielsenConfiguration = aws.sdk.kotlin.services.mediaconvert.model.NielsenConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings] inside the given [block]
         */
        fun nielsenNonLinearWatermark(block: aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings.Builder.() -> kotlin.Unit) {
            this.nielsenNonLinearWatermark = aws.sdk.kotlin.services.mediaconvert.model.NielsenNonLinearWatermarkSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.TimecodeConfig] inside the given [block]
         */
        fun timecodeConfig(block: aws.sdk.kotlin.services.mediaconvert.model.TimecodeConfig.Builder.() -> kotlin.Unit) {
            this.timecodeConfig = aws.sdk.kotlin.services.mediaconvert.model.TimecodeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.TimedMetadataInsertion] inside the given [block]
         */
        fun timedMetadataInsertion(block: aws.sdk.kotlin.services.mediaconvert.model.TimedMetadataInsertion.Builder.() -> kotlin.Unit) {
            this.timedMetadataInsertion = aws.sdk.kotlin.services.mediaconvert.model.TimedMetadataInsertion.invoke(block)
        }
    }
}
