// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to generate and place Kantar watermarks in your output audio. These settings apply to every output in your job. In addition to specifying these values, you also need to store your Kantar credentials in AWS Secrets Manager. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
 */
class KantarWatermarkSettings private constructor(builder: Builder) {
    /**
     * Provide an audio channel name from your Kantar audio license.
     */
    val channelName: kotlin.String? = builder.channelName
    /**
     * Specify a unique identifier for Kantar to use for this piece of content.
     */
    val contentReference: kotlin.String? = builder.contentReference
    /**
     * Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that your MediaConvert service role must provide access to this secret. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets-manager-secret.html. For instructions on creating a secret, see https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets Manager User Guide.
     */
    val credentialsSecretName: kotlin.String? = builder.credentialsSecretName
    /**
     * Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the watermarking. When you don't specify an offset, Kantar defaults to zero.
     */
    val fileOffset: kotlin.Double? = builder.fileOffset
    /**
     * Provide your Kantar license ID number. You should get this number from Kantar.
     */
    val kantarLicenseId: kotlin.Int? = builder.kantarLicenseId
    /**
     * Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
     */
    val kantarServerUrl: kotlin.String? = builder.kantarServerUrl
    /**
     * Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML logs. When you don't specify a bucket, MediaConvert doesn't save these logs. Note that your MediaConvert service role must provide access to this location. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     */
    val logDestination: kotlin.String? = builder.logDestination
    /**
     * You can optionally use this field to specify the first timestamp that Kantar embeds during watermarking. Kantar suggests that you be very cautious when using this Kantar feature, and that you use it only on channels that are managed specifically for use with this feature by your Audience Measurement Operator. For more information about this feature, contact Kantar technical support.
     */
    val metadata3: kotlin.String? = builder.metadata3
    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    val metadata4: kotlin.String? = builder.metadata4
    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    val metadata5: kotlin.String? = builder.metadata5
    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    val metadata6: kotlin.String? = builder.metadata6
    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    val metadata7: kotlin.String? = builder.metadata7
    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    val metadata8: kotlin.String? = builder.metadata8

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KantarWatermarkSettings(")
        append("channelName=$channelName,")
        append("contentReference=$contentReference,")
        append("credentialsSecretName=$credentialsSecretName,")
        append("fileOffset=$fileOffset,")
        append("kantarLicenseId=$kantarLicenseId,")
        append("kantarServerUrl=$kantarServerUrl,")
        append("logDestination=$logDestination,")
        append("metadata3=$metadata3,")
        append("metadata4=$metadata4,")
        append("metadata5=$metadata5,")
        append("metadata6=$metadata6,")
        append("metadata7=$metadata7,")
        append("metadata8=$metadata8)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (contentReference?.hashCode() ?: 0)
        result = 31 * result + (credentialsSecretName?.hashCode() ?: 0)
        result = 31 * result + (fileOffset?.hashCode() ?: 0)
        result = 31 * result + (kantarLicenseId ?: 0)
        result = 31 * result + (kantarServerUrl?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (metadata3?.hashCode() ?: 0)
        result = 31 * result + (metadata4?.hashCode() ?: 0)
        result = 31 * result + (metadata5?.hashCode() ?: 0)
        result = 31 * result + (metadata6?.hashCode() ?: 0)
        result = 31 * result + (metadata7?.hashCode() ?: 0)
        result = 31 * result + (metadata8?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KantarWatermarkSettings

        if (channelName != other.channelName) return false
        if (contentReference != other.contentReference) return false
        if (credentialsSecretName != other.credentialsSecretName) return false
        if (fileOffset != other.fileOffset) return false
        if (kantarLicenseId != other.kantarLicenseId) return false
        if (kantarServerUrl != other.kantarServerUrl) return false
        if (logDestination != other.logDestination) return false
        if (metadata3 != other.metadata3) return false
        if (metadata4 != other.metadata4) return false
        if (metadata5 != other.metadata5) return false
        if (metadata6 != other.metadata6) return false
        if (metadata7 != other.metadata7) return false
        if (metadata8 != other.metadata8) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provide an audio channel name from your Kantar audio license.
         */
        var channelName: kotlin.String? = null
        /**
         * Specify a unique identifier for Kantar to use for this piece of content.
         */
        var contentReference: kotlin.String? = null
        /**
         * Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that your MediaConvert service role must provide access to this secret. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets-manager-secret.html. For instructions on creating a secret, see https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets Manager User Guide.
         */
        var credentialsSecretName: kotlin.String? = null
        /**
         * Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the watermarking. When you don't specify an offset, Kantar defaults to zero.
         */
        var fileOffset: kotlin.Double? = null
        /**
         * Provide your Kantar license ID number. You should get this number from Kantar.
         */
        var kantarLicenseId: kotlin.Int? = null
        /**
         * Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
         */
        var kantarServerUrl: kotlin.String? = null
        /**
         * Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML logs. When you don't specify a bucket, MediaConvert doesn't save these logs. Note that your MediaConvert service role must provide access to this location. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         */
        var logDestination: kotlin.String? = null
        /**
         * You can optionally use this field to specify the first timestamp that Kantar embeds during watermarking. Kantar suggests that you be very cautious when using this Kantar feature, and that you use it only on channels that are managed specifically for use with this feature by your Audience Measurement Operator. For more information about this feature, contact Kantar technical support.
         */
        var metadata3: kotlin.String? = null
        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         */
        var metadata4: kotlin.String? = null
        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         */
        var metadata5: kotlin.String? = null
        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         */
        var metadata6: kotlin.String? = null
        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         */
        var metadata7: kotlin.String? = null
        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         */
        var metadata8: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings) : this() {
            this.channelName = x.channelName
            this.contentReference = x.contentReference
            this.credentialsSecretName = x.credentialsSecretName
            this.fileOffset = x.fileOffset
            this.kantarLicenseId = x.kantarLicenseId
            this.kantarServerUrl = x.kantarServerUrl
            this.logDestination = x.logDestination
            this.metadata3 = x.metadata3
            this.metadata4 = x.metadata4
            this.metadata5 = x.metadata5
            this.metadata6 = x.metadata6
            this.metadata7 = x.metadata7
            this.metadata8 = x.metadata8
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.KantarWatermarkSettings = KantarWatermarkSettings(this)
    }
}
