// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings relate to your MP4 output container. You can create audio only outputs with this container. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio-only.html#output-codecs-and-containers-supported-for-audio-only.
 */
class Mp4Settings private constructor(builder: Builder) {
    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     */
    val audioDuration: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioDuration? = builder.audioDuration
    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     */
    val cslgAtom: aws.sdk.kotlin.services.mediaconvert.model.Mp4CslgAtom? = builder.cslgAtom
    /**
     * Ignore this setting unless compliance to the CTTS box version specification matters in your workflow. Specify a value of 1 to set your CTTS box version to 1 and make your output compliant with the specification. When you specify a value of 1, you must also set CSLG atom (cslgAtom) to the value INCLUDE. Keep the default value 0 to set your CTTS box version to 0. This can provide backward compatibility for some players and packagers.
     */
    val cttsVersion: kotlin.Int? = builder.cttsVersion
    /**
     * Inserts a free-space box immediately after the moov box.
     */
    val freeSpaceBox: aws.sdk.kotlin.services.mediaconvert.model.Mp4FreeSpaceBox? = builder.freeSpaceBox
    /**
     * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.
     */
    val moovPlacement: aws.sdk.kotlin.services.mediaconvert.model.Mp4MoovPlacement? = builder.moovPlacement
    /**
     * Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
     */
    val mp4MajorBrand: kotlin.String? = builder.mp4MajorBrand

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Mp4Settings(")
        append("audioDuration=$audioDuration,")
        append("cslgAtom=$cslgAtom,")
        append("cttsVersion=$cttsVersion,")
        append("freeSpaceBox=$freeSpaceBox,")
        append("moovPlacement=$moovPlacement,")
        append("mp4MajorBrand=$mp4MajorBrand)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDuration?.hashCode() ?: 0
        result = 31 * result + (cslgAtom?.hashCode() ?: 0)
        result = 31 * result + (cttsVersion ?: 0)
        result = 31 * result + (freeSpaceBox?.hashCode() ?: 0)
        result = 31 * result + (moovPlacement?.hashCode() ?: 0)
        result = 31 * result + (mp4MajorBrand?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Mp4Settings

        if (audioDuration != other.audioDuration) return false
        if (cslgAtom != other.cslgAtom) return false
        if (cttsVersion != other.cttsVersion) return false
        if (freeSpaceBox != other.freeSpaceBox) return false
        if (moovPlacement != other.moovPlacement) return false
        if (mp4MajorBrand != other.mp4MajorBrand) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
         */
        var audioDuration: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioDuration? = null
        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         */
        var cslgAtom: aws.sdk.kotlin.services.mediaconvert.model.Mp4CslgAtom? = null
        /**
         * Ignore this setting unless compliance to the CTTS box version specification matters in your workflow. Specify a value of 1 to set your CTTS box version to 1 and make your output compliant with the specification. When you specify a value of 1, you must also set CSLG atom (cslgAtom) to the value INCLUDE. Keep the default value 0 to set your CTTS box version to 0. This can provide backward compatibility for some players and packagers.
         */
        var cttsVersion: kotlin.Int? = null
        /**
         * Inserts a free-space box immediately after the moov box.
         */
        var freeSpaceBox: aws.sdk.kotlin.services.mediaconvert.model.Mp4FreeSpaceBox? = null
        /**
         * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.
         */
        var moovPlacement: aws.sdk.kotlin.services.mediaconvert.model.Mp4MoovPlacement? = null
        /**
         * Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
         */
        var mp4MajorBrand: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings) : this() {
            this.audioDuration = x.audioDuration
            this.cslgAtom = x.cslgAtom
            this.cttsVersion = x.cttsVersion
            this.freeSpaceBox = x.freeSpaceBox
            this.moovPlacement = x.moovPlacement
            this.mp4MajorBrand = x.mp4MajorBrand
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings = Mp4Settings(this)
    }
}
