// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Group of outputs
 */
class OutputGroup private constructor(builder: Builder) {
    /**
     * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics of your input video.
     */
    val automatedEncodingSettings: aws.sdk.kotlin.services.mediaconvert.model.AutomatedEncodingSettings? = builder.automatedEncodingSettings
    /**
     * Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the console and can make your job settings JSON more human-readable. It does not affect your outputs. Use up to twelve characters that are either letters, numbers, spaces, or underscores.
     */
    val customName: kotlin.String? = builder.customName
    /**
     * Name of the output group
     */
    val name: kotlin.String? = builder.name
    /**
     * Output Group settings, including type
     */
    val outputGroupSettings: aws.sdk.kotlin.services.mediaconvert.model.OutputGroupSettings? = builder.outputGroupSettings
    /**
     * This object holds groups of encoding settings, one group of settings per output.
     */
    val outputs: List<Output>? = builder.outputs

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.OutputGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputGroup(")
        append("automatedEncodingSettings=$automatedEncodingSettings,")
        append("customName=$customName,")
        append("name=$name,")
        append("outputGroupSettings=$outputGroupSettings,")
        append("outputs=$outputs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = automatedEncodingSettings?.hashCode() ?: 0
        result = 31 * result + (customName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputGroupSettings?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputGroup

        if (automatedEncodingSettings != other.automatedEncodingSettings) return false
        if (customName != other.customName) return false
        if (name != other.name) return false
        if (outputGroupSettings != other.outputGroupSettings) return false
        if (outputs != other.outputs) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.OutputGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics of your input video.
         */
        var automatedEncodingSettings: aws.sdk.kotlin.services.mediaconvert.model.AutomatedEncodingSettings? = null
        /**
         * Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the console and can make your job settings JSON more human-readable. It does not affect your outputs. Use up to twelve characters that are either letters, numbers, spaces, or underscores.
         */
        var customName: kotlin.String? = null
        /**
         * Name of the output group
         */
        var name: kotlin.String? = null
        /**
         * Output Group settings, including type
         */
        var outputGroupSettings: aws.sdk.kotlin.services.mediaconvert.model.OutputGroupSettings? = null
        /**
         * This object holds groups of encoding settings, one group of settings per output.
         */
        var outputs: List<Output>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.OutputGroup) : this() {
            this.automatedEncodingSettings = x.automatedEncodingSettings
            this.customName = x.customName
            this.name = x.name
            this.outputGroupSettings = x.outputGroupSettings
            this.outputs = x.outputs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.OutputGroup = OutputGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AutomatedEncodingSettings] inside the given [block]
         */
        fun automatedEncodingSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AutomatedEncodingSettings.Builder.() -> kotlin.Unit) {
            this.automatedEncodingSettings = aws.sdk.kotlin.services.mediaconvert.model.AutomatedEncodingSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.OutputGroupSettings] inside the given [block]
         */
        fun outputGroupSettings(block: aws.sdk.kotlin.services.mediaconvert.model.OutputGroupSettings.Builder.() -> kotlin.Unit) {
            this.outputGroupSettings = aws.sdk.kotlin.services.mediaconvert.model.OutputGroupSettings.invoke(block)
        }
    }
}
