// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
 */
class ReservationPlanSettings private constructor(builder: Builder) {
    /**
     * The length of the term of your reserved queue pricing plan commitment.
     */
    val commitment: aws.sdk.kotlin.services.mediaconvert.model.Commitment? = builder.commitment
    /**
     * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
     */
    val renewalType: aws.sdk.kotlin.services.mediaconvert.model.RenewalType? = builder.renewalType
    /**
     * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
     */
    val reservedSlots: kotlin.Int? = builder.reservedSlots

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservationPlanSettings(")
        append("commitment=$commitment,")
        append("renewalType=$renewalType,")
        append("reservedSlots=$reservedSlots)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitment?.hashCode() ?: 0
        result = 31 * result + (renewalType?.hashCode() ?: 0)
        result = 31 * result + (reservedSlots ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservationPlanSettings

        if (commitment != other.commitment) return false
        if (renewalType != other.renewalType) return false
        if (reservedSlots != other.reservedSlots) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The length of the term of your reserved queue pricing plan commitment.
         */
        var commitment: aws.sdk.kotlin.services.mediaconvert.model.Commitment? = null
        /**
         * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
         */
        var renewalType: aws.sdk.kotlin.services.mediaconvert.model.RenewalType? = null
        /**
         * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
         */
        var reservedSlots: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings) : this() {
            this.commitment = x.commitment
            this.renewalType = x.renewalType
            this.reservedSlots = x.reservedSlots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings = ReservationPlanSettings(this)
    }
}
