// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to SCC.
 */
class SccDestinationSettings private constructor(builder: Builder) {
    /**
     * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
     */
    val framerate: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationFramerate? = builder.framerate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SccDestinationSettings(")
        append("framerate=$framerate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = framerate?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SccDestinationSettings

        if (framerate != other.framerate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
         */
        var framerate: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationFramerate? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings) : this() {
            this.framerate = x.framerate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings = SccDestinationSettings(this)
    }
}
