// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
 */
class VideoCodecSettings private constructor(builder: Builder) {
    /**
     * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
     */
    val av1Settings: aws.sdk.kotlin.services.mediaconvert.model.Av1Settings? = builder.av1Settings
    /**
     * Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
     */
    val avcIntraSettings: aws.sdk.kotlin.services.mediaconvert.model.AvcIntraSettings? = builder.avcIntraSettings
    /**
     * Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
     */
    val codec: aws.sdk.kotlin.services.mediaconvert.model.VideoCodec? = builder.codec
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
     */
    val frameCaptureSettings: aws.sdk.kotlin.services.mediaconvert.model.FrameCaptureSettings? = builder.frameCaptureSettings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
     */
    val h264Settings: aws.sdk.kotlin.services.mediaconvert.model.H264Settings? = builder.h264Settings
    /**
     * Settings for H265 codec
     */
    val h265Settings: aws.sdk.kotlin.services.mediaconvert.model.H265Settings? = builder.h265Settings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
     */
    val mpeg2Settings: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings? = builder.mpeg2Settings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
     */
    val proresSettings: aws.sdk.kotlin.services.mediaconvert.model.ProresSettings? = builder.proresSettings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
     */
    val vc3Settings: aws.sdk.kotlin.services.mediaconvert.model.Vc3Settings? = builder.vc3Settings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
     */
    val vp8Settings: aws.sdk.kotlin.services.mediaconvert.model.Vp8Settings? = builder.vp8Settings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
     */
    val vp9Settings: aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings? = builder.vp9Settings
    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
     */
    val xavcSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcSettings? = builder.xavcSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoCodecSettings(")
        append("av1Settings=$av1Settings,")
        append("avcIntraSettings=$avcIntraSettings,")
        append("codec=$codec,")
        append("frameCaptureSettings=$frameCaptureSettings,")
        append("h264Settings=$h264Settings,")
        append("h265Settings=$h265Settings,")
        append("mpeg2Settings=$mpeg2Settings,")
        append("proresSettings=$proresSettings,")
        append("vc3Settings=$vc3Settings,")
        append("vp8Settings=$vp8Settings,")
        append("vp9Settings=$vp9Settings,")
        append("xavcSettings=$xavcSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = av1Settings?.hashCode() ?: 0
        result = 31 * result + (avcIntraSettings?.hashCode() ?: 0)
        result = 31 * result + (codec?.hashCode() ?: 0)
        result = 31 * result + (frameCaptureSettings?.hashCode() ?: 0)
        result = 31 * result + (h264Settings?.hashCode() ?: 0)
        result = 31 * result + (h265Settings?.hashCode() ?: 0)
        result = 31 * result + (mpeg2Settings?.hashCode() ?: 0)
        result = 31 * result + (proresSettings?.hashCode() ?: 0)
        result = 31 * result + (vc3Settings?.hashCode() ?: 0)
        result = 31 * result + (vp8Settings?.hashCode() ?: 0)
        result = 31 * result + (vp9Settings?.hashCode() ?: 0)
        result = 31 * result + (xavcSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoCodecSettings

        if (av1Settings != other.av1Settings) return false
        if (avcIntraSettings != other.avcIntraSettings) return false
        if (codec != other.codec) return false
        if (frameCaptureSettings != other.frameCaptureSettings) return false
        if (h264Settings != other.h264Settings) return false
        if (h265Settings != other.h265Settings) return false
        if (mpeg2Settings != other.mpeg2Settings) return false
        if (proresSettings != other.proresSettings) return false
        if (vc3Settings != other.vc3Settings) return false
        if (vp8Settings != other.vp8Settings) return false
        if (vp9Settings != other.vp9Settings) return false
        if (xavcSettings != other.xavcSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
         */
        var av1Settings: aws.sdk.kotlin.services.mediaconvert.model.Av1Settings? = null
        /**
         * Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
         */
        var avcIntraSettings: aws.sdk.kotlin.services.mediaconvert.model.AvcIntraSettings? = null
        /**
         * Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
         */
        var codec: aws.sdk.kotlin.services.mediaconvert.model.VideoCodec? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
         */
        var frameCaptureSettings: aws.sdk.kotlin.services.mediaconvert.model.FrameCaptureSettings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
         */
        var h264Settings: aws.sdk.kotlin.services.mediaconvert.model.H264Settings? = null
        /**
         * Settings for H265 codec
         */
        var h265Settings: aws.sdk.kotlin.services.mediaconvert.model.H265Settings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
         */
        var mpeg2Settings: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
         */
        var proresSettings: aws.sdk.kotlin.services.mediaconvert.model.ProresSettings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
         */
        var vc3Settings: aws.sdk.kotlin.services.mediaconvert.model.Vc3Settings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
         */
        var vp8Settings: aws.sdk.kotlin.services.mediaconvert.model.Vp8Settings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
         */
        var vp9Settings: aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings? = null
        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
         */
        var xavcSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings) : this() {
            this.av1Settings = x.av1Settings
            this.avcIntraSettings = x.avcIntraSettings
            this.codec = x.codec
            this.frameCaptureSettings = x.frameCaptureSettings
            this.h264Settings = x.h264Settings
            this.h265Settings = x.h265Settings
            this.mpeg2Settings = x.mpeg2Settings
            this.proresSettings = x.proresSettings
            this.vc3Settings = x.vc3Settings
            this.vp8Settings = x.vp8Settings
            this.vp9Settings = x.vp9Settings
            this.xavcSettings = x.xavcSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings = VideoCodecSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Av1Settings] inside the given [block]
         */
        fun av1Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Av1Settings.Builder.() -> kotlin.Unit) {
            this.av1Settings = aws.sdk.kotlin.services.mediaconvert.model.Av1Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AvcIntraSettings] inside the given [block]
         */
        fun avcIntraSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AvcIntraSettings.Builder.() -> kotlin.Unit) {
            this.avcIntraSettings = aws.sdk.kotlin.services.mediaconvert.model.AvcIntraSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.FrameCaptureSettings] inside the given [block]
         */
        fun frameCaptureSettings(block: aws.sdk.kotlin.services.mediaconvert.model.FrameCaptureSettings.Builder.() -> kotlin.Unit) {
            this.frameCaptureSettings = aws.sdk.kotlin.services.mediaconvert.model.FrameCaptureSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.H264Settings] inside the given [block]
         */
        fun h264Settings(block: aws.sdk.kotlin.services.mediaconvert.model.H264Settings.Builder.() -> kotlin.Unit) {
            this.h264Settings = aws.sdk.kotlin.services.mediaconvert.model.H264Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.H265Settings] inside the given [block]
         */
        fun h265Settings(block: aws.sdk.kotlin.services.mediaconvert.model.H265Settings.Builder.() -> kotlin.Unit) {
            this.h265Settings = aws.sdk.kotlin.services.mediaconvert.model.H265Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings] inside the given [block]
         */
        fun mpeg2Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings.Builder.() -> kotlin.Unit) {
            this.mpeg2Settings = aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ProresSettings] inside the given [block]
         */
        fun proresSettings(block: aws.sdk.kotlin.services.mediaconvert.model.ProresSettings.Builder.() -> kotlin.Unit) {
            this.proresSettings = aws.sdk.kotlin.services.mediaconvert.model.ProresSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Vc3Settings] inside the given [block]
         */
        fun vc3Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Vc3Settings.Builder.() -> kotlin.Unit) {
            this.vc3Settings = aws.sdk.kotlin.services.mediaconvert.model.Vc3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Vp8Settings] inside the given [block]
         */
        fun vp8Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Vp8Settings.Builder.() -> kotlin.Unit) {
            this.vp8Settings = aws.sdk.kotlin.services.mediaconvert.model.Vp8Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings] inside the given [block]
         */
        fun vp9Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings.Builder.() -> kotlin.Unit) {
            this.vp9Settings = aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.XavcSettings] inside the given [block]
         */
        fun xavcSettings(block: aws.sdk.kotlin.services.mediaconvert.model.XavcSettings.Builder.() -> kotlin.Unit) {
            this.xavcSettings = aws.sdk.kotlin.services.mediaconvert.model.XavcSettings.invoke(block)
        }
    }
}
