// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to video encoding of your output. The specific video settings depend on the video codec that you choose. When you work directly in your JSON job specification, include one instance of Video description (VideoDescription) per output.
 */
class VideoDescription private constructor(builder: Builder) {
    /**
     * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
     */
    val afdSignaling: aws.sdk.kotlin.services.mediaconvert.model.AfdSignaling? = builder.afdSignaling
    /**
     * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
     */
    val antiAlias: aws.sdk.kotlin.services.mediaconvert.model.AntiAlias? = builder.antiAlias
    /**
     * Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
     */
    val codecSettings: aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings? = builder.codecSettings
    /**
     * Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
     */
    val colorMetadata: aws.sdk.kotlin.services.mediaconvert.model.ColorMetadata? = builder.colorMetadata
    /**
     * Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
     */
    val crop: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = builder.crop
    /**
     * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
     */
    val dropFrameTimecode: aws.sdk.kotlin.services.mediaconvert.model.DropFrameTimecode? = builder.dropFrameTimecode
    /**
     * Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
     */
    val fixedAfd: kotlin.Int? = builder.fixedAfd
    /**
     * Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
     */
    val height: kotlin.Int? = builder.height
    /**
     * Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
     */
    val position: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = builder.position
    /**
     * Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
     */
    val respondToAfd: aws.sdk.kotlin.services.mediaconvert.model.RespondToAfd? = builder.respondToAfd
    /**
     * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
     */
    val scalingBehavior: aws.sdk.kotlin.services.mediaconvert.model.ScalingBehavior? = builder.scalingBehavior
    /**
     * Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
     */
    val sharpness: kotlin.Int? = builder.sharpness
    /**
     * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
     */
    val timecodeInsertion: aws.sdk.kotlin.services.mediaconvert.model.VideoTimecodeInsertion? = builder.timecodeInsertion
    /**
     * Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
     */
    val videoPreprocessors: aws.sdk.kotlin.services.mediaconvert.model.VideoPreprocessor? = builder.videoPreprocessors
    /**
     * Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
     */
    val width: kotlin.Int? = builder.width

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.VideoDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoDescription(")
        append("afdSignaling=$afdSignaling,")
        append("antiAlias=$antiAlias,")
        append("codecSettings=$codecSettings,")
        append("colorMetadata=$colorMetadata,")
        append("crop=$crop,")
        append("dropFrameTimecode=$dropFrameTimecode,")
        append("fixedAfd=$fixedAfd,")
        append("height=$height,")
        append("position=$position,")
        append("respondToAfd=$respondToAfd,")
        append("scalingBehavior=$scalingBehavior,")
        append("sharpness=$sharpness,")
        append("timecodeInsertion=$timecodeInsertion,")
        append("videoPreprocessors=$videoPreprocessors,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = afdSignaling?.hashCode() ?: 0
        result = 31 * result + (antiAlias?.hashCode() ?: 0)
        result = 31 * result + (codecSettings?.hashCode() ?: 0)
        result = 31 * result + (colorMetadata?.hashCode() ?: 0)
        result = 31 * result + (crop?.hashCode() ?: 0)
        result = 31 * result + (dropFrameTimecode?.hashCode() ?: 0)
        result = 31 * result + (fixedAfd ?: 0)
        result = 31 * result + (height ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (respondToAfd?.hashCode() ?: 0)
        result = 31 * result + (scalingBehavior?.hashCode() ?: 0)
        result = 31 * result + (sharpness ?: 0)
        result = 31 * result + (timecodeInsertion?.hashCode() ?: 0)
        result = 31 * result + (videoPreprocessors?.hashCode() ?: 0)
        result = 31 * result + (width ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoDescription

        if (afdSignaling != other.afdSignaling) return false
        if (antiAlias != other.antiAlias) return false
        if (codecSettings != other.codecSettings) return false
        if (colorMetadata != other.colorMetadata) return false
        if (crop != other.crop) return false
        if (dropFrameTimecode != other.dropFrameTimecode) return false
        if (fixedAfd != other.fixedAfd) return false
        if (height != other.height) return false
        if (position != other.position) return false
        if (respondToAfd != other.respondToAfd) return false
        if (scalingBehavior != other.scalingBehavior) return false
        if (sharpness != other.sharpness) return false
        if (timecodeInsertion != other.timecodeInsertion) return false
        if (videoPreprocessors != other.videoPreprocessors) return false
        if (width != other.width) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.VideoDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
         */
        var afdSignaling: aws.sdk.kotlin.services.mediaconvert.model.AfdSignaling? = null
        /**
         * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
         */
        var antiAlias: aws.sdk.kotlin.services.mediaconvert.model.AntiAlias? = null
        /**
         * Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
         */
        var codecSettings: aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings? = null
        /**
         * Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
         */
        var colorMetadata: aws.sdk.kotlin.services.mediaconvert.model.ColorMetadata? = null
        /**
         * Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
         */
        var crop: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = null
        /**
         * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
         */
        var dropFrameTimecode: aws.sdk.kotlin.services.mediaconvert.model.DropFrameTimecode? = null
        /**
         * Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
         */
        var fixedAfd: kotlin.Int? = null
        /**
         * Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
         */
        var height: kotlin.Int? = null
        /**
         * Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
         */
        var position: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = null
        /**
         * Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
         */
        var respondToAfd: aws.sdk.kotlin.services.mediaconvert.model.RespondToAfd? = null
        /**
         * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
         */
        var scalingBehavior: aws.sdk.kotlin.services.mediaconvert.model.ScalingBehavior? = null
        /**
         * Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
         */
        var sharpness: kotlin.Int? = null
        /**
         * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
         */
        var timecodeInsertion: aws.sdk.kotlin.services.mediaconvert.model.VideoTimecodeInsertion? = null
        /**
         * Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
         */
        var videoPreprocessors: aws.sdk.kotlin.services.mediaconvert.model.VideoPreprocessor? = null
        /**
         * Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
         */
        var width: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.VideoDescription) : this() {
            this.afdSignaling = x.afdSignaling
            this.antiAlias = x.antiAlias
            this.codecSettings = x.codecSettings
            this.colorMetadata = x.colorMetadata
            this.crop = x.crop
            this.dropFrameTimecode = x.dropFrameTimecode
            this.fixedAfd = x.fixedAfd
            this.height = x.height
            this.position = x.position
            this.respondToAfd = x.respondToAfd
            this.scalingBehavior = x.scalingBehavior
            this.sharpness = x.sharpness
            this.timecodeInsertion = x.timecodeInsertion
            this.videoPreprocessors = x.videoPreprocessors
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.VideoDescription = VideoDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings] inside the given [block]
         */
        fun codecSettings(block: aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings.Builder.() -> kotlin.Unit) {
            this.codecSettings = aws.sdk.kotlin.services.mediaconvert.model.VideoCodecSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Rectangle] inside the given [block]
         */
        fun crop(block: aws.sdk.kotlin.services.mediaconvert.model.Rectangle.Builder.() -> kotlin.Unit) {
            this.crop = aws.sdk.kotlin.services.mediaconvert.model.Rectangle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Rectangle] inside the given [block]
         */
        fun position(block: aws.sdk.kotlin.services.mediaconvert.model.Rectangle.Builder.() -> kotlin.Unit) {
            this.position = aws.sdk.kotlin.services.mediaconvert.model.Rectangle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.VideoPreprocessor] inside the given [block]
         */
        fun videoPreprocessors(block: aws.sdk.kotlin.services.mediaconvert.model.VideoPreprocessor.Builder.() -> kotlin.Unit) {
            this.videoPreprocessors = aws.sdk.kotlin.services.mediaconvert.model.VideoPreprocessor.invoke(block)
        }
    }
}
