// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video selector.
 */
class VideoSelector private constructor(builder: Builder) {
    /**
     * Ignore this setting unless this input is a QuickTime animation with an alpha channel. Use this setting to create separate Key and Fill outputs. In each output, specify which part of the input MediaConvert uses. Leave this setting at the default value DISCARD to delete the alpha channel and preserve the video. Set it to REMAP_TO_LUMA to delete the video and map the alpha channel to the luma channel of your outputs.
     */
    val alphaBehavior: aws.sdk.kotlin.services.mediaconvert.model.AlphaBehavior? = builder.alphaBehavior
    /**
     * If your input video has accurate color space metadata, or if you don't know about color space, leave this set to the default value Follow (FOLLOW). The service will automatically detect your input color space. If your input video has metadata indicating the wrong color space, specify the accurate color space here. If your input video is HDR 10 and the SMPTE ST 2086 Mastering Display Color Volume static metadata isn't present in your video stream, or if that metadata is present but not accurate, choose Force HDR 10 (FORCE_HDR10) here and specify correct values in the input HDR 10 metadata (Hdr10Metadata) settings. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
     */
    val colorSpace: aws.sdk.kotlin.services.mediaconvert.model.ColorSpace? = builder.colorSpace
    /**
     * There are two sources for color metadata, the input file and the job input settings Color space (ColorSpace) and HDR master display information settings(Hdr10Metadata). The Color space usage setting determines which takes precedence. Choose Force (FORCE) to use color metadata from the input job settings. If you don't specify values for those settings, the service defaults to using metadata from your input. FALLBACK - Choose Fallback (FALLBACK) to use color metadata from the source when it is present. If there's no color metadata in your input file, the service defaults to using values you specify in the input settings.
     */
    val colorSpaceUsage: aws.sdk.kotlin.services.mediaconvert.model.ColorSpaceUsage? = builder.colorSpaceUsage
    /**
     * Use these settings to provide HDR 10 metadata that is missing or inaccurate in your input video. Appropriate values vary depending on the input video and must be provided by a color grader. The color grader generates these values during the HDR 10 mastering process. The valid range for each of these settings is 0 to 50,000. Each increment represents 0.00002 in CIE1931 color coordinate. Related settings - When you specify these values, you must also set Color space (ColorSpace) to HDR 10 (HDR10). To specify whether the the values you specify here take precedence over the values in the metadata of your input file, set Color space usage (ColorSpaceUsage). To specify whether color metadata is included in an output, set Color metadata (ColorMetadata). For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
     */
    val hdr10Metadata: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata? = builder.hdr10Metadata
    /**
     * Use PID (Pid) to select specific video data from an input file. Specify this value as an integer; the system automatically converts it to the hexidecimal value. For example, 257 selects PID 0x101. A PID, or packet identifier, is an identifier for a set of data in an MPEG-2 transport stream container.
     */
    val pid: kotlin.Int? = builder.pid
    /**
     * Selects a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported.
     */
    val programNumber: kotlin.Int? = builder.programNumber
    /**
     * Use Rotate (InputRotate) to specify how the service rotates your video. You can choose automatic rotation or specify a rotation. You can specify a clockwise rotation of 0, 90, 180, or 270 degrees. If your input video container is .mov or .mp4 and your input has rotation metadata, you can choose Automatic to have the service rotate your video according to the rotation specified in the metadata. The rotation must be within one degree of 90, 180, or 270 degrees. If the rotation metadata specifies any other rotation, the service will default to no rotation. By default, the service does no rotation, even if your input video has rotation metadata. The service doesn't pass through rotation metadata.
     */
    val rotate: aws.sdk.kotlin.services.mediaconvert.model.InputRotate? = builder.rotate
    /**
     * If the sample range metadata in your input video is accurate, or if you don't know about sample range, keep the default value, Follow (FOLLOW), for this setting. When you do, the service automatically detects your input sample range. If your input video has metadata indicating the wrong sample range, specify the accurate sample range here. When you do, MediaConvert ignores any sample range information in the input metadata. Regardless of whether MediaConvert uses the input sample range or the sample range that you specify, MediaConvert uses the sample range for transcoding and also writes it to the output metadata.
     */
    val sampleRange: aws.sdk.kotlin.services.mediaconvert.model.InputSampleRange? = builder.sampleRange

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.VideoSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoSelector(")
        append("alphaBehavior=$alphaBehavior,")
        append("colorSpace=$colorSpace,")
        append("colorSpaceUsage=$colorSpaceUsage,")
        append("hdr10Metadata=$hdr10Metadata,")
        append("pid=$pid,")
        append("programNumber=$programNumber,")
        append("rotate=$rotate,")
        append("sampleRange=$sampleRange)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alphaBehavior?.hashCode() ?: 0
        result = 31 * result + (colorSpace?.hashCode() ?: 0)
        result = 31 * result + (colorSpaceUsage?.hashCode() ?: 0)
        result = 31 * result + (hdr10Metadata?.hashCode() ?: 0)
        result = 31 * result + (pid ?: 0)
        result = 31 * result + (programNumber ?: 0)
        result = 31 * result + (rotate?.hashCode() ?: 0)
        result = 31 * result + (sampleRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoSelector

        if (alphaBehavior != other.alphaBehavior) return false
        if (colorSpace != other.colorSpace) return false
        if (colorSpaceUsage != other.colorSpaceUsage) return false
        if (hdr10Metadata != other.hdr10Metadata) return false
        if (pid != other.pid) return false
        if (programNumber != other.programNumber) return false
        if (rotate != other.rotate) return false
        if (sampleRange != other.sampleRange) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.VideoSelector = Builder(this).apply(block).build()

    class Builder {
        /**
         * Ignore this setting unless this input is a QuickTime animation with an alpha channel. Use this setting to create separate Key and Fill outputs. In each output, specify which part of the input MediaConvert uses. Leave this setting at the default value DISCARD to delete the alpha channel and preserve the video. Set it to REMAP_TO_LUMA to delete the video and map the alpha channel to the luma channel of your outputs.
         */
        var alphaBehavior: aws.sdk.kotlin.services.mediaconvert.model.AlphaBehavior? = null
        /**
         * If your input video has accurate color space metadata, or if you don't know about color space, leave this set to the default value Follow (FOLLOW). The service will automatically detect your input color space. If your input video has metadata indicating the wrong color space, specify the accurate color space here. If your input video is HDR 10 and the SMPTE ST 2086 Mastering Display Color Volume static metadata isn't present in your video stream, or if that metadata is present but not accurate, choose Force HDR 10 (FORCE_HDR10) here and specify correct values in the input HDR 10 metadata (Hdr10Metadata) settings. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
         */
        var colorSpace: aws.sdk.kotlin.services.mediaconvert.model.ColorSpace? = null
        /**
         * There are two sources for color metadata, the input file and the job input settings Color space (ColorSpace) and HDR master display information settings(Hdr10Metadata). The Color space usage setting determines which takes precedence. Choose Force (FORCE) to use color metadata from the input job settings. If you don't specify values for those settings, the service defaults to using metadata from your input. FALLBACK - Choose Fallback (FALLBACK) to use color metadata from the source when it is present. If there's no color metadata in your input file, the service defaults to using values you specify in the input settings.
         */
        var colorSpaceUsage: aws.sdk.kotlin.services.mediaconvert.model.ColorSpaceUsage? = null
        /**
         * Use these settings to provide HDR 10 metadata that is missing or inaccurate in your input video. Appropriate values vary depending on the input video and must be provided by a color grader. The color grader generates these values during the HDR 10 mastering process. The valid range for each of these settings is 0 to 50,000. Each increment represents 0.00002 in CIE1931 color coordinate. Related settings - When you specify these values, you must also set Color space (ColorSpace) to HDR 10 (HDR10). To specify whether the the values you specify here take precedence over the values in the metadata of your input file, set Color space usage (ColorSpaceUsage). To specify whether color metadata is included in an output, set Color metadata (ColorMetadata). For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
         */
        var hdr10Metadata: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata? = null
        /**
         * Use PID (Pid) to select specific video data from an input file. Specify this value as an integer; the system automatically converts it to the hexidecimal value. For example, 257 selects PID 0x101. A PID, or packet identifier, is an identifier for a set of data in an MPEG-2 transport stream container.
         */
        var pid: kotlin.Int? = null
        /**
         * Selects a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported.
         */
        var programNumber: kotlin.Int? = null
        /**
         * Use Rotate (InputRotate) to specify how the service rotates your video. You can choose automatic rotation or specify a rotation. You can specify a clockwise rotation of 0, 90, 180, or 270 degrees. If your input video container is .mov or .mp4 and your input has rotation metadata, you can choose Automatic to have the service rotate your video according to the rotation specified in the metadata. The rotation must be within one degree of 90, 180, or 270 degrees. If the rotation metadata specifies any other rotation, the service will default to no rotation. By default, the service does no rotation, even if your input video has rotation metadata. The service doesn't pass through rotation metadata.
         */
        var rotate: aws.sdk.kotlin.services.mediaconvert.model.InputRotate? = null
        /**
         * If the sample range metadata in your input video is accurate, or if you don't know about sample range, keep the default value, Follow (FOLLOW), for this setting. When you do, the service automatically detects your input sample range. If your input video has metadata indicating the wrong sample range, specify the accurate sample range here. When you do, MediaConvert ignores any sample range information in the input metadata. Regardless of whether MediaConvert uses the input sample range or the sample range that you specify, MediaConvert uses the sample range for transcoding and also writes it to the output metadata.
         */
        var sampleRange: aws.sdk.kotlin.services.mediaconvert.model.InputSampleRange? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.VideoSelector) : this() {
            this.alphaBehavior = x.alphaBehavior
            this.colorSpace = x.colorSpace
            this.colorSpaceUsage = x.colorSpaceUsage
            this.hdr10Metadata = x.hdr10Metadata
            this.pid = x.pid
            this.programNumber = x.programNumber
            this.rotate = x.rotate
            this.sampleRange = x.sampleRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.VideoSelector = VideoSelector(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata] inside the given [block]
         */
        fun hdr10Metadata(block: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata.Builder.() -> kotlin.Unit) {
            this.hdr10Metadata = aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata.invoke(block)
        }
    }
}
