// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
 */
class Xavc4KProfileSettings private constructor(builder: Builder) {
    /**
     * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
     */
    val bitrateClass: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileBitrateClass? = builder.bitrateClass
    /**
     * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
     */
    val codecProfile: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileCodecProfile? = builder.codecProfile
    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     */
    val flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcFlickerAdaptiveQuantization? = builder.flickerAdaptiveQuantization
    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
     */
    val gopBReference: aws.sdk.kotlin.services.mediaconvert.model.XavcGopBReference? = builder.gopBReference
    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
     */
    val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
     */
    val hrdBufferSize: kotlin.Int? = builder.hrdBufferSize
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     */
    val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileQualityTuningLevel? = builder.qualityTuningLevel
    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    val slices: kotlin.Int? = builder.slices

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Xavc4KProfileSettings(")
        append("bitrateClass=$bitrateClass,")
        append("codecProfile=$codecProfile,")
        append("flickerAdaptiveQuantization=$flickerAdaptiveQuantization,")
        append("gopBReference=$gopBReference,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("slices=$slices)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitrateClass?.hashCode() ?: 0
        result = 31 * result + (codecProfile?.hashCode() ?: 0)
        result = 31 * result + (flickerAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (gopBReference?.hashCode() ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (hrdBufferSize ?: 0)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (slices ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Xavc4KProfileSettings

        if (bitrateClass != other.bitrateClass) return false
        if (codecProfile != other.codecProfile) return false
        if (flickerAdaptiveQuantization != other.flickerAdaptiveQuantization) return false
        if (gopBReference != other.gopBReference) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (slices != other.slices) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
         */
        var bitrateClass: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileBitrateClass? = null
        /**
         * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
         */
        var codecProfile: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileCodecProfile? = null
        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         */
        var flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcFlickerAdaptiveQuantization? = null
        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
         */
        var gopBReference: aws.sdk.kotlin.services.mediaconvert.model.XavcGopBReference? = null
        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
         */
        var gopClosedCadence: kotlin.Int? = null
        /**
         * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         */
        var hrdBufferSize: kotlin.Int? = null
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         */
        var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileQualityTuningLevel? = null
        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         */
        var slices: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings) : this() {
            this.bitrateClass = x.bitrateClass
            this.codecProfile = x.codecProfile
            this.flickerAdaptiveQuantization = x.flickerAdaptiveQuantization
            this.gopBReference = x.gopBReference
            this.gopClosedCadence = x.gopClosedCadence
            this.hrdBufferSize = x.hrdBufferSize
            this.qualityTuningLevel = x.qualityTuningLevel
            this.slices = x.slices
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings = Xavc4KProfileSettings(this)
    }
}
