// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.medialive.model.*
import aws.sdk.kotlin.services.medialive.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.execute
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "MediaLive"
public const val ServiceApiVersion: String = "2017-10-14"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultMediaLiveClient(override val config: MediaLiveClient.Config) : MediaLiveClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     */
    override suspend fun acceptInputDeviceTransfer(input: AcceptInputDeviceTransferRequest): AcceptInputDeviceTransferResponse {
        val op = SdkHttpOperation.build<AcceptInputDeviceTransferRequest, AcceptInputDeviceTransferResponse> {
            serializer = AcceptInputDeviceTransferOperationSerializer()
            deserializer = AcceptInputDeviceTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInputDeviceTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts delete of resources.
     */
    override suspend fun batchDelete(input: BatchDeleteRequest): BatchDeleteResponse {
        val op = SdkHttpOperation.build<BatchDeleteRequest, BatchDeleteResponse> {
            serializer = BatchDeleteOperationSerializer()
            deserializer = BatchDeleteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDelete"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts existing resources
     */
    override suspend fun batchStart(input: BatchStartRequest): BatchStartResponse {
        val op = SdkHttpOperation.build<BatchStartRequest, BatchStartResponse> {
            serializer = BatchStartOperationSerializer()
            deserializer = BatchStartOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchStart"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops running resources
     */
    override suspend fun batchStop(input: BatchStopRequest): BatchStopResponse {
        val op = SdkHttpOperation.build<BatchStopRequest, BatchStopResponse> {
            serializer = BatchStopOperationSerializer()
            deserializer = BatchStopOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchStop"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a channel schedule
     */
    override suspend fun batchUpdateSchedule(input: BatchUpdateScheduleRequest): BatchUpdateScheduleResponse {
        val op = SdkHttpOperation.build<BatchUpdateScheduleRequest, BatchUpdateScheduleResponse> {
            serializer = BatchUpdateScheduleOperationSerializer()
            deserializer = BatchUpdateScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancel an input device transfer that you have requested.
     */
    override suspend fun cancelInputDeviceTransfer(input: CancelInputDeviceTransferRequest): CancelInputDeviceTransferResponse {
        val op = SdkHttpOperation.build<CancelInputDeviceTransferRequest, CancelInputDeviceTransferResponse> {
            serializer = CancelInputDeviceTransferOperationSerializer()
            deserializer = CancelInputDeviceTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelInputDeviceTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the request succeeds, you will own the device.
     */
    override suspend fun claimDevice(input: ClaimDeviceRequest): ClaimDeviceResponse {
        val op = SdkHttpOperation.build<ClaimDeviceRequest, ClaimDeviceResponse> {
            serializer = ClaimDeviceOperationSerializer()
            deserializer = ClaimDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClaimDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new channel
     */
    override suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse {
        val op = SdkHttpOperation.build<CreateChannelRequest, CreateChannelResponse> {
            serializer = CreateChannelOperationSerializer()
            deserializer = CreateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an input
     */
    override suspend fun createInput(input: CreateInputRequest): CreateInputResponse {
        val op = SdkHttpOperation.build<CreateInputRequest, CreateInputResponse> {
            serializer = CreateInputOperationSerializer()
            deserializer = CreateInputOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Input Security Group
     */
    override suspend fun createInputSecurityGroup(input: CreateInputSecurityGroupRequest): CreateInputSecurityGroupResponse {
        val op = SdkHttpOperation.build<CreateInputSecurityGroupRequest, CreateInputSecurityGroupResponse> {
            serializer = CreateInputSecurityGroupOperationSerializer()
            deserializer = CreateInputSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInputSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new multiplex.
     */
    override suspend fun createMultiplex(input: CreateMultiplexRequest): CreateMultiplexResponse {
        val op = SdkHttpOperation.build<CreateMultiplexRequest, CreateMultiplexResponse> {
            serializer = CreateMultiplexOperationSerializer()
            deserializer = CreateMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new program in the multiplex.
     */
    override suspend fun createMultiplexProgram(input: CreateMultiplexProgramRequest): CreateMultiplexProgramResponse {
        val op = SdkHttpOperation.build<CreateMultiplexProgramRequest, CreateMultiplexProgramResponse> {
            serializer = CreateMultiplexProgramOperationSerializer()
            deserializer = CreateMultiplexProgramOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMultiplexProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a partner input
     */
    override suspend fun createPartnerInput(input: CreatePartnerInputRequest): CreatePartnerInputResponse {
        val op = SdkHttpOperation.build<CreatePartnerInputRequest, CreatePartnerInputResponse> {
            serializer = CreatePartnerInputOperationSerializer()
            deserializer = CreatePartnerInputOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePartnerInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create tags for a resource
     */
    override suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse {
        val op = SdkHttpOperation.build<CreateTagsRequest, CreateTagsResponse> {
            serializer = CreateTagsOperationSerializer()
            deserializer = CreateTagsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "CreateTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     */
    override suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse {
        val op = SdkHttpOperation.build<DeleteChannelRequest, DeleteChannelResponse> {
            serializer = DeleteChannelOperationSerializer()
            deserializer = DeleteChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the input end point
     */
    override suspend fun deleteInput(input: DeleteInputRequest): DeleteInputResponse {
        val op = SdkHttpOperation.build<DeleteInputRequest, DeleteInputResponse> {
            serializer = DeleteInputOperationSerializer()
            deserializer = DeleteInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Input Security Group
     */
    override suspend fun deleteInputSecurityGroup(input: DeleteInputSecurityGroupRequest): DeleteInputSecurityGroupResponse {
        val op = SdkHttpOperation.build<DeleteInputSecurityGroupRequest, DeleteInputSecurityGroupResponse> {
            serializer = DeleteInputSecurityGroupOperationSerializer()
            deserializer = DeleteInputSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInputSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     */
    override suspend fun deleteMultiplex(input: DeleteMultiplexRequest): DeleteMultiplexResponse {
        val op = SdkHttpOperation.build<DeleteMultiplexRequest, DeleteMultiplexResponse> {
            serializer = DeleteMultiplexOperationSerializer()
            deserializer = DeleteMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a program from a multiplex.
     */
    override suspend fun deleteMultiplexProgram(input: DeleteMultiplexProgramRequest): DeleteMultiplexProgramResponse {
        val op = SdkHttpOperation.build<DeleteMultiplexProgramRequest, DeleteMultiplexProgramResponse> {
            serializer = DeleteMultiplexProgramOperationSerializer()
            deserializer = DeleteMultiplexProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMultiplexProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an expired reservation.
     */
    override suspend fun deleteReservation(input: DeleteReservationRequest): DeleteReservationResponse {
        val op = SdkHttpOperation.build<DeleteReservationRequest, DeleteReservationResponse> {
            serializer = DeleteReservationOperationSerializer()
            deserializer = DeleteReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete all schedule actions on a channel.
     */
    override suspend fun deleteSchedule(input: DeleteScheduleRequest): DeleteScheduleResponse {
        val op = SdkHttpOperation.build<DeleteScheduleRequest, DeleteScheduleResponse> {
            serializer = DeleteScheduleOperationSerializer()
            deserializer = DeleteScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags for a resource
     */
    override suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse {
        val op = SdkHttpOperation.build<DeleteTagsRequest, DeleteTagsResponse> {
            serializer = DeleteTagsOperationSerializer()
            deserializer = DeleteTagsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a channel
     */
    override suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse {
        val op = SdkHttpOperation.build<DescribeChannelRequest, DescribeChannelResponse> {
            serializer = DescribeChannelOperationSerializer()
            deserializer = DescribeChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Produces details about an input
     */
    override suspend fun describeInput(input: DescribeInputRequest): DescribeInputResponse {
        val op = SdkHttpOperation.build<DescribeInputRequest, DescribeInputResponse> {
            serializer = DescribeInputOperationSerializer()
            deserializer = DescribeInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details for the input device
     */
    override suspend fun describeInputDevice(input: DescribeInputDeviceRequest): DescribeInputDeviceResponse {
        val op = SdkHttpOperation.build<DescribeInputDeviceRequest, DescribeInputDeviceResponse> {
            serializer = DescribeInputDeviceOperationSerializer()
            deserializer = DescribeInputDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInputDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the latest thumbnail data for the input device.
     */
    override suspend fun <T> describeInputDeviceThumbnail(input: DescribeInputDeviceThumbnailRequest, block: suspend (DescribeInputDeviceThumbnailResponse) -> T): T {
        val op = SdkHttpOperation.build<DescribeInputDeviceThumbnailRequest, DescribeInputDeviceThumbnailResponse> {
            serializer = DescribeInputDeviceThumbnailOperationSerializer()
            deserializer = DescribeInputDeviceThumbnailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInputDeviceThumbnail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.execute(client, input, block)
    }

    /**
     * Produces a summary of an Input Security Group
     */
    override suspend fun describeInputSecurityGroup(input: DescribeInputSecurityGroupRequest): DescribeInputSecurityGroupResponse {
        val op = SdkHttpOperation.build<DescribeInputSecurityGroupRequest, DescribeInputSecurityGroupResponse> {
            serializer = DescribeInputSecurityGroupOperationSerializer()
            deserializer = DescribeInputSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInputSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a multiplex.
     */
    override suspend fun describeMultiplex(input: DescribeMultiplexRequest): DescribeMultiplexResponse {
        val op = SdkHttpOperation.build<DescribeMultiplexRequest, DescribeMultiplexResponse> {
            serializer = DescribeMultiplexOperationSerializer()
            deserializer = DescribeMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the details for a program in a multiplex.
     */
    override suspend fun describeMultiplexProgram(input: DescribeMultiplexProgramRequest): DescribeMultiplexProgramResponse {
        val op = SdkHttpOperation.build<DescribeMultiplexProgramRequest, DescribeMultiplexProgramResponse> {
            serializer = DescribeMultiplexProgramOperationSerializer()
            deserializer = DescribeMultiplexProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMultiplexProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get details for an offering.
     */
    override suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse {
        val op = SdkHttpOperation.build<DescribeOfferingRequest, DescribeOfferingResponse> {
            serializer = DescribeOfferingOperationSerializer()
            deserializer = DescribeOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get details for a reservation.
     */
    override suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse {
        val op = SdkHttpOperation.build<DescribeReservationRequest, DescribeReservationResponse> {
            serializer = DescribeReservationOperationSerializer()
            deserializer = DescribeReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a channel schedule
     */
    override suspend fun describeSchedule(input: DescribeScheduleRequest): DescribeScheduleResponse {
        val op = SdkHttpOperation.build<DescribeScheduleRequest, DescribeScheduleResponse> {
            serializer = DescribeScheduleOperationSerializer()
            deserializer = DescribeScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Produces list of channels that have been created
     */
    override suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse {
        val op = SdkHttpOperation.build<ListChannelsRequest, ListChannelsResponse> {
            serializer = ListChannelsOperationSerializer()
            deserializer = ListChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.
     */
    override suspend fun listInputDeviceTransfers(input: ListInputDeviceTransfersRequest): ListInputDeviceTransfersResponse {
        val op = SdkHttpOperation.build<ListInputDeviceTransfersRequest, ListInputDeviceTransfersResponse> {
            serializer = ListInputDeviceTransfersOperationSerializer()
            deserializer = ListInputDeviceTransfersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputDeviceTransfers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List input devices
     */
    override suspend fun listInputDevices(input: ListInputDevicesRequest): ListInputDevicesResponse {
        val op = SdkHttpOperation.build<ListInputDevicesRequest, ListInputDevicesResponse> {
            serializer = ListInputDevicesOperationSerializer()
            deserializer = ListInputDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Produces a list of Input Security Groups for an account
     */
    override suspend fun listInputSecurityGroups(input: ListInputSecurityGroupsRequest): ListInputSecurityGroupsResponse {
        val op = SdkHttpOperation.build<ListInputSecurityGroupsRequest, ListInputSecurityGroupsResponse> {
            serializer = ListInputSecurityGroupsOperationSerializer()
            deserializer = ListInputSecurityGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputSecurityGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Produces list of inputs that have been created
     */
    override suspend fun listInputs(input: ListInputsRequest): ListInputsResponse {
        val op = SdkHttpOperation.build<ListInputsRequest, ListInputsResponse> {
            serializer = ListInputsOperationSerializer()
            deserializer = ListInputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     */
    override suspend fun listMultiplexPrograms(input: ListMultiplexProgramsRequest): ListMultiplexProgramsResponse {
        val op = SdkHttpOperation.build<ListMultiplexProgramsRequest, ListMultiplexProgramsResponse> {
            serializer = ListMultiplexProgramsOperationSerializer()
            deserializer = ListMultiplexProgramsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMultiplexPrograms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of the existing multiplexes.
     */
    override suspend fun listMultiplexes(input: ListMultiplexesRequest): ListMultiplexesResponse {
        val op = SdkHttpOperation.build<ListMultiplexesRequest, ListMultiplexesResponse> {
            serializer = ListMultiplexesOperationSerializer()
            deserializer = ListMultiplexesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMultiplexes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List offerings available for purchase.
     */
    override suspend fun listOfferings(input: ListOfferingsRequest): ListOfferingsResponse {
        val op = SdkHttpOperation.build<ListOfferingsRequest, ListOfferingsResponse> {
            serializer = ListOfferingsOperationSerializer()
            deserializer = ListOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List purchased reservations.
     */
    override suspend fun listReservations(input: ListReservationsRequest): ListReservationsResponse {
        val op = SdkHttpOperation.build<ListReservationsRequest, ListReservationsResponse> {
            serializer = ListReservationsOperationSerializer()
            deserializer = ListReservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReservations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Produces list of tags that have been created for a resource
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Purchase an offering and create a reservation.
     */
    override suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseOfferingRequest, PurchaseOfferingResponse> {
            serializer = PurchaseOfferingOperationSerializer()
            deserializer = PurchaseOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PurchaseOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of sending the command. When the reboot is complete, the device’s connection status will change to connected.
     */
    override suspend fun rebootInputDevice(input: RebootInputDeviceRequest): RebootInputDeviceResponse {
        val op = SdkHttpOperation.build<RebootInputDeviceRequest, RebootInputDeviceResponse> {
            serializer = RebootInputDeviceOperationSerializer()
            deserializer = RebootInputDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootInputDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.
     */
    override suspend fun rejectInputDeviceTransfer(input: RejectInputDeviceTransferRequest): RejectInputDeviceTransferResponse {
        val op = SdkHttpOperation.build<RejectInputDeviceTransferRequest, RejectInputDeviceTransferResponse> {
            serializer = RejectInputDeviceTransferOperationSerializer()
            deserializer = RejectInputDeviceTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectInputDeviceTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an existing channel
     */
    override suspend fun startChannel(input: StartChannelRequest): StartChannelResponse {
        val op = SdkHttpOperation.build<StartChannelRequest, StartChannelResponse> {
            serializer = StartChannelOperationSerializer()
            deserializer = StartChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming when the software is fully installed. Devices automatically install updates while they are powered on and their MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop MediaLive channels that use the device. The device must remain powered on and connected to the internet for the duration of the maintenance.
     */
    override suspend fun startInputDeviceMaintenanceWindow(input: StartInputDeviceMaintenanceWindowRequest): StartInputDeviceMaintenanceWindowResponse {
        val op = SdkHttpOperation.build<StartInputDeviceMaintenanceWindowRequest, StartInputDeviceMaintenanceWindowResponse> {
            serializer = StartInputDeviceMaintenanceWindowOperationSerializer()
            deserializer = StartInputDeviceMaintenanceWindowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartInputDeviceMaintenanceWindow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.
     */
    override suspend fun startMultiplex(input: StartMultiplexRequest): StartMultiplexResponse {
        val op = SdkHttpOperation.build<StartMultiplexRequest, StartMultiplexResponse> {
            serializer = StartMultiplexOperationSerializer()
            deserializer = StartMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StartMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a running channel
     */
    override suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse {
        val op = SdkHttpOperation.build<StopChannelRequest, StopChannelResponse> {
            serializer = StopChannelOperationSerializer()
            deserializer = StopChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     */
    override suspend fun stopMultiplex(input: StopMultiplexRequest): StopMultiplexResponse {
        val op = SdkHttpOperation.build<StopMultiplexRequest, StopMultiplexResponse> {
            serializer = StopMultiplexOperationSerializer()
            deserializer = StopMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StopMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.
     */
    override suspend fun transferInputDevice(input: TransferInputDeviceRequest): TransferInputDeviceResponse {
        val op = SdkHttpOperation.build<TransferInputDeviceRequest, TransferInputDeviceResponse> {
            serializer = TransferInputDeviceOperationSerializer()
            deserializer = TransferInputDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TransferInputDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a channel.
     */
    override suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse {
        val op = SdkHttpOperation.build<UpdateChannelRequest, UpdateChannelResponse> {
            serializer = UpdateChannelOperationSerializer()
            deserializer = UpdateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the class of the channel.
     */
    override suspend fun updateChannelClass(input: UpdateChannelClassRequest): UpdateChannelClassResponse {
        val op = SdkHttpOperation.build<UpdateChannelClassRequest, UpdateChannelClassResponse> {
            serializer = UpdateChannelClassOperationSerializer()
            deserializer = UpdateChannelClassOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannelClass"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an input.
     */
    override suspend fun updateInput(input: UpdateInputRequest): UpdateInputResponse {
        val op = SdkHttpOperation.build<UpdateInputRequest, UpdateInputResponse> {
            serializer = UpdateInputOperationSerializer()
            deserializer = UpdateInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the parameters for the input device.
     */
    override suspend fun updateInputDevice(input: UpdateInputDeviceRequest): UpdateInputDeviceResponse {
        val op = SdkHttpOperation.build<UpdateInputDeviceRequest, UpdateInputDeviceResponse> {
            serializer = UpdateInputDeviceOperationSerializer()
            deserializer = UpdateInputDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInputDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an Input Security Group's Whilelists.
     */
    override suspend fun updateInputSecurityGroup(input: UpdateInputSecurityGroupRequest): UpdateInputSecurityGroupResponse {
        val op = SdkHttpOperation.build<UpdateInputSecurityGroupRequest, UpdateInputSecurityGroupResponse> {
            serializer = UpdateInputSecurityGroupOperationSerializer()
            deserializer = UpdateInputSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInputSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a multiplex.
     */
    override suspend fun updateMultiplex(input: UpdateMultiplexRequest): UpdateMultiplexResponse {
        val op = SdkHttpOperation.build<UpdateMultiplexRequest, UpdateMultiplexResponse> {
            serializer = UpdateMultiplexOperationSerializer()
            deserializer = UpdateMultiplexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMultiplex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a program in a multiplex.
     */
    override suspend fun updateMultiplexProgram(input: UpdateMultiplexProgramRequest): UpdateMultiplexProgramResponse {
        val op = SdkHttpOperation.build<UpdateMultiplexProgramRequest, UpdateMultiplexProgramResponse> {
            serializer = UpdateMultiplexProgramOperationSerializer()
            deserializer = UpdateMultiplexProgramOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMultiplexProgram"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update reservation.
     */
    override suspend fun updateReservation(input: UpdateReservationRequest): UpdateReservationResponse {
        val op = SdkHttpOperation.build<UpdateReservationRequest, UpdateReservationResponse> {
            serializer = UpdateReservationOperationSerializer()
            deserializer = UpdateReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateReservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "medialive"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "medialive")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
