// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.medialive.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.medialive.model.*
import aws.sdk.kotlin.services.medialive.model.AcceptInputDeviceTransferRequest
import aws.sdk.kotlin.services.medialive.model.AcceptInputDeviceTransferResponse
import aws.sdk.kotlin.services.medialive.model.BatchDeleteRequest
import aws.sdk.kotlin.services.medialive.model.BatchDeleteResponse
import aws.sdk.kotlin.services.medialive.model.BatchStartRequest
import aws.sdk.kotlin.services.medialive.model.BatchStartResponse
import aws.sdk.kotlin.services.medialive.model.BatchStopRequest
import aws.sdk.kotlin.services.medialive.model.BatchStopResponse
import aws.sdk.kotlin.services.medialive.model.BatchUpdateScheduleRequest
import aws.sdk.kotlin.services.medialive.model.BatchUpdateScheduleResponse
import aws.sdk.kotlin.services.medialive.model.CancelInputDeviceTransferRequest
import aws.sdk.kotlin.services.medialive.model.CancelInputDeviceTransferResponse
import aws.sdk.kotlin.services.medialive.model.ClaimDeviceRequest
import aws.sdk.kotlin.services.medialive.model.ClaimDeviceResponse
import aws.sdk.kotlin.services.medialive.model.CreateChannelRequest
import aws.sdk.kotlin.services.medialive.model.CreateChannelResponse
import aws.sdk.kotlin.services.medialive.model.CreateInputRequest
import aws.sdk.kotlin.services.medialive.model.CreateInputResponse
import aws.sdk.kotlin.services.medialive.model.CreateInputSecurityGroupRequest
import aws.sdk.kotlin.services.medialive.model.CreateInputSecurityGroupResponse
import aws.sdk.kotlin.services.medialive.model.CreateMultiplexProgramRequest
import aws.sdk.kotlin.services.medialive.model.CreateMultiplexProgramResponse
import aws.sdk.kotlin.services.medialive.model.CreateMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.CreateMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.CreatePartnerInputRequest
import aws.sdk.kotlin.services.medialive.model.CreatePartnerInputResponse
import aws.sdk.kotlin.services.medialive.model.CreateTagsRequest
import aws.sdk.kotlin.services.medialive.model.CreateTagsResponse
import aws.sdk.kotlin.services.medialive.model.DeleteChannelRequest
import aws.sdk.kotlin.services.medialive.model.DeleteChannelResponse
import aws.sdk.kotlin.services.medialive.model.DeleteInputRequest
import aws.sdk.kotlin.services.medialive.model.DeleteInputResponse
import aws.sdk.kotlin.services.medialive.model.DeleteInputSecurityGroupRequest
import aws.sdk.kotlin.services.medialive.model.DeleteInputSecurityGroupResponse
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexProgramRequest
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexProgramResponse
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.DeleteMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.DeleteReservationRequest
import aws.sdk.kotlin.services.medialive.model.DeleteReservationResponse
import aws.sdk.kotlin.services.medialive.model.DeleteScheduleRequest
import aws.sdk.kotlin.services.medialive.model.DeleteScheduleResponse
import aws.sdk.kotlin.services.medialive.model.DeleteTagsRequest
import aws.sdk.kotlin.services.medialive.model.DeleteTagsResponse
import aws.sdk.kotlin.services.medialive.model.DescribeChannelRequest
import aws.sdk.kotlin.services.medialive.model.DescribeChannelResponse
import aws.sdk.kotlin.services.medialive.model.DescribeInputDeviceRequest
import aws.sdk.kotlin.services.medialive.model.DescribeInputDeviceResponse
import aws.sdk.kotlin.services.medialive.model.DescribeInputRequest
import aws.sdk.kotlin.services.medialive.model.DescribeInputResponse
import aws.sdk.kotlin.services.medialive.model.DescribeInputSecurityGroupRequest
import aws.sdk.kotlin.services.medialive.model.DescribeInputSecurityGroupResponse
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexProgramRequest
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexProgramResponse
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.DescribeMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.DescribeOfferingRequest
import aws.sdk.kotlin.services.medialive.model.DescribeOfferingResponse
import aws.sdk.kotlin.services.medialive.model.DescribeReservationRequest
import aws.sdk.kotlin.services.medialive.model.DescribeReservationResponse
import aws.sdk.kotlin.services.medialive.model.DescribeScheduleRequest
import aws.sdk.kotlin.services.medialive.model.DescribeScheduleResponse
import aws.sdk.kotlin.services.medialive.model.ListChannelsRequest
import aws.sdk.kotlin.services.medialive.model.ListChannelsResponse
import aws.sdk.kotlin.services.medialive.model.ListInputDeviceTransfersRequest
import aws.sdk.kotlin.services.medialive.model.ListInputDeviceTransfersResponse
import aws.sdk.kotlin.services.medialive.model.ListInputDevicesRequest
import aws.sdk.kotlin.services.medialive.model.ListInputDevicesResponse
import aws.sdk.kotlin.services.medialive.model.ListInputSecurityGroupsRequest
import aws.sdk.kotlin.services.medialive.model.ListInputSecurityGroupsResponse
import aws.sdk.kotlin.services.medialive.model.ListInputsRequest
import aws.sdk.kotlin.services.medialive.model.ListInputsResponse
import aws.sdk.kotlin.services.medialive.model.ListMultiplexProgramsRequest
import aws.sdk.kotlin.services.medialive.model.ListMultiplexProgramsResponse
import aws.sdk.kotlin.services.medialive.model.ListMultiplexesRequest
import aws.sdk.kotlin.services.medialive.model.ListMultiplexesResponse
import aws.sdk.kotlin.services.medialive.model.ListOfferingsRequest
import aws.sdk.kotlin.services.medialive.model.ListOfferingsResponse
import aws.sdk.kotlin.services.medialive.model.ListReservationsRequest
import aws.sdk.kotlin.services.medialive.model.ListReservationsResponse
import aws.sdk.kotlin.services.medialive.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.medialive.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.medialive.model.PurchaseOfferingRequest
import aws.sdk.kotlin.services.medialive.model.PurchaseOfferingResponse
import aws.sdk.kotlin.services.medialive.model.RebootInputDeviceRequest
import aws.sdk.kotlin.services.medialive.model.RebootInputDeviceResponse
import aws.sdk.kotlin.services.medialive.model.RejectInputDeviceTransferRequest
import aws.sdk.kotlin.services.medialive.model.RejectInputDeviceTransferResponse
import aws.sdk.kotlin.services.medialive.model.StartChannelRequest
import aws.sdk.kotlin.services.medialive.model.StartChannelResponse
import aws.sdk.kotlin.services.medialive.model.StartInputDeviceMaintenanceWindowRequest
import aws.sdk.kotlin.services.medialive.model.StartInputDeviceMaintenanceWindowResponse
import aws.sdk.kotlin.services.medialive.model.StartMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.StartMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.StopChannelRequest
import aws.sdk.kotlin.services.medialive.model.StopChannelResponse
import aws.sdk.kotlin.services.medialive.model.StopMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.StopMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.TransferInputDeviceRequest
import aws.sdk.kotlin.services.medialive.model.TransferInputDeviceResponse
import aws.sdk.kotlin.services.medialive.model.UpdateChannelClassRequest
import aws.sdk.kotlin.services.medialive.model.UpdateChannelClassResponse
import aws.sdk.kotlin.services.medialive.model.UpdateChannelRequest
import aws.sdk.kotlin.services.medialive.model.UpdateChannelResponse
import aws.sdk.kotlin.services.medialive.model.UpdateInputDeviceRequest
import aws.sdk.kotlin.services.medialive.model.UpdateInputDeviceResponse
import aws.sdk.kotlin.services.medialive.model.UpdateInputRequest
import aws.sdk.kotlin.services.medialive.model.UpdateInputResponse
import aws.sdk.kotlin.services.medialive.model.UpdateInputSecurityGroupRequest
import aws.sdk.kotlin.services.medialive.model.UpdateInputSecurityGroupResponse
import aws.sdk.kotlin.services.medialive.model.UpdateMultiplexProgramRequest
import aws.sdk.kotlin.services.medialive.model.UpdateMultiplexProgramResponse
import aws.sdk.kotlin.services.medialive.model.UpdateMultiplexRequest
import aws.sdk.kotlin.services.medialive.model.UpdateMultiplexResponse
import aws.sdk.kotlin.services.medialive.model.UpdateReservationRequest
import aws.sdk.kotlin.services.medialive.model.UpdateReservationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * API for AWS Elemental MediaLive
 */
public interface MediaLiveClient : SdkClient {

    override val serviceName: String
        get() = "MediaLive"
    /**
     * MediaLiveClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MediaLiveClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaLiveClient(config)
        }

        public operator fun invoke(config: Config): MediaLiveClient = DefaultMediaLiveClient(config)

        /**
         * Construct a [MediaLiveClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaLiveClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaLiveClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     */
    public suspend fun acceptInputDeviceTransfer(input: AcceptInputDeviceTransferRequest): AcceptInputDeviceTransferResponse

    /**
     * Starts delete of resources.
     */
    public suspend fun batchDelete(input: BatchDeleteRequest = BatchDeleteRequest {}): BatchDeleteResponse

    /**
     * Starts existing resources
     */
    public suspend fun batchStart(input: BatchStartRequest = BatchStartRequest {}): BatchStartResponse

    /**
     * Stops running resources
     */
    public suspend fun batchStop(input: BatchStopRequest = BatchStopRequest {}): BatchStopResponse

    /**
     * Update a channel schedule
     */
    public suspend fun batchUpdateSchedule(input: BatchUpdateScheduleRequest): BatchUpdateScheduleResponse

    /**
     * Cancel an input device transfer that you have requested.
     */
    public suspend fun cancelInputDeviceTransfer(input: CancelInputDeviceTransferRequest): CancelInputDeviceTransferResponse

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the request succeeds, you will own the device.
     */
    public suspend fun claimDevice(input: ClaimDeviceRequest = ClaimDeviceRequest {}): ClaimDeviceResponse

    /**
     * Creates a new channel
     */
    public suspend fun createChannel(input: CreateChannelRequest = CreateChannelRequest {}): CreateChannelResponse

    /**
     * Create an input
     */
    public suspend fun createInput(input: CreateInputRequest = CreateInputRequest {}): CreateInputResponse

    /**
     * Creates a Input Security Group
     */
    public suspend fun createInputSecurityGroup(input: CreateInputSecurityGroupRequest = CreateInputSecurityGroupRequest {}): CreateInputSecurityGroupResponse

    /**
     * Create a new multiplex.
     */
    public suspend fun createMultiplex(input: CreateMultiplexRequest): CreateMultiplexResponse

    /**
     * Create a new program in the multiplex.
     */
    public suspend fun createMultiplexProgram(input: CreateMultiplexProgramRequest): CreateMultiplexProgramResponse

    /**
     * Create a partner input
     */
    public suspend fun createPartnerInput(input: CreatePartnerInputRequest): CreatePartnerInputResponse

    /**
     * Create tags for a resource
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the input end point
     */
    public suspend fun deleteInput(input: DeleteInputRequest): DeleteInputResponse

    /**
     * Deletes an Input Security Group
     */
    public suspend fun deleteInputSecurityGroup(input: DeleteInputSecurityGroupRequest): DeleteInputSecurityGroupResponse

    /**
     * Delete a multiplex. The multiplex must be idle.
     */
    public suspend fun deleteMultiplex(input: DeleteMultiplexRequest): DeleteMultiplexResponse

    /**
     * Delete a program from a multiplex.
     */
    public suspend fun deleteMultiplexProgram(input: DeleteMultiplexProgramRequest): DeleteMultiplexProgramResponse

    /**
     * Delete an expired reservation.
     */
    public suspend fun deleteReservation(input: DeleteReservationRequest): DeleteReservationResponse

    /**
     * Delete all schedule actions on a channel.
     */
    public suspend fun deleteSchedule(input: DeleteScheduleRequest): DeleteScheduleResponse

    /**
     * Removes tags for a resource
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Gets details about a channel
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Produces details about an input
     */
    public suspend fun describeInput(input: DescribeInputRequest): DescribeInputResponse

    /**
     * Gets the details for the input device
     */
    public suspend fun describeInputDevice(input: DescribeInputDeviceRequest): DescribeInputDeviceResponse

    /**
     * Get the latest thumbnail data for the input device.
     */
    public suspend fun <T> describeInputDeviceThumbnail(input: DescribeInputDeviceThumbnailRequest, block: suspend (DescribeInputDeviceThumbnailResponse) -> T): T

    /**
     * Produces a summary of an Input Security Group
     */
    public suspend fun describeInputSecurityGroup(input: DescribeInputSecurityGroupRequest): DescribeInputSecurityGroupResponse

    /**
     * Gets details about a multiplex.
     */
    public suspend fun describeMultiplex(input: DescribeMultiplexRequest): DescribeMultiplexResponse

    /**
     * Get the details for a program in a multiplex.
     */
    public suspend fun describeMultiplexProgram(input: DescribeMultiplexProgramRequest): DescribeMultiplexProgramResponse

    /**
     * Get details for an offering.
     */
    public suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse

    /**
     * Get details for a reservation.
     */
    public suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse

    /**
     * Get a channel schedule
     */
    public suspend fun describeSchedule(input: DescribeScheduleRequest): DescribeScheduleResponse

    /**
     * Produces list of channels that have been created
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.
     */
    public suspend fun listInputDeviceTransfers(input: ListInputDeviceTransfersRequest): ListInputDeviceTransfersResponse

    /**
     * List input devices
     */
    public suspend fun listInputDevices(input: ListInputDevicesRequest = ListInputDevicesRequest {}): ListInputDevicesResponse

    /**
     * Produces a list of Input Security Groups for an account
     */
    public suspend fun listInputSecurityGroups(input: ListInputSecurityGroupsRequest = ListInputSecurityGroupsRequest {}): ListInputSecurityGroupsResponse

    /**
     * Produces list of inputs that have been created
     */
    public suspend fun listInputs(input: ListInputsRequest = ListInputsRequest {}): ListInputsResponse

    /**
     * List the programs that currently exist for a specific multiplex.
     */
    public suspend fun listMultiplexPrograms(input: ListMultiplexProgramsRequest): ListMultiplexProgramsResponse

    /**
     * Retrieve a list of the existing multiplexes.
     */
    public suspend fun listMultiplexes(input: ListMultiplexesRequest = ListMultiplexesRequest {}): ListMultiplexesResponse

    /**
     * List offerings available for purchase.
     */
    public suspend fun listOfferings(input: ListOfferingsRequest = ListOfferingsRequest {}): ListOfferingsResponse

    /**
     * List purchased reservations.
     */
    public suspend fun listReservations(input: ListReservationsRequest = ListReservationsRequest {}): ListReservationsResponse

    /**
     * Produces list of tags that have been created for a resource
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Purchase an offering and create a reservation.
     */
    public suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of sending the command. When the reboot is complete, the device’s connection status will change to connected.
     */
    public suspend fun rebootInputDevice(input: RebootInputDeviceRequest): RebootInputDeviceResponse

    /**
     * Reject the transfer of the specified input device to your AWS account.
     */
    public suspend fun rejectInputDeviceTransfer(input: RejectInputDeviceTransferRequest): RejectInputDeviceTransferResponse

    /**
     * Starts an existing channel
     */
    public suspend fun startChannel(input: StartChannelRequest): StartChannelResponse

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming when the software is fully installed. Devices automatically install updates while they are powered on and their MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop MediaLive channels that use the device. The device must remain powered on and connected to the internet for the duration of the maintenance.
     */
    public suspend fun startInputDeviceMaintenanceWindow(input: StartInputDeviceMaintenanceWindowRequest): StartInputDeviceMaintenanceWindowResponse

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.
     */
    public suspend fun startMultiplex(input: StartMultiplexRequest): StartMultiplexResponse

    /**
     * Stops a running channel
     */
    public suspend fun stopChannel(input: StopChannelRequest): StopChannelResponse

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     */
    public suspend fun stopMultiplex(input: StopMultiplexRequest): StopMultiplexResponse

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.
     */
    public suspend fun transferInputDevice(input: TransferInputDeviceRequest): TransferInputDeviceResponse

    /**
     * Updates a channel.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Changes the class of the channel.
     */
    public suspend fun updateChannelClass(input: UpdateChannelClassRequest): UpdateChannelClassResponse

    /**
     * Updates an input.
     */
    public suspend fun updateInput(input: UpdateInputRequest): UpdateInputResponse

    /**
     * Updates the parameters for the input device.
     */
    public suspend fun updateInputDevice(input: UpdateInputDeviceRequest): UpdateInputDeviceResponse

    /**
     * Update an Input Security Group's Whilelists.
     */
    public suspend fun updateInputSecurityGroup(input: UpdateInputSecurityGroupRequest): UpdateInputSecurityGroupResponse

    /**
     * Updates a multiplex.
     */
    public suspend fun updateMultiplex(input: UpdateMultiplexRequest): UpdateMultiplexResponse

    /**
     * Update a program in a multiplex.
     */
    public suspend fun updateMultiplexProgram(input: UpdateMultiplexProgramRequest): UpdateMultiplexProgramResponse

    /**
     * Update reservation.
     */
    public suspend fun updateReservation(input: UpdateReservationRequest): UpdateReservationResponse
}

/**
 * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
 */
public suspend inline fun MediaLiveClient.acceptInputDeviceTransfer(crossinline block: AcceptInputDeviceTransferRequest.Builder.() -> Unit): AcceptInputDeviceTransferResponse = acceptInputDeviceTransfer(AcceptInputDeviceTransferRequest.Builder().apply(block).build())

/**
 * Starts delete of resources.
 */
public suspend inline fun MediaLiveClient.batchDelete(crossinline block: BatchDeleteRequest.Builder.() -> Unit): BatchDeleteResponse = batchDelete(BatchDeleteRequest.Builder().apply(block).build())

/**
 * Starts existing resources
 */
public suspend inline fun MediaLiveClient.batchStart(crossinline block: BatchStartRequest.Builder.() -> Unit): BatchStartResponse = batchStart(BatchStartRequest.Builder().apply(block).build())

/**
 * Stops running resources
 */
public suspend inline fun MediaLiveClient.batchStop(crossinline block: BatchStopRequest.Builder.() -> Unit): BatchStopResponse = batchStop(BatchStopRequest.Builder().apply(block).build())

/**
 * Update a channel schedule
 */
public suspend inline fun MediaLiveClient.batchUpdateSchedule(crossinline block: BatchUpdateScheduleRequest.Builder.() -> Unit): BatchUpdateScheduleResponse = batchUpdateSchedule(BatchUpdateScheduleRequest.Builder().apply(block).build())

/**
 * Cancel an input device transfer that you have requested.
 */
public suspend inline fun MediaLiveClient.cancelInputDeviceTransfer(crossinline block: CancelInputDeviceTransferRequest.Builder.() -> Unit): CancelInputDeviceTransferResponse = cancelInputDeviceTransfer(CancelInputDeviceTransferRequest.Builder().apply(block).build())

/**
 * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the request succeeds, you will own the device.
 */
public suspend inline fun MediaLiveClient.claimDevice(crossinline block: ClaimDeviceRequest.Builder.() -> Unit): ClaimDeviceResponse = claimDevice(ClaimDeviceRequest.Builder().apply(block).build())

/**
 * Creates a new channel
 */
public suspend inline fun MediaLiveClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Create an input
 */
public suspend inline fun MediaLiveClient.createInput(crossinline block: CreateInputRequest.Builder.() -> Unit): CreateInputResponse = createInput(CreateInputRequest.Builder().apply(block).build())

/**
 * Creates a Input Security Group
 */
public suspend inline fun MediaLiveClient.createInputSecurityGroup(crossinline block: CreateInputSecurityGroupRequest.Builder.() -> Unit): CreateInputSecurityGroupResponse = createInputSecurityGroup(CreateInputSecurityGroupRequest.Builder().apply(block).build())

/**
 * Create a new multiplex.
 */
public suspend inline fun MediaLiveClient.createMultiplex(crossinline block: CreateMultiplexRequest.Builder.() -> Unit): CreateMultiplexResponse = createMultiplex(CreateMultiplexRequest.Builder().apply(block).build())

/**
 * Create a new program in the multiplex.
 */
public suspend inline fun MediaLiveClient.createMultiplexProgram(crossinline block: CreateMultiplexProgramRequest.Builder.() -> Unit): CreateMultiplexProgramResponse = createMultiplexProgram(CreateMultiplexProgramRequest.Builder().apply(block).build())

/**
 * Create a partner input
 */
public suspend inline fun MediaLiveClient.createPartnerInput(crossinline block: CreatePartnerInputRequest.Builder.() -> Unit): CreatePartnerInputResponse = createPartnerInput(CreatePartnerInputRequest.Builder().apply(block).build())

/**
 * Create tags for a resource
 */
public suspend inline fun MediaLiveClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Starts deletion of channel. The associated outputs are also deleted.
 */
public suspend inline fun MediaLiveClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes the input end point
 */
public suspend inline fun MediaLiveClient.deleteInput(crossinline block: DeleteInputRequest.Builder.() -> Unit): DeleteInputResponse = deleteInput(DeleteInputRequest.Builder().apply(block).build())

/**
 * Deletes an Input Security Group
 */
public suspend inline fun MediaLiveClient.deleteInputSecurityGroup(crossinline block: DeleteInputSecurityGroupRequest.Builder.() -> Unit): DeleteInputSecurityGroupResponse = deleteInputSecurityGroup(DeleteInputSecurityGroupRequest.Builder().apply(block).build())

/**
 * Delete a multiplex. The multiplex must be idle.
 */
public suspend inline fun MediaLiveClient.deleteMultiplex(crossinline block: DeleteMultiplexRequest.Builder.() -> Unit): DeleteMultiplexResponse = deleteMultiplex(DeleteMultiplexRequest.Builder().apply(block).build())

/**
 * Delete a program from a multiplex.
 */
public suspend inline fun MediaLiveClient.deleteMultiplexProgram(crossinline block: DeleteMultiplexProgramRequest.Builder.() -> Unit): DeleteMultiplexProgramResponse = deleteMultiplexProgram(DeleteMultiplexProgramRequest.Builder().apply(block).build())

/**
 * Delete an expired reservation.
 */
public suspend inline fun MediaLiveClient.deleteReservation(crossinline block: DeleteReservationRequest.Builder.() -> Unit): DeleteReservationResponse = deleteReservation(DeleteReservationRequest.Builder().apply(block).build())

/**
 * Delete all schedule actions on a channel.
 */
public suspend inline fun MediaLiveClient.deleteSchedule(crossinline block: DeleteScheduleRequest.Builder.() -> Unit): DeleteScheduleResponse = deleteSchedule(DeleteScheduleRequest.Builder().apply(block).build())

/**
 * Removes tags for a resource
 */
public suspend inline fun MediaLiveClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Gets details about a channel
 */
public suspend inline fun MediaLiveClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Produces details about an input
 */
public suspend inline fun MediaLiveClient.describeInput(crossinline block: DescribeInputRequest.Builder.() -> Unit): DescribeInputResponse = describeInput(DescribeInputRequest.Builder().apply(block).build())

/**
 * Gets the details for the input device
 */
public suspend inline fun MediaLiveClient.describeInputDevice(crossinline block: DescribeInputDeviceRequest.Builder.() -> Unit): DescribeInputDeviceResponse = describeInputDevice(DescribeInputDeviceRequest.Builder().apply(block).build())

/**
 * Produces a summary of an Input Security Group
 */
public suspend inline fun MediaLiveClient.describeInputSecurityGroup(crossinline block: DescribeInputSecurityGroupRequest.Builder.() -> Unit): DescribeInputSecurityGroupResponse = describeInputSecurityGroup(DescribeInputSecurityGroupRequest.Builder().apply(block).build())

/**
 * Gets details about a multiplex.
 */
public suspend inline fun MediaLiveClient.describeMultiplex(crossinline block: DescribeMultiplexRequest.Builder.() -> Unit): DescribeMultiplexResponse = describeMultiplex(DescribeMultiplexRequest.Builder().apply(block).build())

/**
 * Get the details for a program in a multiplex.
 */
public suspend inline fun MediaLiveClient.describeMultiplexProgram(crossinline block: DescribeMultiplexProgramRequest.Builder.() -> Unit): DescribeMultiplexProgramResponse = describeMultiplexProgram(DescribeMultiplexProgramRequest.Builder().apply(block).build())

/**
 * Get details for an offering.
 */
public suspend inline fun MediaLiveClient.describeOffering(crossinline block: DescribeOfferingRequest.Builder.() -> Unit): DescribeOfferingResponse = describeOffering(DescribeOfferingRequest.Builder().apply(block).build())

/**
 * Get details for a reservation.
 */
public suspend inline fun MediaLiveClient.describeReservation(crossinline block: DescribeReservationRequest.Builder.() -> Unit): DescribeReservationResponse = describeReservation(DescribeReservationRequest.Builder().apply(block).build())

/**
 * Get a channel schedule
 */
public suspend inline fun MediaLiveClient.describeSchedule(crossinline block: DescribeScheduleRequest.Builder.() -> Unit): DescribeScheduleResponse = describeSchedule(DescribeScheduleRequest.Builder().apply(block).build())

/**
 * Produces list of channels that have been created
 */
public suspend inline fun MediaLiveClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.
 */
public suspend inline fun MediaLiveClient.listInputDeviceTransfers(crossinline block: ListInputDeviceTransfersRequest.Builder.() -> Unit): ListInputDeviceTransfersResponse = listInputDeviceTransfers(ListInputDeviceTransfersRequest.Builder().apply(block).build())

/**
 * List input devices
 */
public suspend inline fun MediaLiveClient.listInputDevices(crossinline block: ListInputDevicesRequest.Builder.() -> Unit): ListInputDevicesResponse = listInputDevices(ListInputDevicesRequest.Builder().apply(block).build())

/**
 * Produces a list of Input Security Groups for an account
 */
public suspend inline fun MediaLiveClient.listInputSecurityGroups(crossinline block: ListInputSecurityGroupsRequest.Builder.() -> Unit): ListInputSecurityGroupsResponse = listInputSecurityGroups(ListInputSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Produces list of inputs that have been created
 */
public suspend inline fun MediaLiveClient.listInputs(crossinline block: ListInputsRequest.Builder.() -> Unit): ListInputsResponse = listInputs(ListInputsRequest.Builder().apply(block).build())

/**
 * List the programs that currently exist for a specific multiplex.
 */
public suspend inline fun MediaLiveClient.listMultiplexPrograms(crossinline block: ListMultiplexProgramsRequest.Builder.() -> Unit): ListMultiplexProgramsResponse = listMultiplexPrograms(ListMultiplexProgramsRequest.Builder().apply(block).build())

/**
 * Retrieve a list of the existing multiplexes.
 */
public suspend inline fun MediaLiveClient.listMultiplexes(crossinline block: ListMultiplexesRequest.Builder.() -> Unit): ListMultiplexesResponse = listMultiplexes(ListMultiplexesRequest.Builder().apply(block).build())

/**
 * List offerings available for purchase.
 */
public suspend inline fun MediaLiveClient.listOfferings(crossinline block: ListOfferingsRequest.Builder.() -> Unit): ListOfferingsResponse = listOfferings(ListOfferingsRequest.Builder().apply(block).build())

/**
 * List purchased reservations.
 */
public suspend inline fun MediaLiveClient.listReservations(crossinline block: ListReservationsRequest.Builder.() -> Unit): ListReservationsResponse = listReservations(ListReservationsRequest.Builder().apply(block).build())

/**
 * Produces list of tags that have been created for a resource
 */
public suspend inline fun MediaLiveClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Purchase an offering and create a reservation.
 */
public suspend inline fun MediaLiveClient.purchaseOffering(crossinline block: PurchaseOfferingRequest.Builder.() -> Unit): PurchaseOfferingResponse = purchaseOffering(PurchaseOfferingRequest.Builder().apply(block).build())

/**
 * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of sending the command. When the reboot is complete, the device’s connection status will change to connected.
 */
public suspend inline fun MediaLiveClient.rebootInputDevice(crossinline block: RebootInputDeviceRequest.Builder.() -> Unit): RebootInputDeviceResponse = rebootInputDevice(RebootInputDeviceRequest.Builder().apply(block).build())

/**
 * Reject the transfer of the specified input device to your AWS account.
 */
public suspend inline fun MediaLiveClient.rejectInputDeviceTransfer(crossinline block: RejectInputDeviceTransferRequest.Builder.() -> Unit): RejectInputDeviceTransferResponse = rejectInputDeviceTransfer(RejectInputDeviceTransferRequest.Builder().apply(block).build())

/**
 * Starts an existing channel
 */
public suspend inline fun MediaLiveClient.startChannel(crossinline block: StartChannelRequest.Builder.() -> Unit): StartChannelResponse = startChannel(StartChannelRequest.Builder().apply(block).build())

/**
 * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming when the software is fully installed. Devices automatically install updates while they are powered on and their MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop MediaLive channels that use the device. The device must remain powered on and connected to the internet for the duration of the maintenance.
 */
public suspend inline fun MediaLiveClient.startInputDeviceMaintenanceWindow(crossinline block: StartInputDeviceMaintenanceWindowRequest.Builder.() -> Unit): StartInputDeviceMaintenanceWindowResponse = startInputDeviceMaintenanceWindow(StartInputDeviceMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.
 */
public suspend inline fun MediaLiveClient.startMultiplex(crossinline block: StartMultiplexRequest.Builder.() -> Unit): StartMultiplexResponse = startMultiplex(StartMultiplexRequest.Builder().apply(block).build())

/**
 * Stops a running channel
 */
public suspend inline fun MediaLiveClient.stopChannel(crossinline block: StopChannelRequest.Builder.() -> Unit): StopChannelResponse = stopChannel(StopChannelRequest.Builder().apply(block).build())

/**
 * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
 */
public suspend inline fun MediaLiveClient.stopMultiplex(crossinline block: StopMultiplexRequest.Builder.() -> Unit): StopMultiplexResponse = stopMultiplex(StopMultiplexRequest.Builder().apply(block).build())

/**
 * Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.
 */
public suspend inline fun MediaLiveClient.transferInputDevice(crossinline block: TransferInputDeviceRequest.Builder.() -> Unit): TransferInputDeviceResponse = transferInputDevice(TransferInputDeviceRequest.Builder().apply(block).build())

/**
 * Updates a channel.
 */
public suspend inline fun MediaLiveClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Changes the class of the channel.
 */
public suspend inline fun MediaLiveClient.updateChannelClass(crossinline block: UpdateChannelClassRequest.Builder.() -> Unit): UpdateChannelClassResponse = updateChannelClass(UpdateChannelClassRequest.Builder().apply(block).build())

/**
 * Updates an input.
 */
public suspend inline fun MediaLiveClient.updateInput(crossinline block: UpdateInputRequest.Builder.() -> Unit): UpdateInputResponse = updateInput(UpdateInputRequest.Builder().apply(block).build())

/**
 * Updates the parameters for the input device.
 */
public suspend inline fun MediaLiveClient.updateInputDevice(crossinline block: UpdateInputDeviceRequest.Builder.() -> Unit): UpdateInputDeviceResponse = updateInputDevice(UpdateInputDeviceRequest.Builder().apply(block).build())

/**
 * Update an Input Security Group's Whilelists.
 */
public suspend inline fun MediaLiveClient.updateInputSecurityGroup(crossinline block: UpdateInputSecurityGroupRequest.Builder.() -> Unit): UpdateInputSecurityGroupResponse = updateInputSecurityGroup(UpdateInputSecurityGroupRequest.Builder().apply(block).build())

/**
 * Updates a multiplex.
 */
public suspend inline fun MediaLiveClient.updateMultiplex(crossinline block: UpdateMultiplexRequest.Builder.() -> Unit): UpdateMultiplexResponse = updateMultiplex(UpdateMultiplexRequest.Builder().apply(block).build())

/**
 * Update a program in a multiplex.
 */
public suspend inline fun MediaLiveClient.updateMultiplexProgram(crossinline block: UpdateMultiplexProgramRequest.Builder.() -> Unit): UpdateMultiplexProgramResponse = updateMultiplexProgram(UpdateMultiplexProgramRequest.Builder().apply(block).build())

/**
 * Update reservation.
 */
public suspend inline fun MediaLiveClient.updateReservation(crossinline block: UpdateReservationRequest.Builder.() -> Unit): UpdateReservationResponse = updateReservation(UpdateReservationRequest.Builder().apply(block).build())
