// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Audio Normalization Settings
 */
public class AudioNormalizationSettings private constructor(builder: Builder) {
    /**
     * Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 conforms to the EBU R-128 specification.
     */
    public val algorithm: aws.sdk.kotlin.services.medialive.model.AudioNormalizationAlgorithm? = builder.algorithm
    /**
     * When set to correctAudio the output audio is corrected using the chosen algorithm. If set to measureOnly, the audio will be measured but not adjusted.
     */
    public val algorithmControl: aws.sdk.kotlin.services.medialive.model.AudioNormalizationAlgorithmControl? = builder.algorithmControl
    /**
     * Target LKFS(loudness) to adjust volume to. If no value is entered, a default value will be used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
     */
    public val targetLkfs: kotlin.Double? = builder.targetLkfs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.AudioNormalizationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioNormalizationSettings(")
        append("algorithm=$algorithm,")
        append("algorithmControl=$algorithmControl,")
        append("targetLkfs=$targetLkfs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (algorithmControl?.hashCode() ?: 0)
        result = 31 * result + (targetLkfs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioNormalizationSettings

        if (algorithm != other.algorithm) return false
        if (algorithmControl != other.algorithmControl) return false
        if (targetLkfs != other.targetLkfs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.AudioNormalizationSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 conforms to the EBU R-128 specification.
         */
        public var algorithm: aws.sdk.kotlin.services.medialive.model.AudioNormalizationAlgorithm? = null
        /**
         * When set to correctAudio the output audio is corrected using the chosen algorithm. If set to measureOnly, the audio will be measured but not adjusted.
         */
        public var algorithmControl: aws.sdk.kotlin.services.medialive.model.AudioNormalizationAlgorithmControl? = null
        /**
         * Target LKFS(loudness) to adjust volume to. If no value is entered, a default value will be used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
         */
        public var targetLkfs: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.AudioNormalizationSettings) : this() {
            this.algorithm = x.algorithm
            this.algorithmControl = x.algorithmControl
            this.targetLkfs = x.targetLkfs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.AudioNormalizationSettings = AudioNormalizationSettings(this)
    }
}
