// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * The settings for Automatic Input Failover.
 */
public class AutomaticInputFailoverSettings private constructor(builder: Builder) {
    /**
     * This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
     */
    public val errorClearTimeMsec: kotlin.Int? = builder.errorClearTimeMsec
    /**
     * A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
     */
    public val failoverConditions: List<FailoverCondition>? = builder.failoverConditions
    /**
     * Input preference when deciding which input to make active when a previously failed input has recovered.
     */
    public val inputPreference: aws.sdk.kotlin.services.medialive.model.InputPreference? = builder.inputPreference
    /**
     * The input ID of the secondary input in the automatic input failover pair.
     */
    public val secondaryInputId: kotlin.String? = builder.secondaryInputId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.AutomaticInputFailoverSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomaticInputFailoverSettings(")
        append("errorClearTimeMsec=$errorClearTimeMsec,")
        append("failoverConditions=$failoverConditions,")
        append("inputPreference=$inputPreference,")
        append("secondaryInputId=$secondaryInputId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorClearTimeMsec ?: 0
        result = 31 * result + (failoverConditions?.hashCode() ?: 0)
        result = 31 * result + (inputPreference?.hashCode() ?: 0)
        result = 31 * result + (secondaryInputId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomaticInputFailoverSettings

        if (errorClearTimeMsec != other.errorClearTimeMsec) return false
        if (failoverConditions != other.failoverConditions) return false
        if (inputPreference != other.inputPreference) return false
        if (secondaryInputId != other.secondaryInputId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.AutomaticInputFailoverSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
         */
        public var errorClearTimeMsec: kotlin.Int? = null
        /**
         * A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
         */
        public var failoverConditions: List<FailoverCondition>? = null
        /**
         * Input preference when deciding which input to make active when a previously failed input has recovered.
         */
        public var inputPreference: aws.sdk.kotlin.services.medialive.model.InputPreference? = null
        /**
         * The input ID of the secondary input in the automatic input failover pair.
         */
        public var secondaryInputId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.AutomaticInputFailoverSettings) : this() {
            this.errorClearTimeMsec = x.errorClearTimeMsec
            this.failoverConditions = x.failoverConditions
            this.inputPreference = x.inputPreference
            this.secondaryInputId = x.secondaryInputId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.AutomaticInputFailoverSettings = AutomaticInputFailoverSettings(this)
    }
}
