// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Blackout Slate
 */
public class BlackoutSlate private constructor(builder: Builder) {
    /**
     * Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
     */
    public val blackoutSlateImage: aws.sdk.kotlin.services.medialive.model.InputLocation? = builder.blackoutSlateImage
    /**
     * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
     */
    public val networkEndBlackout: aws.sdk.kotlin.services.medialive.model.BlackoutSlateNetworkEndBlackout? = builder.networkEndBlackout
    /**
     * Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output raster.
     */
    public val networkEndBlackoutImage: aws.sdk.kotlin.services.medialive.model.InputLocation? = builder.networkEndBlackoutImage
    /**
     * Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
     */
    public val networkId: kotlin.String? = builder.networkId
    /**
     * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
     */
    public val state: aws.sdk.kotlin.services.medialive.model.BlackoutSlateState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.BlackoutSlate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlackoutSlate(")
        append("blackoutSlateImage=$blackoutSlateImage,")
        append("networkEndBlackout=$networkEndBlackout,")
        append("networkEndBlackoutImage=$networkEndBlackoutImage,")
        append("networkId=$networkId,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blackoutSlateImage?.hashCode() ?: 0
        result = 31 * result + (networkEndBlackout?.hashCode() ?: 0)
        result = 31 * result + (networkEndBlackoutImage?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlackoutSlate

        if (blackoutSlateImage != other.blackoutSlateImage) return false
        if (networkEndBlackout != other.networkEndBlackout) return false
        if (networkEndBlackoutImage != other.networkEndBlackoutImage) return false
        if (networkId != other.networkId) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.BlackoutSlate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.
         */
        public var blackoutSlateImage: aws.sdk.kotlin.services.medialive.model.InputLocation? = null
        /**
         * Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in "Network ID".
         */
        public var networkEndBlackout: aws.sdk.kotlin.services.medialive.model.BlackoutSlateNetworkEndBlackout? = null
        /**
         * Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output raster.
         */
        public var networkEndBlackoutImage: aws.sdk.kotlin.services.medialive.model.InputLocation? = null
        /**
         * Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
         */
        public var networkId: kotlin.String? = null
        /**
         * When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.
         */
        public var state: aws.sdk.kotlin.services.medialive.model.BlackoutSlateState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.BlackoutSlate) : this() {
            this.blackoutSlateImage = x.blackoutSlateImage
            this.networkEndBlackout = x.networkEndBlackout
            this.networkEndBlackoutImage = x.networkEndBlackoutImage
            this.networkId = x.networkId
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.BlackoutSlate = BlackoutSlate(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputLocation] inside the given [block]
         */
        public fun blackoutSlateImage(block: aws.sdk.kotlin.services.medialive.model.InputLocation.Builder.() -> kotlin.Unit) {
            this.blackoutSlateImage = aws.sdk.kotlin.services.medialive.model.InputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputLocation] inside the given [block]
         */
        public fun networkEndBlackoutImage(block: aws.sdk.kotlin.services.medialive.model.InputLocation.Builder.() -> kotlin.Unit) {
            this.networkEndBlackoutImage = aws.sdk.kotlin.services.medialive.model.InputLocation.invoke(block)
        }
    }
}
