// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * A request to create a channel
 */
public class CreateChannelRequest private constructor(builder: Builder) {
    /**
     * Specification of CDI inputs for this channel
     */
    public val cdiInputSpecification: aws.sdk.kotlin.services.medialive.model.CdiInputSpecification? = builder.cdiInputSpecification
    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
     */
    public val channelClass: aws.sdk.kotlin.services.medialive.model.ChannelClass? = builder.channelClass
    /**
     * Placeholder documentation for __listOfOutputDestination
     */
    public val destinations: List<OutputDestination>? = builder.destinations
    /**
     * Encoder Settings
     */
    public val encoderSettings: aws.sdk.kotlin.services.medialive.model.EncoderSettings? = builder.encoderSettings
    /**
     * List of input attachments for channel.
     */
    public val inputAttachments: List<InputAttachment>? = builder.inputAttachments
    /**
     * Specification of network and file inputs for this channel
     */
    public val inputSpecification: aws.sdk.kotlin.services.medialive.model.InputSpecification? = builder.inputSpecification
    /**
     * The log level to write to CloudWatch Logs.
     */
    public val logLevel: aws.sdk.kotlin.services.medialive.model.LogLevel? = builder.logLevel
    /**
     * Maintenance settings for this channel.
     */
    public val maintenance: aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings? = builder.maintenance
    /**
     * Name of channel.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * Deprecated field that's only usable by whitelisted customers.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val reserved: kotlin.String? = builder.reserved
    /**
     * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A collection of key-value pairs.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Settings for the VPC outputs
     */
    public val vpc: aws.sdk.kotlin.services.medialive.model.VpcOutputSettings? = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.CreateChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("cdiInputSpecification=$cdiInputSpecification,")
        append("channelClass=$channelClass,")
        append("destinations=$destinations,")
        append("encoderSettings=$encoderSettings,")
        append("inputAttachments=$inputAttachments,")
        append("inputSpecification=$inputSpecification,")
        append("logLevel=$logLevel,")
        append("maintenance=$maintenance,")
        append("name=$name,")
        append("requestId=$requestId,")
        append("reserved=$reserved,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdiInputSpecification?.hashCode() ?: 0
        result = 31 * result + (channelClass?.hashCode() ?: 0)
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (encoderSettings?.hashCode() ?: 0)
        result = 31 * result + (inputAttachments?.hashCode() ?: 0)
        result = 31 * result + (inputSpecification?.hashCode() ?: 0)
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        result = 31 * result + (maintenance?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (reserved?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelRequest

        if (cdiInputSpecification != other.cdiInputSpecification) return false
        if (channelClass != other.channelClass) return false
        if (destinations != other.destinations) return false
        if (encoderSettings != other.encoderSettings) return false
        if (inputAttachments != other.inputAttachments) return false
        if (inputSpecification != other.inputSpecification) return false
        if (logLevel != other.logLevel) return false
        if (maintenance != other.maintenance) return false
        if (name != other.name) return false
        if (requestId != other.requestId) return false
        if (reserved != other.reserved) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.CreateChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specification of CDI inputs for this channel
         */
        public var cdiInputSpecification: aws.sdk.kotlin.services.medialive.model.CdiInputSpecification? = null
        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
         */
        public var channelClass: aws.sdk.kotlin.services.medialive.model.ChannelClass? = null
        /**
         * Placeholder documentation for __listOfOutputDestination
         */
        public var destinations: List<OutputDestination>? = null
        /**
         * Encoder Settings
         */
        public var encoderSettings: aws.sdk.kotlin.services.medialive.model.EncoderSettings? = null
        /**
         * List of input attachments for channel.
         */
        public var inputAttachments: List<InputAttachment>? = null
        /**
         * Specification of network and file inputs for this channel
         */
        public var inputSpecification: aws.sdk.kotlin.services.medialive.model.InputSpecification? = null
        /**
         * The log level to write to CloudWatch Logs.
         */
        public var logLevel: aws.sdk.kotlin.services.medialive.model.LogLevel? = null
        /**
         * Maintenance settings for this channel.
         */
        public var maintenance: aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings? = null
        /**
         * Name of channel.
         */
        public var name: kotlin.String? = null
        /**
         * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
         */
        public var requestId: kotlin.String? = null
        /**
         * Deprecated field that's only usable by whitelisted customers.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var reserved: kotlin.String? = null
        /**
         * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A collection of key-value pairs.
         */
        public var tags: Map<String, String>? = null
        /**
         * Settings for the VPC outputs
         */
        public var vpc: aws.sdk.kotlin.services.medialive.model.VpcOutputSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.CreateChannelRequest) : this() {
            this.cdiInputSpecification = x.cdiInputSpecification
            this.channelClass = x.channelClass
            this.destinations = x.destinations
            this.encoderSettings = x.encoderSettings
            this.inputAttachments = x.inputAttachments
            this.inputSpecification = x.inputSpecification
            this.logLevel = x.logLevel
            this.maintenance = x.maintenance
            this.name = x.name
            this.requestId = x.requestId
            this.reserved = x.reserved
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.CreateChannelRequest = CreateChannelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.CdiInputSpecification] inside the given [block]
         */
        public fun cdiInputSpecification(block: aws.sdk.kotlin.services.medialive.model.CdiInputSpecification.Builder.() -> kotlin.Unit) {
            this.cdiInputSpecification = aws.sdk.kotlin.services.medialive.model.CdiInputSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.EncoderSettings] inside the given [block]
         */
        public fun encoderSettings(block: aws.sdk.kotlin.services.medialive.model.EncoderSettings.Builder.() -> kotlin.Unit) {
            this.encoderSettings = aws.sdk.kotlin.services.medialive.model.EncoderSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputSpecification] inside the given [block]
         */
        public fun inputSpecification(block: aws.sdk.kotlin.services.medialive.model.InputSpecification.Builder.() -> kotlin.Unit) {
            this.inputSpecification = aws.sdk.kotlin.services.medialive.model.InputSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings] inside the given [block]
         */
        public fun maintenance(block: aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings.Builder.() -> kotlin.Unit) {
            this.maintenance = aws.sdk.kotlin.services.medialive.model.MaintenanceCreateSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.VpcOutputSettings] inside the given [block]
         */
        public fun vpc(block: aws.sdk.kotlin.services.medialive.model.VpcOutputSettings.Builder.() -> kotlin.Unit) {
            this.vpc = aws.sdk.kotlin.services.medialive.model.VpcOutputSettings.invoke(block)
        }
    }
}
