// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * The name of the input
 */
public class CreateInputRequest private constructor(builder: Builder) {
    /**
     * Destination settings for PUSH type inputs.
     */
    public val destinations: List<InputDestinationRequest>? = builder.destinations
    /**
     * Settings for the devices.
     */
    public val inputDevices: List<InputDeviceSettings>? = builder.inputDevices
    /**
     * A list of security groups referenced by IDs to attach to the input.
     */
    public val inputSecurityGroups: List<String>? = builder.inputSecurityGroups
    /**
     * A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
     */
    public val mediaConnectFlows: List<MediaConnectFlowRequest>? = builder.mediaConnectFlows
    /**
     * Name of the input.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Unique identifier of the request to ensure the request is handled exactly once in case of retries.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
     */
    public val sources: List<InputSourceRequest>? = builder.sources
    /**
     * A collection of key-value pairs.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The different types of inputs that AWS Elemental MediaLive supports.
     */
    public val type: aws.sdk.kotlin.services.medialive.model.InputType? = builder.type
    /**
     * Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
     */
    public val vpc: aws.sdk.kotlin.services.medialive.model.InputVpcRequest? = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.CreateInputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInputRequest(")
        append("destinations=$destinations,")
        append("inputDevices=$inputDevices,")
        append("inputSecurityGroups=$inputSecurityGroups,")
        append("mediaConnectFlows=$mediaConnectFlows,")
        append("name=$name,")
        append("requestId=$requestId,")
        append("roleArn=$roleArn,")
        append("sources=$sources,")
        append("tags=$tags,")
        append("type=$type,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinations?.hashCode() ?: 0
        result = 31 * result + (inputDevices?.hashCode() ?: 0)
        result = 31 * result + (inputSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (mediaConnectFlows?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInputRequest

        if (destinations != other.destinations) return false
        if (inputDevices != other.inputDevices) return false
        if (inputSecurityGroups != other.inputSecurityGroups) return false
        if (mediaConnectFlows != other.mediaConnectFlows) return false
        if (name != other.name) return false
        if (requestId != other.requestId) return false
        if (roleArn != other.roleArn) return false
        if (sources != other.sources) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.CreateInputRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Destination settings for PUSH type inputs.
         */
        public var destinations: List<InputDestinationRequest>? = null
        /**
         * Settings for the devices.
         */
        public var inputDevices: List<InputDeviceSettings>? = null
        /**
         * A list of security groups referenced by IDs to attach to the input.
         */
        public var inputSecurityGroups: List<String>? = null
        /**
         * A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         */
        public var mediaConnectFlows: List<MediaConnectFlowRequest>? = null
        /**
         * Name of the input.
         */
        public var name: kotlin.String? = null
        /**
         * Unique identifier of the request to ensure the request is handled exactly once in case of retries.
         */
        public var requestId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         */
        public var sources: List<InputSourceRequest>? = null
        /**
         * A collection of key-value pairs.
         */
        public var tags: Map<String, String>? = null
        /**
         * The different types of inputs that AWS Elemental MediaLive supports.
         */
        public var type: aws.sdk.kotlin.services.medialive.model.InputType? = null
        /**
         * Settings for a private VPC Input. When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses. This property requires setting the roleArn property on Input creation. Not compatible with the inputSecurityGroups property.
         */
        public var vpc: aws.sdk.kotlin.services.medialive.model.InputVpcRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.CreateInputRequest) : this() {
            this.destinations = x.destinations
            this.inputDevices = x.inputDevices
            this.inputSecurityGroups = x.inputSecurityGroups
            this.mediaConnectFlows = x.mediaConnectFlows
            this.name = x.name
            this.requestId = x.requestId
            this.roleArn = x.roleArn
            this.sources = x.sources
            this.tags = x.tags
            this.type = x.type
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.CreateInputRequest = CreateInputRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputVpcRequest] inside the given [block]
         */
        public fun vpc(block: aws.sdk.kotlin.services.medialive.model.InputVpcRequest.Builder.() -> kotlin.Unit) {
            this.vpc = aws.sdk.kotlin.services.medialive.model.InputVpcRequest.invoke(block)
        }
    }
}
