// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Placeholder documentation for DescribeInputResponse
 */
public class DescribeInputResponse private constructor(builder: Builder) {
    /**
     * The Unique ARN of the input (generated, immutable).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
     */
    public val attachedChannels: List<String>? = builder.attachedChannels
    /**
     * A list of the destinations of the input (PUSH-type).
     */
    public val destinations: List<InputDestination>? = builder.destinations
    /**
     * The generated ID of the input (unique for user account, immutable).
     */
    public val id: kotlin.String? = builder.id
    /**
     * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
     */
    public val inputClass: aws.sdk.kotlin.services.medialive.model.InputClass? = builder.inputClass
    /**
     * Settings for the input devices.
     */
    public val inputDevices: List<InputDeviceSettings>? = builder.inputDevices
    /**
     * A list of IDs for all Inputs which are partners of this one.
     */
    public val inputPartnerIds: List<String>? = builder.inputPartnerIds
    /**
     * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
     */
    public val inputSourceType: aws.sdk.kotlin.services.medialive.model.InputSourceType? = builder.inputSourceType
    /**
     * A list of MediaConnect Flows for this input.
     */
    public val mediaConnectFlows: List<MediaConnectFlow>? = builder.mediaConnectFlows
    /**
     * The user-assigned name (This is a mutable value).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of IDs for all the Input Security Groups attached to the input.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * A list of the sources of the input (PULL-type).
     */
    public val sources: List<InputSource>? = builder.sources
    /**
     * Placeholder documentation for InputState
     */
    public val state: aws.sdk.kotlin.services.medialive.model.InputState? = builder.state
    /**
     * A collection of key-value pairs.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The different types of inputs that AWS Elemental MediaLive supports.
     */
    public val type: aws.sdk.kotlin.services.medialive.model.InputType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.DescribeInputResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInputResponse(")
        append("arn=$arn,")
        append("attachedChannels=$attachedChannels,")
        append("destinations=$destinations,")
        append("id=$id,")
        append("inputClass=$inputClass,")
        append("inputDevices=$inputDevices,")
        append("inputPartnerIds=$inputPartnerIds,")
        append("inputSourceType=$inputSourceType,")
        append("mediaConnectFlows=$mediaConnectFlows,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("securityGroups=$securityGroups,")
        append("sources=$sources,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachedChannels?.hashCode() ?: 0)
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inputClass?.hashCode() ?: 0)
        result = 31 * result + (inputDevices?.hashCode() ?: 0)
        result = 31 * result + (inputPartnerIds?.hashCode() ?: 0)
        result = 31 * result + (inputSourceType?.hashCode() ?: 0)
        result = 31 * result + (mediaConnectFlows?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInputResponse

        if (arn != other.arn) return false
        if (attachedChannels != other.attachedChannels) return false
        if (destinations != other.destinations) return false
        if (id != other.id) return false
        if (inputClass != other.inputClass) return false
        if (inputDevices != other.inputDevices) return false
        if (inputPartnerIds != other.inputPartnerIds) return false
        if (inputSourceType != other.inputSourceType) return false
        if (mediaConnectFlows != other.mediaConnectFlows) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (securityGroups != other.securityGroups) return false
        if (sources != other.sources) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.DescribeInputResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unique ARN of the input (generated, immutable).
         */
        public var arn: kotlin.String? = null
        /**
         * A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
         */
        public var attachedChannels: List<String>? = null
        /**
         * A list of the destinations of the input (PUSH-type).
         */
        public var destinations: List<InputDestination>? = null
        /**
         * The generated ID of the input (unique for user account, immutable).
         */
        public var id: kotlin.String? = null
        /**
         * STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails. SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
         */
        public var inputClass: aws.sdk.kotlin.services.medialive.model.InputClass? = null
        /**
         * Settings for the input devices.
         */
        public var inputDevices: List<InputDeviceSettings>? = null
        /**
         * A list of IDs for all Inputs which are partners of this one.
         */
        public var inputPartnerIds: List<String>? = null
        /**
         * Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
         */
        public var inputSourceType: aws.sdk.kotlin.services.medialive.model.InputSourceType? = null
        /**
         * A list of MediaConnect Flows for this input.
         */
        public var mediaConnectFlows: List<MediaConnectFlow>? = null
        /**
         * The user-assigned name (This is a mutable value).
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of IDs for all the Input Security Groups attached to the input.
         */
        public var securityGroups: List<String>? = null
        /**
         * A list of the sources of the input (PULL-type).
         */
        public var sources: List<InputSource>? = null
        /**
         * Placeholder documentation for InputState
         */
        public var state: aws.sdk.kotlin.services.medialive.model.InputState? = null
        /**
         * A collection of key-value pairs.
         */
        public var tags: Map<String, String>? = null
        /**
         * The different types of inputs that AWS Elemental MediaLive supports.
         */
        public var type: aws.sdk.kotlin.services.medialive.model.InputType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.DescribeInputResponse) : this() {
            this.arn = x.arn
            this.attachedChannels = x.attachedChannels
            this.destinations = x.destinations
            this.id = x.id
            this.inputClass = x.inputClass
            this.inputDevices = x.inputDevices
            this.inputPartnerIds = x.inputPartnerIds
            this.inputSourceType = x.inputSourceType
            this.mediaConnectFlows = x.mediaConnectFlows
            this.name = x.name
            this.roleArn = x.roleArn
            this.securityGroups = x.securityGroups
            this.sources = x.sources
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.DescribeInputResponse = DescribeInputResponse(this)
    }
}
