// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * H264 Settings
 */
public class H264Settings private constructor(builder: Builder) {
    /**
     * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
     */
    public val adaptiveQuantization: aws.sdk.kotlin.services.medialive.model.H264AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
     */
    public val afdSignaling: aws.sdk.kotlin.services.medialive.model.AfdSignaling? = builder.afdSignaling
    /**
     * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
     */
    public val bitrate: kotlin.Int? = builder.bitrate
    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public val bufFillPct: kotlin.Int? = builder.bufFillPct
    /**
     * Size of buffer (HRD buffer model) in bits.
     */
    public val bufSize: kotlin.Int? = builder.bufSize
    /**
     * Includes colorspace metadata in the output.
     */
    public val colorMetadata: aws.sdk.kotlin.services.medialive.model.H264ColorMetadata? = builder.colorMetadata
    /**
     * Color Space settings
     */
    public val colorSpaceSettings: aws.sdk.kotlin.services.medialive.model.H264ColorSpaceSettings? = builder.colorSpaceSettings
    /**
     * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
     */
    public val entropyEncoding: aws.sdk.kotlin.services.medialive.model.H264EntropyEncoding? = builder.entropyEncoding
    /**
     * Optional filters that you can apply to an encode.
     */
    public val filterSettings: aws.sdk.kotlin.services.medialive.model.H264FilterSettings? = builder.filterSettings
    /**
     * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
     */
    public val fixedAfd: aws.sdk.kotlin.services.medialive.model.FixedAfd? = builder.fixedAfd
    /**
     * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
     */
    public val flickerAq: aws.sdk.kotlin.services.medialive.model.H264FlickerAq? = builder.flickerAq
    /**
     * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
     */
    public val forceFieldPictures: aws.sdk.kotlin.services.medialive.model.H264ForceFieldPictures? = builder.forceFieldPictures
    /**
     * This field indicates how the output video frame rate is specified. If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.
     */
    public val framerateControl: aws.sdk.kotlin.services.medialive.model.H264FramerateControl? = builder.framerateControl
    /**
     * Framerate denominator.
     */
    public val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     */
    public val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * Documentation update needed
     */
    public val gopBReference: aws.sdk.kotlin.services.medialive.model.H264GopBReference? = builder.gopBReference
    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
     */
    public val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Number of B-frames between reference frames.
     */
    public val gopNumBFrames: kotlin.Int? = builder.gopNumBFrames
    /**
     * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
     */
    public val gopSize: kotlin.Double? = builder.gopSize
    /**
     * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
     */
    public val gopSizeUnits: aws.sdk.kotlin.services.medialive.model.H264GopSizeUnits? = builder.gopSizeUnits
    /**
     * H.264 Level.
     */
    public val level: aws.sdk.kotlin.services.medialive.model.H264Level? = builder.level
    /**
     * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
     */
    public val lookAheadRateControl: aws.sdk.kotlin.services.medialive.model.H264LookAheadRateControl? = builder.lookAheadRateControl
    /**
     * For QVBR: See the tooltip for Quality level For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    public val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     */
    public val minIInterval: kotlin.Int? = builder.minIInterval
    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
     */
    public val numRefFrames: kotlin.Int? = builder.numRefFrames
    /**
     * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
     */
    public val parControl: aws.sdk.kotlin.services.medialive.model.H264ParControl? = builder.parControl
    /**
     * Pixel Aspect Ratio denominator.
     */
    public val parDenominator: kotlin.Int? = builder.parDenominator
    /**
     * Pixel Aspect Ratio numerator.
     */
    public val parNumerator: kotlin.Int? = builder.parNumerator
    /**
     * H.264 Profile.
     */
    public val profile: aws.sdk.kotlin.services.medialive.model.H264Profile? = builder.profile
    /**
     * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
     */
    public val qualityLevel: aws.sdk.kotlin.services.medialive.model.H264QualityLevel? = builder.qualityLevel
    /**
     * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide
     */
    public val qvbrQualityLevel: kotlin.Int? = builder.qvbrQualityLevel
    /**
     * Rate control mode. QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate. Recommended if you or your viewers pay for bandwidth. VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to maintain a specific average bitrate over the duration of the channel. CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices that cannot handle variable bitrates. Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the Multiplex Program.
     */
    public val rateControlMode: aws.sdk.kotlin.services.medialive.model.H264RateControlMode? = builder.rateControlMode
    /**
     * Sets the scan type of the output to progressive or top-field-first interlaced.
     */
    public val scanType: aws.sdk.kotlin.services.medialive.model.H264ScanType? = builder.scanType
    /**
     * Scene change detection. - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is detected.
     */
    public val sceneChangeDetect: aws.sdk.kotlin.services.medialive.model.H264SceneChangeDetect? = builder.sceneChangeDetect
    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
     */
    public val slices: kotlin.Int? = builder.slices
    /**
     * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If not set to zero, must be greater than 15.
     */
    public val softness: kotlin.Int? = builder.softness
    /**
     * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
     */
    public val spatialAq: aws.sdk.kotlin.services.medialive.model.H264SpatialAq? = builder.spatialAq
    /**
     * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.
     */
    public val subgopLength: aws.sdk.kotlin.services.medialive.model.H264SubGopLength? = builder.subgopLength
    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     */
    public val syntax: aws.sdk.kotlin.services.medialive.model.H264Syntax? = builder.syntax
    /**
     * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
     */
    public val temporalAq: aws.sdk.kotlin.services.medialive.model.H264TemporalAq? = builder.temporalAq
    /**
     * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
     */
    public val timecodeInsertion: aws.sdk.kotlin.services.medialive.model.H264TimecodeInsertionBehavior? = builder.timecodeInsertion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.H264Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("H264Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("afdSignaling=$afdSignaling,")
        append("bitrate=$bitrate,")
        append("bufFillPct=$bufFillPct,")
        append("bufSize=$bufSize,")
        append("colorMetadata=$colorMetadata,")
        append("colorSpaceSettings=$colorSpaceSettings,")
        append("entropyEncoding=$entropyEncoding,")
        append("filterSettings=$filterSettings,")
        append("fixedAfd=$fixedAfd,")
        append("flickerAq=$flickerAq,")
        append("forceFieldPictures=$forceFieldPictures,")
        append("framerateControl=$framerateControl,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopBReference=$gopBReference,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("gopNumBFrames=$gopNumBFrames,")
        append("gopSize=$gopSize,")
        append("gopSizeUnits=$gopSizeUnits,")
        append("level=$level,")
        append("lookAheadRateControl=$lookAheadRateControl,")
        append("maxBitrate=$maxBitrate,")
        append("minIInterval=$minIInterval,")
        append("numRefFrames=$numRefFrames,")
        append("parControl=$parControl,")
        append("parDenominator=$parDenominator,")
        append("parNumerator=$parNumerator,")
        append("profile=$profile,")
        append("qualityLevel=$qualityLevel,")
        append("qvbrQualityLevel=$qvbrQualityLevel,")
        append("rateControlMode=$rateControlMode,")
        append("scanType=$scanType,")
        append("sceneChangeDetect=$sceneChangeDetect,")
        append("slices=$slices,")
        append("softness=$softness,")
        append("spatialAq=$spatialAq,")
        append("subgopLength=$subgopLength,")
        append("syntax=$syntax,")
        append("temporalAq=$temporalAq,")
        append("timecodeInsertion=$timecodeInsertion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (afdSignaling?.hashCode() ?: 0)
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (bufFillPct ?: 0)
        result = 31 * result + (bufSize ?: 0)
        result = 31 * result + (colorMetadata?.hashCode() ?: 0)
        result = 31 * result + (colorSpaceSettings?.hashCode() ?: 0)
        result = 31 * result + (entropyEncoding?.hashCode() ?: 0)
        result = 31 * result + (filterSettings?.hashCode() ?: 0)
        result = 31 * result + (fixedAfd?.hashCode() ?: 0)
        result = 31 * result + (flickerAq?.hashCode() ?: 0)
        result = 31 * result + (forceFieldPictures?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (gopBReference?.hashCode() ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (gopNumBFrames ?: 0)
        result = 31 * result + (gopSize?.hashCode() ?: 0)
        result = 31 * result + (gopSizeUnits?.hashCode() ?: 0)
        result = 31 * result + (level?.hashCode() ?: 0)
        result = 31 * result + (lookAheadRateControl?.hashCode() ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (minIInterval ?: 0)
        result = 31 * result + (numRefFrames ?: 0)
        result = 31 * result + (parControl?.hashCode() ?: 0)
        result = 31 * result + (parDenominator ?: 0)
        result = 31 * result + (parNumerator ?: 0)
        result = 31 * result + (profile?.hashCode() ?: 0)
        result = 31 * result + (qualityLevel?.hashCode() ?: 0)
        result = 31 * result + (qvbrQualityLevel ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        result = 31 * result + (sceneChangeDetect?.hashCode() ?: 0)
        result = 31 * result + (slices ?: 0)
        result = 31 * result + (softness ?: 0)
        result = 31 * result + (spatialAq?.hashCode() ?: 0)
        result = 31 * result + (subgopLength?.hashCode() ?: 0)
        result = 31 * result + (syntax?.hashCode() ?: 0)
        result = 31 * result + (temporalAq?.hashCode() ?: 0)
        result = 31 * result + (timecodeInsertion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as H264Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (afdSignaling != other.afdSignaling) return false
        if (bitrate != other.bitrate) return false
        if (bufFillPct != other.bufFillPct) return false
        if (bufSize != other.bufSize) return false
        if (colorMetadata != other.colorMetadata) return false
        if (colorSpaceSettings != other.colorSpaceSettings) return false
        if (entropyEncoding != other.entropyEncoding) return false
        if (filterSettings != other.filterSettings) return false
        if (fixedAfd != other.fixedAfd) return false
        if (flickerAq != other.flickerAq) return false
        if (forceFieldPictures != other.forceFieldPictures) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopBReference != other.gopBReference) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (gopNumBFrames != other.gopNumBFrames) return false
        if (gopSize != other.gopSize) return false
        if (gopSizeUnits != other.gopSizeUnits) return false
        if (level != other.level) return false
        if (lookAheadRateControl != other.lookAheadRateControl) return false
        if (maxBitrate != other.maxBitrate) return false
        if (minIInterval != other.minIInterval) return false
        if (numRefFrames != other.numRefFrames) return false
        if (parControl != other.parControl) return false
        if (parDenominator != other.parDenominator) return false
        if (parNumerator != other.parNumerator) return false
        if (profile != other.profile) return false
        if (qualityLevel != other.qualityLevel) return false
        if (qvbrQualityLevel != other.qvbrQualityLevel) return false
        if (rateControlMode != other.rateControlMode) return false
        if (scanType != other.scanType) return false
        if (sceneChangeDetect != other.sceneChangeDetect) return false
        if (slices != other.slices) return false
        if (softness != other.softness) return false
        if (spatialAq != other.spatialAq) return false
        if (subgopLength != other.subgopLength) return false
        if (syntax != other.syntax) return false
        if (temporalAq != other.temporalAq) return false
        if (timecodeInsertion != other.timecodeInsertion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.H264Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
         */
        public var adaptiveQuantization: aws.sdk.kotlin.services.medialive.model.H264AdaptiveQuantization? = null
        /**
         * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
         */
        public var afdSignaling: aws.sdk.kotlin.services.medialive.model.AfdSignaling? = null
        /**
         * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
         */
        public var bitrate: kotlin.Int? = null
        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         */
        public var bufFillPct: kotlin.Int? = null
        /**
         * Size of buffer (HRD buffer model) in bits.
         */
        public var bufSize: kotlin.Int? = null
        /**
         * Includes colorspace metadata in the output.
         */
        public var colorMetadata: aws.sdk.kotlin.services.medialive.model.H264ColorMetadata? = null
        /**
         * Color Space settings
         */
        public var colorSpaceSettings: aws.sdk.kotlin.services.medialive.model.H264ColorSpaceSettings? = null
        /**
         * Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
         */
        public var entropyEncoding: aws.sdk.kotlin.services.medialive.model.H264EntropyEncoding? = null
        /**
         * Optional filters that you can apply to an encode.
         */
        public var filterSettings: aws.sdk.kotlin.services.medialive.model.H264FilterSettings? = null
        /**
         * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
         */
        public var fixedAfd: aws.sdk.kotlin.services.medialive.model.FixedAfd? = null
        /**
         * Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
         */
        public var flickerAq: aws.sdk.kotlin.services.medialive.model.H264FlickerAq? = null
        /**
         * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
         */
        public var forceFieldPictures: aws.sdk.kotlin.services.medialive.model.H264ForceFieldPictures? = null
        /**
         * This field indicates how the output video frame rate is specified. If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.
         */
        public var framerateControl: aws.sdk.kotlin.services.medialive.model.H264FramerateControl? = null
        /**
         * Framerate denominator.
         */
        public var framerateDenominator: kotlin.Int? = null
        /**
         * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         */
        public var framerateNumerator: kotlin.Int? = null
        /**
         * Documentation update needed
         */
        public var gopBReference: aws.sdk.kotlin.services.medialive.model.H264GopBReference? = null
        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
         */
        public var gopClosedCadence: kotlin.Int? = null
        /**
         * Number of B-frames between reference frames.
         */
        public var gopNumBFrames: kotlin.Int? = null
        /**
         * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
         */
        public var gopSize: kotlin.Double? = null
        /**
         * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
         */
        public var gopSizeUnits: aws.sdk.kotlin.services.medialive.model.H264GopSizeUnits? = null
        /**
         * H.264 Level.
         */
        public var level: aws.sdk.kotlin.services.medialive.model.H264Level? = null
        /**
         * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
         */
        public var lookAheadRateControl: aws.sdk.kotlin.services.medialive.model.H264LookAheadRateControl? = null
        /**
         * For QVBR: See the tooltip for Quality level For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
         */
        public var maxBitrate: kotlin.Int? = null
        /**
         * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         */
        public var minIInterval: kotlin.Int? = null
        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
         */
        public var numRefFrames: kotlin.Int? = null
        /**
         * This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
         */
        public var parControl: aws.sdk.kotlin.services.medialive.model.H264ParControl? = null
        /**
         * Pixel Aspect Ratio denominator.
         */
        public var parDenominator: kotlin.Int? = null
        /**
         * Pixel Aspect Ratio numerator.
         */
        public var parNumerator: kotlin.Int? = null
        /**
         * H.264 Profile.
         */
        public var profile: aws.sdk.kotlin.services.medialive.model.H264Profile? = null
        /**
         * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
         */
        public var qualityLevel: aws.sdk.kotlin.services.medialive.model.H264QualityLevel? = null
        /**
         * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide
         */
        public var qvbrQualityLevel: kotlin.Int? = null
        /**
         * Rate control mode. QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate. Recommended if you or your viewers pay for bandwidth. VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR if you want to maintain a specific average bitrate over the duration of the channel. CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices that cannot handle variable bitrates. Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the Multiplex Program.
         */
        public var rateControlMode: aws.sdk.kotlin.services.medialive.model.H264RateControlMode? = null
        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         */
        public var scanType: aws.sdk.kotlin.services.medialive.model.H264ScanType? = null
        /**
         * Scene change detection. - On: inserts I-frames when scene change is detected. - Off: does not force an I-frame when scene change is detected.
         */
        public var sceneChangeDetect: aws.sdk.kotlin.services.medialive.model.H264SceneChangeDetect? = null
        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
         */
        public var slices: kotlin.Int? = null
        /**
         * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If not set to zero, must be greater than 15.
         */
        public var softness: kotlin.Int? = null
        /**
         * Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
         */
        public var spatialAq: aws.sdk.kotlin.services.medialive.model.H264SpatialAq? = null
        /**
         * If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.
         */
        public var subgopLength: aws.sdk.kotlin.services.medialive.model.H264SubGopLength? = null
        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         */
        public var syntax: aws.sdk.kotlin.services.medialive.model.H264Syntax? = null
        /**
         * Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
         */
        public var temporalAq: aws.sdk.kotlin.services.medialive.model.H264TemporalAq? = null
        /**
         * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
         */
        public var timecodeInsertion: aws.sdk.kotlin.services.medialive.model.H264TimecodeInsertionBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.H264Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.afdSignaling = x.afdSignaling
            this.bitrate = x.bitrate
            this.bufFillPct = x.bufFillPct
            this.bufSize = x.bufSize
            this.colorMetadata = x.colorMetadata
            this.colorSpaceSettings = x.colorSpaceSettings
            this.entropyEncoding = x.entropyEncoding
            this.filterSettings = x.filterSettings
            this.fixedAfd = x.fixedAfd
            this.flickerAq = x.flickerAq
            this.forceFieldPictures = x.forceFieldPictures
            this.framerateControl = x.framerateControl
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopBReference = x.gopBReference
            this.gopClosedCadence = x.gopClosedCadence
            this.gopNumBFrames = x.gopNumBFrames
            this.gopSize = x.gopSize
            this.gopSizeUnits = x.gopSizeUnits
            this.level = x.level
            this.lookAheadRateControl = x.lookAheadRateControl
            this.maxBitrate = x.maxBitrate
            this.minIInterval = x.minIInterval
            this.numRefFrames = x.numRefFrames
            this.parControl = x.parControl
            this.parDenominator = x.parDenominator
            this.parNumerator = x.parNumerator
            this.profile = x.profile
            this.qualityLevel = x.qualityLevel
            this.qvbrQualityLevel = x.qvbrQualityLevel
            this.rateControlMode = x.rateControlMode
            this.scanType = x.scanType
            this.sceneChangeDetect = x.sceneChangeDetect
            this.slices = x.slices
            this.softness = x.softness
            this.spatialAq = x.spatialAq
            this.subgopLength = x.subgopLength
            this.syntax = x.syntax
            this.temporalAq = x.temporalAq
            this.timecodeInsertion = x.timecodeInsertion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.H264Settings = H264Settings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.H264ColorSpaceSettings] inside the given [block]
         */
        public fun colorSpaceSettings(block: aws.sdk.kotlin.services.medialive.model.H264ColorSpaceSettings.Builder.() -> kotlin.Unit) {
            this.colorSpaceSettings = aws.sdk.kotlin.services.medialive.model.H264ColorSpaceSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.H264FilterSettings] inside the given [block]
         */
        public fun filterSettings(block: aws.sdk.kotlin.services.medialive.model.H264FilterSettings.Builder.() -> kotlin.Unit) {
            this.filterSettings = aws.sdk.kotlin.services.medialive.model.H264FilterSettings.invoke(block)
        }
    }
}
