// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Hls Group Settings
 */
public class HlsGroupSettings private constructor(builder: Builder) {
    /**
     * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
     */
    public val adMarkers: List<HlsAdMarkers>? = builder.adMarkers
    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
     */
    public val baseUrlContent: kotlin.String? = builder.baseUrlContent
    /**
     * Optional. One value per output group. This field is required only if you are completing Base URL content A, and the downstream system has notified you that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline 0.
     */
    public val baseUrlContent1: kotlin.String? = builder.baseUrlContent1
    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
     */
    public val baseUrlManifest: kotlin.String? = builder.baseUrlManifest
    /**
     * Optional. One value per output group. Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest files for pipeline 0.
     */
    public val baseUrlManifest1: kotlin.String? = builder.baseUrlManifest1
    /**
     * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set to "insert".
     */
    public val captionLanguageMappings: List<CaptionLanguageMapping>? = builder.captionLanguageMappings
    /**
     * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
     */
    public val captionLanguageSetting: aws.sdk.kotlin.services.medialive.model.HlsCaptionLanguageSetting? = builder.captionLanguageSetting
    /**
     * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving media segments for later replay.
     */
    public val clientCache: aws.sdk.kotlin.services.medialive.model.HlsClientCache? = builder.clientCache
    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     */
    public val codecSpecification: aws.sdk.kotlin.services.medialive.model.HlsCodecSpecification? = builder.codecSpecification
    /**
     * For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text string. If ivSource is set to "explicit" then this parameter is required and is used as the IV for encryption.
     */
    public val constantIv: kotlin.String? = builder.constantIv
    /**
     * A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
     */
    public val destination: aws.sdk.kotlin.services.medialive.model.OutputLocationRef? = builder.destination
    /**
     * Place segments in subdirectories.
     */
    public val directoryStructure: aws.sdk.kotlin.services.medialive.model.HlsDirectoryStructure? = builder.directoryStructure
    /**
     * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group. Typically, choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an important purpose. Choose Never Insert only if the downstream system is doing real-time failover (without using the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.
     */
    public val discontinuityTags: aws.sdk.kotlin.services.medialive.model.HlsDiscontinuityTags? = builder.discontinuityTags
    /**
     * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
     */
    public val encryptionType: aws.sdk.kotlin.services.medialive.model.HlsEncryptionType? = builder.encryptionType
    /**
     * Parameters that control interactions with the CDN.
     */
    public val hlsCdnSettings: aws.sdk.kotlin.services.medialive.model.HlsCdnSettings? = builder.hlsCdnSettings
    /**
     * State of HLS ID3 Segment Tagging
     */
    public val hlsId3SegmentTagging: aws.sdk.kotlin.services.medialive.model.HlsId3SegmentTaggingState? = builder.hlsId3SegmentTagging
    /**
     * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to the Output Selection field). STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888"
     */
    public val iFrameOnlyPlaylists: aws.sdk.kotlin.services.medialive.model.IFrameOnlyPlaylistType? = builder.iFrameOnlyPlaylists
    /**
     * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means that MediaLive decides whether to include the final segment, depending on the channel class and the types of output groups. Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control the behavior.
     */
    public val incompleteSegmentBehavior: aws.sdk.kotlin.services.medialive.model.HlsIncompleteSegmentBehavior? = builder.incompleteSegmentBehavior
    /**
     * Applies only if Mode field is LIVE. Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are removed from the media manifest. This number must be smaller than the number in the Keep Segments field.
     */
    public val indexNSegments: kotlin.Int? = builder.indexNSegments
    /**
     * Parameter that control output group behavior on input loss.
     */
    public val inputLossAction: aws.sdk.kotlin.services.medialive.model.InputLossActionForHlsOut? = builder.inputLossAction
    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
     */
    public val ivInManifest: aws.sdk.kotlin.services.medialive.model.HlsIvInManifest? = builder.ivInManifest
    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every segment (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
     */
    public val ivSource: aws.sdk.kotlin.services.medialive.model.HlsIvSource? = builder.ivSource
    /**
     * Applies only if Mode field is LIVE. Specifies the number of media segments to retain in the destination directory. This number should be bigger than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1). If this "keep segments" number is too low, the following might happen: the player is still reading a media manifest file that lists this segment, but that segment has been removed from the destination directory (as directed by indexNSegments). This situation would result in a 404 HTTP error on the player.
     */
    public val keepSegments: kotlin.Int? = builder.keepSegments
    /**
     * The value specifies how the key is represented in the resource identified by the URI. If parameter is absent, an implicit value of "identity" is used. A reverse DNS string can also be given.
     */
    public val keyFormat: kotlin.String? = builder.keyFormat
    /**
     * Either a single positive integer version value or a slash delimited list of version values (1/2/3).
     */
    public val keyFormatVersions: kotlin.String? = builder.keyFormatVersions
    /**
     * The key provider settings.
     */
    public val keyProviderSettings: aws.sdk.kotlin.services.medialive.model.KeyProviderSettings? = builder.keyProviderSettings
    /**
     * When set to gzip, compresses HLS playlist.
     */
    public val manifestCompression: aws.sdk.kotlin.services.medialive.model.HlsManifestCompression? = builder.manifestCompression
    /**
     * Indicates whether the output manifest should use floating point or integer values for segment duration.
     */
    public val manifestDurationFormat: aws.sdk.kotlin.services.medialive.model.HlsManifestDurationFormat? = builder.manifestDurationFormat
    /**
     * When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.
     */
    public val minSegmentLength: kotlin.Int? = builder.minSegmentLength
    /**
     * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments, which may prevent players from rewinding all the way to the beginning of the event. VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type manifest on completion of the stream.
     */
    public val mode: aws.sdk.kotlin.services.medialive.model.HlsMode? = builder.mode
    /**
     * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this output group. VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest. SEGMENTS_ONLY: Does not generate any manifests for this output group.
     */
    public val outputSelection: aws.sdk.kotlin.services.medialive.model.HlsOutputSelection? = builder.outputSelection
    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated using the program date time clock.
     */
    public val programDateTime: aws.sdk.kotlin.services.medialive.model.HlsProgramDateTime? = builder.programDateTime
    /**
     * Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock. Options include: INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized as a function of the first output timecode, then incremented by the EXTINF duration of each encoded segment. SYSTEM_CLOCK: The PDT clock is initialized as a function of the UTC wall clock, then incremented by the EXTINF duration of each encoded segment. If the PDT clock diverges from the wall clock by more than 500ms, it is resynchronized to the wall clock.
     */
    public val programDateTimeClock: aws.sdk.kotlin.services.medialive.model.HlsProgramDateTimeClock? = builder.programDateTimeClock
    /**
     * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     */
    public val programDateTimePeriod: kotlin.Int? = builder.programDateTimePeriod
    /**
     * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its own media files, then the media files of the other pipeline. This feature allows playout device that support stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale. There are still two destinations and two master manifests, but both master manifests reference the media files from both pipelines. DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only. For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed. MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is irrelevant.
     */
    public val redundantManifest: aws.sdk.kotlin.services.medialive.model.HlsRedundantManifest? = builder.redundantManifest
    /**
     * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next keyframe after this number of seconds, so actual segment length may be longer.
     */
    public val segmentLength: kotlin.Int? = builder.segmentLength
    /**
     * useInputSegmentation has been deprecated. The configured segment size is always used.
     */
    public val segmentationMode: aws.sdk.kotlin.services.medialive.model.HlsSegmentationMode? = builder.segmentationMode
    /**
     * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be subdirectoryPerStream for this setting to have an effect.
     */
    public val segmentsPerSubdirectory: kotlin.Int? = builder.segmentsPerSubdirectory
    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     */
    public val streamInfResolution: aws.sdk.kotlin.services.medialive.model.HlsStreamInfResolution? = builder.streamInfResolution
    /**
     * Indicates ID3 frame that has the timecode.
     */
    public val timedMetadataId3Frame: aws.sdk.kotlin.services.medialive.model.HlsTimedMetadataId3Frame? = builder.timedMetadataId3Frame
    /**
     * Timed Metadata interval in seconds.
     */
    public val timedMetadataId3Period: kotlin.Int? = builder.timedMetadataId3Period
    /**
     * Provides an extra millisecond delta offset to fine tune the timestamps.
     */
    public val timestampDeltaMilliseconds: kotlin.Int? = builder.timestampDeltaMilliseconds
    /**
     * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files. SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is running is not guaranteed due to HTTP server caching.
     */
    public val tsFileMode: aws.sdk.kotlin.services.medialive.model.HlsTsFileMode? = builder.tsFileMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.HlsGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsGroupSettings(")
        append("adMarkers=$adMarkers,")
        append("baseUrlContent=$baseUrlContent,")
        append("baseUrlContent1=$baseUrlContent1,")
        append("baseUrlManifest=$baseUrlManifest,")
        append("baseUrlManifest1=$baseUrlManifest1,")
        append("captionLanguageMappings=$captionLanguageMappings,")
        append("captionLanguageSetting=$captionLanguageSetting,")
        append("clientCache=$clientCache,")
        append("codecSpecification=$codecSpecification,")
        append("constantIv=$constantIv,")
        append("destination=$destination,")
        append("directoryStructure=$directoryStructure,")
        append("discontinuityTags=$discontinuityTags,")
        append("encryptionType=$encryptionType,")
        append("hlsCdnSettings=$hlsCdnSettings,")
        append("hlsId3SegmentTagging=$hlsId3SegmentTagging,")
        append("iFrameOnlyPlaylists=$iFrameOnlyPlaylists,")
        append("incompleteSegmentBehavior=$incompleteSegmentBehavior,")
        append("indexNSegments=$indexNSegments,")
        append("inputLossAction=$inputLossAction,")
        append("ivInManifest=$ivInManifest,")
        append("ivSource=$ivSource,")
        append("keepSegments=$keepSegments,")
        append("keyFormat=$keyFormat,")
        append("keyFormatVersions=$keyFormatVersions,")
        append("keyProviderSettings=$keyProviderSettings,")
        append("manifestCompression=$manifestCompression,")
        append("manifestDurationFormat=$manifestDurationFormat,")
        append("minSegmentLength=$minSegmentLength,")
        append("mode=$mode,")
        append("outputSelection=$outputSelection,")
        append("programDateTime=$programDateTime,")
        append("programDateTimeClock=$programDateTimeClock,")
        append("programDateTimePeriod=$programDateTimePeriod,")
        append("redundantManifest=$redundantManifest,")
        append("segmentLength=$segmentLength,")
        append("segmentationMode=$segmentationMode,")
        append("segmentsPerSubdirectory=$segmentsPerSubdirectory,")
        append("streamInfResolution=$streamInfResolution,")
        append("timedMetadataId3Frame=$timedMetadataId3Frame,")
        append("timedMetadataId3Period=$timedMetadataId3Period,")
        append("timestampDeltaMilliseconds=$timestampDeltaMilliseconds,")
        append("tsFileMode=$tsFileMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (baseUrlContent?.hashCode() ?: 0)
        result = 31 * result + (baseUrlContent1?.hashCode() ?: 0)
        result = 31 * result + (baseUrlManifest?.hashCode() ?: 0)
        result = 31 * result + (baseUrlManifest1?.hashCode() ?: 0)
        result = 31 * result + (captionLanguageMappings?.hashCode() ?: 0)
        result = 31 * result + (captionLanguageSetting?.hashCode() ?: 0)
        result = 31 * result + (clientCache?.hashCode() ?: 0)
        result = 31 * result + (codecSpecification?.hashCode() ?: 0)
        result = 31 * result + (constantIv?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (directoryStructure?.hashCode() ?: 0)
        result = 31 * result + (discontinuityTags?.hashCode() ?: 0)
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (hlsCdnSettings?.hashCode() ?: 0)
        result = 31 * result + (hlsId3SegmentTagging?.hashCode() ?: 0)
        result = 31 * result + (iFrameOnlyPlaylists?.hashCode() ?: 0)
        result = 31 * result + (incompleteSegmentBehavior?.hashCode() ?: 0)
        result = 31 * result + (indexNSegments ?: 0)
        result = 31 * result + (inputLossAction?.hashCode() ?: 0)
        result = 31 * result + (ivInManifest?.hashCode() ?: 0)
        result = 31 * result + (ivSource?.hashCode() ?: 0)
        result = 31 * result + (keepSegments ?: 0)
        result = 31 * result + (keyFormat?.hashCode() ?: 0)
        result = 31 * result + (keyFormatVersions?.hashCode() ?: 0)
        result = 31 * result + (keyProviderSettings?.hashCode() ?: 0)
        result = 31 * result + (manifestCompression?.hashCode() ?: 0)
        result = 31 * result + (manifestDurationFormat?.hashCode() ?: 0)
        result = 31 * result + (minSegmentLength ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (outputSelection?.hashCode() ?: 0)
        result = 31 * result + (programDateTime?.hashCode() ?: 0)
        result = 31 * result + (programDateTimeClock?.hashCode() ?: 0)
        result = 31 * result + (programDateTimePeriod ?: 0)
        result = 31 * result + (redundantManifest?.hashCode() ?: 0)
        result = 31 * result + (segmentLength ?: 0)
        result = 31 * result + (segmentationMode?.hashCode() ?: 0)
        result = 31 * result + (segmentsPerSubdirectory ?: 0)
        result = 31 * result + (streamInfResolution?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataId3Frame?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataId3Period ?: 0)
        result = 31 * result + (timestampDeltaMilliseconds ?: 0)
        result = 31 * result + (tsFileMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsGroupSettings

        if (adMarkers != other.adMarkers) return false
        if (baseUrlContent != other.baseUrlContent) return false
        if (baseUrlContent1 != other.baseUrlContent1) return false
        if (baseUrlManifest != other.baseUrlManifest) return false
        if (baseUrlManifest1 != other.baseUrlManifest1) return false
        if (captionLanguageMappings != other.captionLanguageMappings) return false
        if (captionLanguageSetting != other.captionLanguageSetting) return false
        if (clientCache != other.clientCache) return false
        if (codecSpecification != other.codecSpecification) return false
        if (constantIv != other.constantIv) return false
        if (destination != other.destination) return false
        if (directoryStructure != other.directoryStructure) return false
        if (discontinuityTags != other.discontinuityTags) return false
        if (encryptionType != other.encryptionType) return false
        if (hlsCdnSettings != other.hlsCdnSettings) return false
        if (hlsId3SegmentTagging != other.hlsId3SegmentTagging) return false
        if (iFrameOnlyPlaylists != other.iFrameOnlyPlaylists) return false
        if (incompleteSegmentBehavior != other.incompleteSegmentBehavior) return false
        if (indexNSegments != other.indexNSegments) return false
        if (inputLossAction != other.inputLossAction) return false
        if (ivInManifest != other.ivInManifest) return false
        if (ivSource != other.ivSource) return false
        if (keepSegments != other.keepSegments) return false
        if (keyFormat != other.keyFormat) return false
        if (keyFormatVersions != other.keyFormatVersions) return false
        if (keyProviderSettings != other.keyProviderSettings) return false
        if (manifestCompression != other.manifestCompression) return false
        if (manifestDurationFormat != other.manifestDurationFormat) return false
        if (minSegmentLength != other.minSegmentLength) return false
        if (mode != other.mode) return false
        if (outputSelection != other.outputSelection) return false
        if (programDateTime != other.programDateTime) return false
        if (programDateTimeClock != other.programDateTimeClock) return false
        if (programDateTimePeriod != other.programDateTimePeriod) return false
        if (redundantManifest != other.redundantManifest) return false
        if (segmentLength != other.segmentLength) return false
        if (segmentationMode != other.segmentationMode) return false
        if (segmentsPerSubdirectory != other.segmentsPerSubdirectory) return false
        if (streamInfResolution != other.streamInfResolution) return false
        if (timedMetadataId3Frame != other.timedMetadataId3Frame) return false
        if (timedMetadataId3Period != other.timedMetadataId3Period) return false
        if (timestampDeltaMilliseconds != other.timestampDeltaMilliseconds) return false
        if (tsFileMode != other.tsFileMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.HlsGroupSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         */
        public var adMarkers: List<HlsAdMarkers>? = null
        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
         */
        public var baseUrlContent: kotlin.String? = null
        /**
         * Optional. One value per output group. This field is required only if you are completing Base URL content A, and the downstream system has notified you that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline 0.
         */
        public var baseUrlContent1: kotlin.String? = null
        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.
         */
        public var baseUrlManifest: kotlin.String? = null
        /**
         * Optional. One value per output group. Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest files for pipeline 0.
         */
        public var baseUrlManifest1: kotlin.String? = null
        /**
         * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set to "insert".
         */
        public var captionLanguageMappings: List<CaptionLanguageMapping>? = null
        /**
         * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
         */
        public var captionLanguageSetting: aws.sdk.kotlin.services.medialive.model.HlsCaptionLanguageSetting? = null
        /**
         * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving media segments for later replay.
         */
        public var clientCache: aws.sdk.kotlin.services.medialive.model.HlsClientCache? = null
        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         */
        public var codecSpecification: aws.sdk.kotlin.services.medialive.model.HlsCodecSpecification? = null
        /**
         * For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text string. If ivSource is set to "explicit" then this parameter is required and is used as the IV for encryption.
         */
        public var constantIv: kotlin.String? = null
        /**
         * A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
         */
        public var destination: aws.sdk.kotlin.services.medialive.model.OutputLocationRef? = null
        /**
         * Place segments in subdirectories.
         */
        public var directoryStructure: aws.sdk.kotlin.services.medialive.model.HlsDirectoryStructure? = null
        /**
         * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group. Typically, choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an important purpose. Choose Never Insert only if the downstream system is doing real-time failover (without using the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.
         */
        public var discontinuityTags: aws.sdk.kotlin.services.medialive.model.HlsDiscontinuityTags? = null
        /**
         * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
         */
        public var encryptionType: aws.sdk.kotlin.services.medialive.model.HlsEncryptionType? = null
        /**
         * Parameters that control interactions with the CDN.
         */
        public var hlsCdnSettings: aws.sdk.kotlin.services.medialive.model.HlsCdnSettings? = null
        /**
         * State of HLS ID3 Segment Tagging
         */
        public var hlsId3SegmentTagging: aws.sdk.kotlin.services.medialive.model.HlsId3SegmentTaggingState? = null
        /**
         * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to the Output Selection field). STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888"
         */
        public var iFrameOnlyPlaylists: aws.sdk.kotlin.services.medialive.model.IFrameOnlyPlaylistType? = null
        /**
         * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means that MediaLive decides whether to include the final segment, depending on the channel class and the types of output groups. Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control the behavior.
         */
        public var incompleteSegmentBehavior: aws.sdk.kotlin.services.medialive.model.HlsIncompleteSegmentBehavior? = null
        /**
         * Applies only if Mode field is LIVE. Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are removed from the media manifest. This number must be smaller than the number in the Keep Segments field.
         */
        public var indexNSegments: kotlin.Int? = null
        /**
         * Parameter that control output group behavior on input loss.
         */
        public var inputLossAction: aws.sdk.kotlin.services.medialive.model.InputLossActionForHlsOut? = null
        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
         */
        public var ivInManifest: aws.sdk.kotlin.services.medialive.model.HlsIvInManifest? = null
        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every segment (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
         */
        public var ivSource: aws.sdk.kotlin.services.medialive.model.HlsIvSource? = null
        /**
         * Applies only if Mode field is LIVE. Specifies the number of media segments to retain in the destination directory. This number should be bigger than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1). If this "keep segments" number is too low, the following might happen: the player is still reading a media manifest file that lists this segment, but that segment has been removed from the destination directory (as directed by indexNSegments). This situation would result in a 404 HTTP error on the player.
         */
        public var keepSegments: kotlin.Int? = null
        /**
         * The value specifies how the key is represented in the resource identified by the URI. If parameter is absent, an implicit value of "identity" is used. A reverse DNS string can also be given.
         */
        public var keyFormat: kotlin.String? = null
        /**
         * Either a single positive integer version value or a slash delimited list of version values (1/2/3).
         */
        public var keyFormatVersions: kotlin.String? = null
        /**
         * The key provider settings.
         */
        public var keyProviderSettings: aws.sdk.kotlin.services.medialive.model.KeyProviderSettings? = null
        /**
         * When set to gzip, compresses HLS playlist.
         */
        public var manifestCompression: aws.sdk.kotlin.services.medialive.model.HlsManifestCompression? = null
        /**
         * Indicates whether the output manifest should use floating point or integer values for segment duration.
         */
        public var manifestDurationFormat: aws.sdk.kotlin.services.medialive.model.HlsManifestDurationFormat? = null
        /**
         * When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.
         */
        public var minSegmentLength: kotlin.Int? = null
        /**
         * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments, which may prevent players from rewinding all the way to the beginning of the event. VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type manifest on completion of the stream.
         */
        public var mode: aws.sdk.kotlin.services.medialive.model.HlsMode? = null
        /**
         * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this output group. VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest. SEGMENTS_ONLY: Does not generate any manifests for this output group.
         */
        public var outputSelection: aws.sdk.kotlin.services.medialive.model.HlsOutputSelection? = null
        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated using the program date time clock.
         */
        public var programDateTime: aws.sdk.kotlin.services.medialive.model.HlsProgramDateTime? = null
        /**
         * Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock. Options include: INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized as a function of the first output timecode, then incremented by the EXTINF duration of each encoded segment. SYSTEM_CLOCK: The PDT clock is initialized as a function of the UTC wall clock, then incremented by the EXTINF duration of each encoded segment. If the PDT clock diverges from the wall clock by more than 500ms, it is resynchronized to the wall clock.
         */
        public var programDateTimeClock: aws.sdk.kotlin.services.medialive.model.HlsProgramDateTimeClock? = null
        /**
         * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         */
        public var programDateTimePeriod: kotlin.Int? = null
        /**
         * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its own media files, then the media files of the other pipeline. This feature allows playout device that support stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale. There are still two destinations and two master manifests, but both master manifests reference the media files from both pipelines. DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only. For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed. MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is irrelevant.
         */
        public var redundantManifest: aws.sdk.kotlin.services.medialive.model.HlsRedundantManifest? = null
        /**
         * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next keyframe after this number of seconds, so actual segment length may be longer.
         */
        public var segmentLength: kotlin.Int? = null
        /**
         * useInputSegmentation has been deprecated. The configured segment size is always used.
         */
        public var segmentationMode: aws.sdk.kotlin.services.medialive.model.HlsSegmentationMode? = null
        /**
         * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be subdirectoryPerStream for this setting to have an effect.
         */
        public var segmentsPerSubdirectory: kotlin.Int? = null
        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         */
        public var streamInfResolution: aws.sdk.kotlin.services.medialive.model.HlsStreamInfResolution? = null
        /**
         * Indicates ID3 frame that has the timecode.
         */
        public var timedMetadataId3Frame: aws.sdk.kotlin.services.medialive.model.HlsTimedMetadataId3Frame? = null
        /**
         * Timed Metadata interval in seconds.
         */
        public var timedMetadataId3Period: kotlin.Int? = null
        /**
         * Provides an extra millisecond delta offset to fine tune the timestamps.
         */
        public var timestampDeltaMilliseconds: kotlin.Int? = null
        /**
         * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files. SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is running is not guaranteed due to HTTP server caching.
         */
        public var tsFileMode: aws.sdk.kotlin.services.medialive.model.HlsTsFileMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.HlsGroupSettings) : this() {
            this.adMarkers = x.adMarkers
            this.baseUrlContent = x.baseUrlContent
            this.baseUrlContent1 = x.baseUrlContent1
            this.baseUrlManifest = x.baseUrlManifest
            this.baseUrlManifest1 = x.baseUrlManifest1
            this.captionLanguageMappings = x.captionLanguageMappings
            this.captionLanguageSetting = x.captionLanguageSetting
            this.clientCache = x.clientCache
            this.codecSpecification = x.codecSpecification
            this.constantIv = x.constantIv
            this.destination = x.destination
            this.directoryStructure = x.directoryStructure
            this.discontinuityTags = x.discontinuityTags
            this.encryptionType = x.encryptionType
            this.hlsCdnSettings = x.hlsCdnSettings
            this.hlsId3SegmentTagging = x.hlsId3SegmentTagging
            this.iFrameOnlyPlaylists = x.iFrameOnlyPlaylists
            this.incompleteSegmentBehavior = x.incompleteSegmentBehavior
            this.indexNSegments = x.indexNSegments
            this.inputLossAction = x.inputLossAction
            this.ivInManifest = x.ivInManifest
            this.ivSource = x.ivSource
            this.keepSegments = x.keepSegments
            this.keyFormat = x.keyFormat
            this.keyFormatVersions = x.keyFormatVersions
            this.keyProviderSettings = x.keyProviderSettings
            this.manifestCompression = x.manifestCompression
            this.manifestDurationFormat = x.manifestDurationFormat
            this.minSegmentLength = x.minSegmentLength
            this.mode = x.mode
            this.outputSelection = x.outputSelection
            this.programDateTime = x.programDateTime
            this.programDateTimeClock = x.programDateTimeClock
            this.programDateTimePeriod = x.programDateTimePeriod
            this.redundantManifest = x.redundantManifest
            this.segmentLength = x.segmentLength
            this.segmentationMode = x.segmentationMode
            this.segmentsPerSubdirectory = x.segmentsPerSubdirectory
            this.streamInfResolution = x.streamInfResolution
            this.timedMetadataId3Frame = x.timedMetadataId3Frame
            this.timedMetadataId3Period = x.timedMetadataId3Period
            this.timestampDeltaMilliseconds = x.timestampDeltaMilliseconds
            this.tsFileMode = x.tsFileMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.HlsGroupSettings = HlsGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.OutputLocationRef] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.medialive.model.OutputLocationRef.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.medialive.model.OutputLocationRef.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.HlsCdnSettings] inside the given [block]
         */
        public fun hlsCdnSettings(block: aws.sdk.kotlin.services.medialive.model.HlsCdnSettings.Builder.() -> kotlin.Unit) {
            this.hlsCdnSettings = aws.sdk.kotlin.services.medialive.model.HlsCdnSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.KeyProviderSettings] inside the given [block]
         */
        public fun keyProviderSettings(block: aws.sdk.kotlin.services.medialive.model.KeyProviderSettings.Builder.() -> kotlin.Unit) {
            this.keyProviderSettings = aws.sdk.kotlin.services.medialive.model.KeyProviderSettings.invoke(block)
        }
    }
}
