// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Hls Input Settings
 */
public class HlsInputSettings private constructor(builder: Builder) {
    /**
     * When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in bits per second, as in an HLS manifest.
     */
    public val bandwidth: kotlin.Int? = builder.bandwidth
    /**
     * When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment). When not specified, the HLS input will begin with the first segment specified in the m3u8.
     */
    public val bufferSegments: kotlin.Int? = builder.bufferSegments
    /**
     * The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
     */
    public val retries: kotlin.Int? = builder.retries
    /**
     * The number of seconds between retries when an attempt to read a manifest or segment fails.
     */
    public val retryInterval: kotlin.Int? = builder.retryInterval
    /**
     * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.
     */
    public val scte35Source: aws.sdk.kotlin.services.medialive.model.HlsScte35SourceType? = builder.scte35Source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.HlsInputSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsInputSettings(")
        append("bandwidth=$bandwidth,")
        append("bufferSegments=$bufferSegments,")
        append("retries=$retries,")
        append("retryInterval=$retryInterval,")
        append("scte35Source=$scte35Source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bandwidth ?: 0
        result = 31 * result + (bufferSegments ?: 0)
        result = 31 * result + (retries ?: 0)
        result = 31 * result + (retryInterval ?: 0)
        result = 31 * result + (scte35Source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsInputSettings

        if (bandwidth != other.bandwidth) return false
        if (bufferSegments != other.bufferSegments) return false
        if (retries != other.retries) return false
        if (retryInterval != other.retryInterval) return false
        if (scte35Source != other.scte35Source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.HlsInputSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in bits per second, as in an HLS manifest.
         */
        public var bandwidth: kotlin.Int? = null
        /**
         * When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment). When not specified, the HLS input will begin with the first segment specified in the m3u8.
         */
        public var bufferSegments: kotlin.Int? = null
        /**
         * The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
         */
        public var retries: kotlin.Int? = null
        /**
         * The number of seconds between retries when an attempt to read a manifest or segment fails.
         */
        public var retryInterval: kotlin.Int? = null
        /**
         * Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.
         */
        public var scte35Source: aws.sdk.kotlin.services.medialive.model.HlsScte35SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.HlsInputSettings) : this() {
            this.bandwidth = x.bandwidth
            this.bufferSegments = x.bufferSegments
            this.retries = x.retries
            this.retryInterval = x.retryInterval
            this.scte35Source = x.scte35Source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.HlsInputSettings = HlsInputSettings(this)
    }
}
