// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Details of the input device.
 */
public class InputDeviceSummary private constructor(builder: Builder) {
    /**
     * The unique ARN of the input device.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The state of the connection between the input device and AWS.
     */
    public val connectionState: aws.sdk.kotlin.services.medialive.model.InputDeviceConnectionState? = builder.connectionState
    /**
     * The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
     */
    public val deviceSettingsSyncState: aws.sdk.kotlin.services.medialive.model.DeviceSettingsSyncState? = builder.deviceSettingsSyncState
    /**
     * The status of software on the input device.
     */
    public val deviceUpdateStatus: aws.sdk.kotlin.services.medialive.model.DeviceUpdateStatus? = builder.deviceUpdateStatus
    /**
     * Settings that describe an input device that is type HD.
     */
    public val hdDeviceSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceHdSettings? = builder.hdDeviceSettings
    /**
     * The unique ID of the input device.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The network MAC address of the input device.
     */
    public val macAddress: kotlin.String? = builder.macAddress
    /**
     * A name that you specify for the input device.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Network settings for the input device.
     */
    public val networkSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceNetworkSettings? = builder.networkSettings
    /**
     * The unique serial number of the input device.
     */
    public val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The type of the input device.
     */
    public val type: aws.sdk.kotlin.services.medialive.model.InputDeviceType? = builder.type
    /**
     * Settings that describe an input device that is type UHD.
     */
    public val uhdDeviceSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceUhdSettings? = builder.uhdDeviceSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.InputDeviceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDeviceSummary(")
        append("arn=$arn,")
        append("connectionState=$connectionState,")
        append("deviceSettingsSyncState=$deviceSettingsSyncState,")
        append("deviceUpdateStatus=$deviceUpdateStatus,")
        append("hdDeviceSettings=$hdDeviceSettings,")
        append("id=$id,")
        append("macAddress=$macAddress,")
        append("name=$name,")
        append("networkSettings=$networkSettings,")
        append("serialNumber=$serialNumber,")
        append("type=$type,")
        append("uhdDeviceSettings=$uhdDeviceSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (deviceSettingsSyncState?.hashCode() ?: 0)
        result = 31 * result + (deviceUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (hdDeviceSettings?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (macAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkSettings?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uhdDeviceSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDeviceSummary

        if (arn != other.arn) return false
        if (connectionState != other.connectionState) return false
        if (deviceSettingsSyncState != other.deviceSettingsSyncState) return false
        if (deviceUpdateStatus != other.deviceUpdateStatus) return false
        if (hdDeviceSettings != other.hdDeviceSettings) return false
        if (id != other.id) return false
        if (macAddress != other.macAddress) return false
        if (name != other.name) return false
        if (networkSettings != other.networkSettings) return false
        if (serialNumber != other.serialNumber) return false
        if (type != other.type) return false
        if (uhdDeviceSettings != other.uhdDeviceSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.InputDeviceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ARN of the input device.
         */
        public var arn: kotlin.String? = null
        /**
         * The state of the connection between the input device and AWS.
         */
        public var connectionState: aws.sdk.kotlin.services.medialive.model.InputDeviceConnectionState? = null
        /**
         * The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
         */
        public var deviceSettingsSyncState: aws.sdk.kotlin.services.medialive.model.DeviceSettingsSyncState? = null
        /**
         * The status of software on the input device.
         */
        public var deviceUpdateStatus: aws.sdk.kotlin.services.medialive.model.DeviceUpdateStatus? = null
        /**
         * Settings that describe an input device that is type HD.
         */
        public var hdDeviceSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceHdSettings? = null
        /**
         * The unique ID of the input device.
         */
        public var id: kotlin.String? = null
        /**
         * The network MAC address of the input device.
         */
        public var macAddress: kotlin.String? = null
        /**
         * A name that you specify for the input device.
         */
        public var name: kotlin.String? = null
        /**
         * Network settings for the input device.
         */
        public var networkSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceNetworkSettings? = null
        /**
         * The unique serial number of the input device.
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The type of the input device.
         */
        public var type: aws.sdk.kotlin.services.medialive.model.InputDeviceType? = null
        /**
         * Settings that describe an input device that is type UHD.
         */
        public var uhdDeviceSettings: aws.sdk.kotlin.services.medialive.model.InputDeviceUhdSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.InputDeviceSummary) : this() {
            this.arn = x.arn
            this.connectionState = x.connectionState
            this.deviceSettingsSyncState = x.deviceSettingsSyncState
            this.deviceUpdateStatus = x.deviceUpdateStatus
            this.hdDeviceSettings = x.hdDeviceSettings
            this.id = x.id
            this.macAddress = x.macAddress
            this.name = x.name
            this.networkSettings = x.networkSettings
            this.serialNumber = x.serialNumber
            this.type = x.type
            this.uhdDeviceSettings = x.uhdDeviceSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.InputDeviceSummary = InputDeviceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputDeviceHdSettings] inside the given [block]
         */
        public fun hdDeviceSettings(block: aws.sdk.kotlin.services.medialive.model.InputDeviceHdSettings.Builder.() -> kotlin.Unit) {
            this.hdDeviceSettings = aws.sdk.kotlin.services.medialive.model.InputDeviceHdSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputDeviceNetworkSettings] inside the given [block]
         */
        public fun networkSettings(block: aws.sdk.kotlin.services.medialive.model.InputDeviceNetworkSettings.Builder.() -> kotlin.Unit) {
            this.networkSettings = aws.sdk.kotlin.services.medialive.model.InputDeviceNetworkSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.InputDeviceUhdSettings] inside the given [block]
         */
        public fun uhdDeviceSettings(block: aws.sdk.kotlin.services.medialive.model.InputDeviceUhdSettings.Builder.() -> kotlin.Unit) {
            this.uhdDeviceSettings = aws.sdk.kotlin.services.medialive.model.InputDeviceUhdSettings.invoke(block)
        }
    }
}
