// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Live Event input parameters. There can be multiple inputs in a single Live Event.
 */
public class InputSettings private constructor(builder: Builder) {
    /**
     * Used to select the audio stream to decode for inputs that have multiple available.
     */
    public val audioSelectors: List<AudioSelector>? = builder.audioSelectors
    /**
     * Used to select the caption input to use for inputs that have multiple available.
     */
    public val captionSelectors: List<CaptionSelector>? = builder.captionSelectors
    /**
     * Enable or disable the deblock filter when filtering.
     */
    public val deblockFilter: aws.sdk.kotlin.services.medialive.model.InputDeblockFilter? = builder.deblockFilter
    /**
     * Enable or disable the denoise filter when filtering.
     */
    public val denoiseFilter: aws.sdk.kotlin.services.medialive.model.InputDenoiseFilter? = builder.denoiseFilter
    /**
     * Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
     */
    public val filterStrength: kotlin.Int? = builder.filterStrength
    /**
     * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto - filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the input 3) forced - filtering will be applied regardless of input type
     */
    public val inputFilter: aws.sdk.kotlin.services.medialive.model.InputFilter? = builder.inputFilter
    /**
     * Input settings.
     */
    public val networkInputSettings: aws.sdk.kotlin.services.medialive.model.NetworkInputSettings? = builder.networkInputSettings
    /**
     * PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found in the input.
     */
    public val scte35Pid: kotlin.Int? = builder.scte35Pid
    /**
     * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data from SMPTE-2038.
     */
    public val smpte2038DataPreference: aws.sdk.kotlin.services.medialive.model.Smpte2038DataPreference? = builder.smpte2038DataPreference
    /**
     * Loop input if it is a file. This allows a file input to be streamed indefinitely.
     */
    public val sourceEndBehavior: aws.sdk.kotlin.services.medialive.model.InputSourceEndBehavior? = builder.sourceEndBehavior
    /**
     * Informs which video elementary stream to decode for input types that have multiple available.
     */
    public val videoSelector: aws.sdk.kotlin.services.medialive.model.VideoSelector? = builder.videoSelector

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.InputSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputSettings(")
        append("audioSelectors=$audioSelectors,")
        append("captionSelectors=$captionSelectors,")
        append("deblockFilter=$deblockFilter,")
        append("denoiseFilter=$denoiseFilter,")
        append("filterStrength=$filterStrength,")
        append("inputFilter=$inputFilter,")
        append("networkInputSettings=$networkInputSettings,")
        append("scte35Pid=$scte35Pid,")
        append("smpte2038DataPreference=$smpte2038DataPreference,")
        append("sourceEndBehavior=$sourceEndBehavior,")
        append("videoSelector=$videoSelector)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioSelectors?.hashCode() ?: 0
        result = 31 * result + (captionSelectors?.hashCode() ?: 0)
        result = 31 * result + (deblockFilter?.hashCode() ?: 0)
        result = 31 * result + (denoiseFilter?.hashCode() ?: 0)
        result = 31 * result + (filterStrength ?: 0)
        result = 31 * result + (inputFilter?.hashCode() ?: 0)
        result = 31 * result + (networkInputSettings?.hashCode() ?: 0)
        result = 31 * result + (scte35Pid ?: 0)
        result = 31 * result + (smpte2038DataPreference?.hashCode() ?: 0)
        result = 31 * result + (sourceEndBehavior?.hashCode() ?: 0)
        result = 31 * result + (videoSelector?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputSettings

        if (audioSelectors != other.audioSelectors) return false
        if (captionSelectors != other.captionSelectors) return false
        if (deblockFilter != other.deblockFilter) return false
        if (denoiseFilter != other.denoiseFilter) return false
        if (filterStrength != other.filterStrength) return false
        if (inputFilter != other.inputFilter) return false
        if (networkInputSettings != other.networkInputSettings) return false
        if (scte35Pid != other.scte35Pid) return false
        if (smpte2038DataPreference != other.smpte2038DataPreference) return false
        if (sourceEndBehavior != other.sourceEndBehavior) return false
        if (videoSelector != other.videoSelector) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.InputSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Used to select the audio stream to decode for inputs that have multiple available.
         */
        public var audioSelectors: List<AudioSelector>? = null
        /**
         * Used to select the caption input to use for inputs that have multiple available.
         */
        public var captionSelectors: List<CaptionSelector>? = null
        /**
         * Enable or disable the deblock filter when filtering.
         */
        public var deblockFilter: aws.sdk.kotlin.services.medialive.model.InputDeblockFilter? = null
        /**
         * Enable or disable the denoise filter when filtering.
         */
        public var denoiseFilter: aws.sdk.kotlin.services.medialive.model.InputDenoiseFilter? = null
        /**
         * Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
         */
        public var filterStrength: kotlin.Int? = null
        /**
         * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto - filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the input 3) forced - filtering will be applied regardless of input type
         */
        public var inputFilter: aws.sdk.kotlin.services.medialive.model.InputFilter? = null
        /**
         * Input settings.
         */
        public var networkInputSettings: aws.sdk.kotlin.services.medialive.model.NetworkInputSettings? = null
        /**
         * PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found in the input.
         */
        public var scte35Pid: kotlin.Int? = null
        /**
         * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data from SMPTE-2038.
         */
        public var smpte2038DataPreference: aws.sdk.kotlin.services.medialive.model.Smpte2038DataPreference? = null
        /**
         * Loop input if it is a file. This allows a file input to be streamed indefinitely.
         */
        public var sourceEndBehavior: aws.sdk.kotlin.services.medialive.model.InputSourceEndBehavior? = null
        /**
         * Informs which video elementary stream to decode for input types that have multiple available.
         */
        public var videoSelector: aws.sdk.kotlin.services.medialive.model.VideoSelector? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.InputSettings) : this() {
            this.audioSelectors = x.audioSelectors
            this.captionSelectors = x.captionSelectors
            this.deblockFilter = x.deblockFilter
            this.denoiseFilter = x.denoiseFilter
            this.filterStrength = x.filterStrength
            this.inputFilter = x.inputFilter
            this.networkInputSettings = x.networkInputSettings
            this.scte35Pid = x.scte35Pid
            this.smpte2038DataPreference = x.smpte2038DataPreference
            this.sourceEndBehavior = x.sourceEndBehavior
            this.videoSelector = x.videoSelector
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.InputSettings = InputSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.NetworkInputSettings] inside the given [block]
         */
        public fun networkInputSettings(block: aws.sdk.kotlin.services.medialive.model.NetworkInputSettings.Builder.() -> kotlin.Unit) {
            this.networkInputSettings = aws.sdk.kotlin.services.medialive.model.NetworkInputSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.VideoSelector] inside the given [block]
         */
        public fun videoSelector(block: aws.sdk.kotlin.services.medialive.model.VideoSelector.Builder.() -> kotlin.Unit) {
            this.videoSelector = aws.sdk.kotlin.services.medialive.model.VideoSelector.invoke(block)
        }
    }
}
