// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Mpeg2 Settings
 */
public class Mpeg2Settings private constructor(builder: Builder) {
    /**
     * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
     */
    public val adaptiveQuantization: aws.sdk.kotlin.services.medialive.model.Mpeg2AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the value you specify in fixedAFD.
     */
    public val afdSignaling: aws.sdk.kotlin.services.medialive.model.AfdSignaling? = builder.afdSignaling
    /**
     * Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
     */
    public val colorMetadata: aws.sdk.kotlin.services.medialive.model.Mpeg2ColorMetadata? = builder.colorMetadata
    /**
     * Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
     */
    public val colorSpace: aws.sdk.kotlin.services.medialive.model.Mpeg2ColorSpace? = builder.colorSpace
    /**
     * Sets the pixel aspect ratio for the encode.
     */
    public val displayAspectRatio: aws.sdk.kotlin.services.medialive.model.Mpeg2DisplayRatio? = builder.displayAspectRatio
    /**
     * Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean. When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise. When the content is reasonably clean, the filter tends to decrease the bitrate.
     */
    public val filterSettings: aws.sdk.kotlin.services.medialive.model.Mpeg2FilterSettings? = builder.filterSettings
    /**
     * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
     */
    public val fixedAfd: aws.sdk.kotlin.services.medialive.model.FixedAfd? = builder.fixedAfd
    /**
     * description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
     */
    public val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
     */
    public val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * MPEG2: default is open GOP.
     */
    public val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
     */
    public val gopNumBFrames: kotlin.Int? = builder.gopNumBFrames
    /**
     * Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
     */
    public val gopSize: kotlin.Double? = builder.gopSize
    /**
     * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
     */
    public val gopSizeUnits: aws.sdk.kotlin.services.medialive.model.Mpeg2GopSizeUnits? = builder.gopSizeUnits
    /**
     * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
     */
    public val scanType: aws.sdk.kotlin.services.medialive.model.Mpeg2ScanType? = builder.scanType
    /**
     * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
     */
    public val subgopLength: aws.sdk.kotlin.services.medialive.model.Mpeg2SubGopLength? = builder.subgopLength
    /**
     * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the GOP header.
     */
    public val timecodeInsertion: aws.sdk.kotlin.services.medialive.model.Mpeg2TimecodeInsertionBehavior? = builder.timecodeInsertion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.Mpeg2Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Mpeg2Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("afdSignaling=$afdSignaling,")
        append("colorMetadata=$colorMetadata,")
        append("colorSpace=$colorSpace,")
        append("displayAspectRatio=$displayAspectRatio,")
        append("filterSettings=$filterSettings,")
        append("fixedAfd=$fixedAfd,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("gopNumBFrames=$gopNumBFrames,")
        append("gopSize=$gopSize,")
        append("gopSizeUnits=$gopSizeUnits,")
        append("scanType=$scanType,")
        append("subgopLength=$subgopLength,")
        append("timecodeInsertion=$timecodeInsertion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (afdSignaling?.hashCode() ?: 0)
        result = 31 * result + (colorMetadata?.hashCode() ?: 0)
        result = 31 * result + (colorSpace?.hashCode() ?: 0)
        result = 31 * result + (displayAspectRatio?.hashCode() ?: 0)
        result = 31 * result + (filterSettings?.hashCode() ?: 0)
        result = 31 * result + (fixedAfd?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (gopNumBFrames ?: 0)
        result = 31 * result + (gopSize?.hashCode() ?: 0)
        result = 31 * result + (gopSizeUnits?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        result = 31 * result + (subgopLength?.hashCode() ?: 0)
        result = 31 * result + (timecodeInsertion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Mpeg2Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (afdSignaling != other.afdSignaling) return false
        if (colorMetadata != other.colorMetadata) return false
        if (colorSpace != other.colorSpace) return false
        if (displayAspectRatio != other.displayAspectRatio) return false
        if (filterSettings != other.filterSettings) return false
        if (fixedAfd != other.fixedAfd) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (gopNumBFrames != other.gopNumBFrames) return false
        if (gopSize != other.gopSize) return false
        if (gopSizeUnits != other.gopSizeUnits) return false
        if (scanType != other.scanType) return false
        if (subgopLength != other.subgopLength) return false
        if (timecodeInsertion != other.timecodeInsertion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.Mpeg2Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
         */
        public var adaptiveQuantization: aws.sdk.kotlin.services.medialive.model.Mpeg2AdaptiveQuantization? = null
        /**
         * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the value you specify in fixedAFD.
         */
        public var afdSignaling: aws.sdk.kotlin.services.medialive.model.AfdSignaling? = null
        /**
         * Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
         */
        public var colorMetadata: aws.sdk.kotlin.services.medialive.model.Mpeg2ColorMetadata? = null
        /**
         * Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
         */
        public var colorSpace: aws.sdk.kotlin.services.medialive.model.Mpeg2ColorSpace? = null
        /**
         * Sets the pixel aspect ratio for the encode.
         */
        public var displayAspectRatio: aws.sdk.kotlin.services.medialive.model.Mpeg2DisplayRatio? = null
        /**
         * Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean. When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise. When the content is reasonably clean, the filter tends to decrease the bitrate.
         */
        public var filterSettings: aws.sdk.kotlin.services.medialive.model.Mpeg2FilterSettings? = null
        /**
         * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
         */
        public var fixedAfd: aws.sdk.kotlin.services.medialive.model.FixedAfd? = null
        /**
         * description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
         */
        public var framerateDenominator: kotlin.Int? = null
        /**
         * The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
         */
        public var framerateNumerator: kotlin.Int? = null
        /**
         * MPEG2: default is open GOP.
         */
        public var gopClosedCadence: kotlin.Int? = null
        /**
         * Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
         */
        public var gopNumBFrames: kotlin.Int? = null
        /**
         * Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
         */
        public var gopSize: kotlin.Double? = null
        /**
         * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
         */
        public var gopSizeUnits: aws.sdk.kotlin.services.medialive.model.Mpeg2GopSizeUnits? = null
        /**
         * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
         */
        public var scanType: aws.sdk.kotlin.services.medialive.model.Mpeg2ScanType? = null
        /**
         * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
         */
        public var subgopLength: aws.sdk.kotlin.services.medialive.model.Mpeg2SubGopLength? = null
        /**
         * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the GOP header.
         */
        public var timecodeInsertion: aws.sdk.kotlin.services.medialive.model.Mpeg2TimecodeInsertionBehavior? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.Mpeg2Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.afdSignaling = x.afdSignaling
            this.colorMetadata = x.colorMetadata
            this.colorSpace = x.colorSpace
            this.displayAspectRatio = x.displayAspectRatio
            this.filterSettings = x.filterSettings
            this.fixedAfd = x.fixedAfd
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopClosedCadence = x.gopClosedCadence
            this.gopNumBFrames = x.gopNumBFrames
            this.gopSize = x.gopSize
            this.gopSizeUnits = x.gopSizeUnits
            this.scanType = x.scanType
            this.subgopLength = x.subgopLength
            this.timecodeInsertion = x.timecodeInsertion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.Mpeg2Settings = Mpeg2Settings(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.Mpeg2FilterSettings] inside the given [block]
         */
        public fun filterSettings(block: aws.sdk.kotlin.services.medialive.model.Mpeg2FilterSettings.Builder.() -> kotlin.Unit) {
            this.filterSettings = aws.sdk.kotlin.services.medialive.model.Mpeg2FilterSettings.invoke(block)
        }
    }
}
