// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Reserved resources available to use
 */
public class Reservation private constructor(builder: Builder) {
    /**
     * Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Number of reserved resources
     */
    public val count: kotlin.Int? = builder.count
    /**
     * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * Lease duration, e.g. '12'
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * Units for duration, e.g. 'MONTHS'
     */
    public val durationUnits: aws.sdk.kotlin.services.medialive.model.OfferingDurationUnits? = builder.durationUnits
    /**
     * Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
     */
    public val end: kotlin.String? = builder.end
    /**
     * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
     */
    public val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * User specified reservation name
     */
    public val name: kotlin.String? = builder.name
    /**
     * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
     */
    public val offeringDescription: kotlin.String? = builder.offeringDescription
    /**
     * Unique offering ID, e.g. '87654321'
     */
    public val offeringId: kotlin.String? = builder.offeringId
    /**
     * Offering type, e.g. 'NO_UPFRONT'
     */
    public val offeringType: aws.sdk.kotlin.services.medialive.model.OfferingType? = builder.offeringType
    /**
     * AWS region, e.g. 'us-west-2'
     */
    public val region: kotlin.String? = builder.region
    /**
     * Renewal settings for the reservation
     */
    public val renewalSettings: aws.sdk.kotlin.services.medialive.model.RenewalSettings? = builder.renewalSettings
    /**
     * Unique reservation ID, e.g. '1234567'
     */
    public val reservationId: kotlin.String? = builder.reservationId
    /**
     * Resource configuration details
     */
    public val resourceSpecification: aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification? = builder.resourceSpecification
    /**
     * Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
     */
    public val start: kotlin.String? = builder.start
    /**
     * Current state of reservation, e.g. 'ACTIVE'
     */
    public val state: aws.sdk.kotlin.services.medialive.model.ReservationState? = builder.state
    /**
     * A collection of key-value pairs
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Recurring usage charge for each reserved resource, e.g. '157.0'
     */
    public val usagePrice: kotlin.Double? = builder.usagePrice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.Reservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Reservation(")
        append("arn=$arn,")
        append("count=$count,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("durationUnits=$durationUnits,")
        append("end=$end,")
        append("fixedPrice=$fixedPrice,")
        append("name=$name,")
        append("offeringDescription=$offeringDescription,")
        append("offeringId=$offeringId,")
        append("offeringType=$offeringType,")
        append("region=$region,")
        append("renewalSettings=$renewalSettings,")
        append("reservationId=$reservationId,")
        append("resourceSpecification=$resourceSpecification,")
        append("start=$start,")
        append("state=$state,")
        append("tags=$tags,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (count ?: 0)
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (durationUnits?.hashCode() ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (offeringDescription?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (renewalSettings?.hashCode() ?: 0)
        result = 31 * result + (reservationId?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecification?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Reservation

        if (arn != other.arn) return false
        if (count != other.count) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (durationUnits != other.durationUnits) return false
        if (end != other.end) return false
        if (fixedPrice != other.fixedPrice) return false
        if (name != other.name) return false
        if (offeringDescription != other.offeringDescription) return false
        if (offeringId != other.offeringId) return false
        if (offeringType != other.offeringType) return false
        if (region != other.region) return false
        if (renewalSettings != other.renewalSettings) return false
        if (reservationId != other.reservationId) return false
        if (resourceSpecification != other.resourceSpecification) return false
        if (start != other.start) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.Reservation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
         */
        public var arn: kotlin.String? = null
        /**
         * Number of reserved resources
         */
        public var count: kotlin.Int? = null
        /**
         * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
         */
        public var currencyCode: kotlin.String? = null
        /**
         * Lease duration, e.g. '12'
         */
        public var duration: kotlin.Int? = null
        /**
         * Units for duration, e.g. 'MONTHS'
         */
        public var durationUnits: aws.sdk.kotlin.services.medialive.model.OfferingDurationUnits? = null
        /**
         * Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
         */
        public var end: kotlin.String? = null
        /**
         * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
         */
        public var fixedPrice: kotlin.Double? = null
        /**
         * User specified reservation name
         */
        public var name: kotlin.String? = null
        /**
         * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
         */
        public var offeringDescription: kotlin.String? = null
        /**
         * Unique offering ID, e.g. '87654321'
         */
        public var offeringId: kotlin.String? = null
        /**
         * Offering type, e.g. 'NO_UPFRONT'
         */
        public var offeringType: aws.sdk.kotlin.services.medialive.model.OfferingType? = null
        /**
         * AWS region, e.g. 'us-west-2'
         */
        public var region: kotlin.String? = null
        /**
         * Renewal settings for the reservation
         */
        public var renewalSettings: aws.sdk.kotlin.services.medialive.model.RenewalSettings? = null
        /**
         * Unique reservation ID, e.g. '1234567'
         */
        public var reservationId: kotlin.String? = null
        /**
         * Resource configuration details
         */
        public var resourceSpecification: aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification? = null
        /**
         * Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
         */
        public var start: kotlin.String? = null
        /**
         * Current state of reservation, e.g. 'ACTIVE'
         */
        public var state: aws.sdk.kotlin.services.medialive.model.ReservationState? = null
        /**
         * A collection of key-value pairs
         */
        public var tags: Map<String, String>? = null
        /**
         * Recurring usage charge for each reserved resource, e.g. '157.0'
         */
        public var usagePrice: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.Reservation) : this() {
            this.arn = x.arn
            this.count = x.count
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.durationUnits = x.durationUnits
            this.end = x.end
            this.fixedPrice = x.fixedPrice
            this.name = x.name
            this.offeringDescription = x.offeringDescription
            this.offeringId = x.offeringId
            this.offeringType = x.offeringType
            this.region = x.region
            this.renewalSettings = x.renewalSettings
            this.reservationId = x.reservationId
            this.resourceSpecification = x.resourceSpecification
            this.start = x.start
            this.state = x.state
            this.tags = x.tags
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.Reservation = Reservation(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.RenewalSettings] inside the given [block]
         */
        public fun renewalSettings(block: aws.sdk.kotlin.services.medialive.model.RenewalSettings.Builder.() -> kotlin.Unit) {
            this.renewalSettings = aws.sdk.kotlin.services.medialive.model.RenewalSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification] inside the given [block]
         */
        public fun resourceSpecification(block: aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification.Builder.() -> kotlin.Unit) {
            this.resourceSpecification = aws.sdk.kotlin.services.medialive.model.ReservationResourceSpecification.invoke(block)
        }
    }
}
