// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.medialive.model



/**
 * Contains information on a single schedule action.
 */
public class ScheduleAction private constructor(builder: Builder) {
    /**
     * The name of the action, must be unique within the schedule. This name provides the main reference to an action once it is added to the schedule. A name is unique if it is no longer in the schedule. The schedule is automatically cleaned up to remove actions with a start time of more than 1 hour ago (approximately) so at that point a name can be reused.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * Settings for this schedule action.
     */
    public val scheduleActionSettings: aws.sdk.kotlin.services.medialive.model.ScheduleActionSettings? = builder.scheduleActionSettings
    /**
     * The time for the action to start in the channel.
     */
    public val scheduleActionStartSettings: aws.sdk.kotlin.services.medialive.model.ScheduleActionStartSettings? = builder.scheduleActionStartSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.medialive.model.ScheduleAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleAction(")
        append("actionName=$actionName,")
        append("scheduleActionSettings=$scheduleActionSettings,")
        append("scheduleActionStartSettings=$scheduleActionStartSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (scheduleActionSettings?.hashCode() ?: 0)
        result = 31 * result + (scheduleActionStartSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleAction

        if (actionName != other.actionName) return false
        if (scheduleActionSettings != other.scheduleActionSettings) return false
        if (scheduleActionStartSettings != other.scheduleActionStartSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.medialive.model.ScheduleAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the action, must be unique within the schedule. This name provides the main reference to an action once it is added to the schedule. A name is unique if it is no longer in the schedule. The schedule is automatically cleaned up to remove actions with a start time of more than 1 hour ago (approximately) so at that point a name can be reused.
         */
        public var actionName: kotlin.String? = null
        /**
         * Settings for this schedule action.
         */
        public var scheduleActionSettings: aws.sdk.kotlin.services.medialive.model.ScheduleActionSettings? = null
        /**
         * The time for the action to start in the channel.
         */
        public var scheduleActionStartSettings: aws.sdk.kotlin.services.medialive.model.ScheduleActionStartSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.medialive.model.ScheduleAction) : this() {
            this.actionName = x.actionName
            this.scheduleActionSettings = x.scheduleActionSettings
            this.scheduleActionStartSettings = x.scheduleActionStartSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.medialive.model.ScheduleAction = ScheduleAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.ScheduleActionSettings] inside the given [block]
         */
        public fun scheduleActionSettings(block: aws.sdk.kotlin.services.medialive.model.ScheduleActionSettings.Builder.() -> kotlin.Unit) {
            this.scheduleActionSettings = aws.sdk.kotlin.services.medialive.model.ScheduleActionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.medialive.model.ScheduleActionStartSettings] inside the given [block]
         */
        public fun scheduleActionStartSettings(block: aws.sdk.kotlin.services.medialive.model.ScheduleActionStartSettings.Builder.() -> kotlin.Unit) {
            this.scheduleActionStartSettings = aws.sdk.kotlin.services.medialive.model.ScheduleActionStartSettings.invoke(block)
        }
    }
}
